/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.forest.security.AuthenticationManagerFactory;
import com.ontotext.forest.security.provider.openid.OpenIdAuthenticationProvider;
import com.ontotext.forest.security.provider.openid.OpenIdConfig;
import com.ontotext.graphdb.Config;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/rest/openid"})
@Hidden
public class OpenIdProxyController {
    @Autowired
    private AuthenticationManagerFactory authenticationManagerFactory;
    @Autowired
    private ResourceUtils resourceUtils;
    private OpenIdConfig openIdConfig;
    private CloseableHttpClient httpClient;

    @PostConstruct
    public void init() {
        OpenIdAuthenticationProvider openIdAuthenticationProvider = this.authenticationManagerFactory.getOpenIdAuthenticationProvider();
        if (openIdAuthenticationProvider != null) {
            this.openIdConfig = openIdAuthenticationProvider.getOpenIdConfig();
            int maxConnections = (Integer)this.resourceUtils.getNewOrDeprecatedProperty("graphdb.workbench.maxConnections", "app.maxConnections");
            this.httpClient = HttpClientBuilder.create().useSystemProperties().disableAutomaticRetries().setSSLSocketFactory(Config.createSSLSocketFactory()).setMaxConnPerRoute(maxConnections).setMaxConnTotal(maxConnections).build();
        }
    }

    @RequestMapping(value={"/jwks"}, method={RequestMethod.GET})
    public void jwks(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.openIdConfig != null) {
            this.proxyRequest(request, response, this.openIdConfig.getOidcJwksUri());
        } else {
            response.sendError(404);
        }
    }

    @RequestMapping(value={"/token"}, method={RequestMethod.POST})
    public void token(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.openIdConfig != null) {
            this.proxyRequest(request, response, this.openIdConfig.getOidcTokenEndpoint());
        } else {
            response.sendError(404);
        }
    }

    public void proxyRequest(HttpServletRequest request, HttpServletResponse response, String uri) throws IOException {
        HttpUriRequest proxiedRequest = OpenIdProxyController.createCopyRequest(request, uri);
        try (CloseableHttpResponse proxiedResponse = this.httpClient.execute(proxiedRequest);){
            OpenIdProxyController.copyResponse((HttpResponse)proxiedResponse, response);
        }
    }

    public static void copyResponse(HttpResponse proxiedResponse, HttpServletResponse response) throws IOException {
        response.setStatus(proxiedResponse.getStatusLine().getStatusCode());
        for (Header header : proxiedResponse.getAllHeaders()) {
            String headerName = header.getName();
            if (headerName.equalsIgnoreCase("transfer-encoding") || headerName.equalsIgnoreCase("content-length") || OpenIdProxyController.isAccessControlHeader(headerName)) continue;
            response.addHeader(header.getName(), header.getValue());
        }
        HttpEntity entity = proxiedResponse.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            ServletOutputStream os = response.getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            IOUtils.closeQuietly((InputStream)is);
        }
        response.flushBuffer();
    }

    public static HttpUriRequest createCopyRequest(HttpServletRequest request, String uri) throws IOException {
        RequestBuilder rb = RequestBuilder.create((String)request.getMethod());
        rb.setUri(uri);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName.equalsIgnoreCase("host") || headerName.equalsIgnoreCase("authorization") || headerName.equalsIgnoreCase("content-length") || headerName.equalsIgnoreCase("transfer-encoding") || OpenIdProxyController.isAccessControlHeader(headerName)) continue;
            String headerValue = request.getHeader(headerName);
            rb.addHeader(headerName, headerValue);
        }
        for (Map.Entry e : request.getParameterMap().entrySet()) {
            for (String value : (String[])e.getValue()) {
                rb.addParameter((String)e.getKey(), value);
            }
        }
        return rb.build();
    }

    private static boolean isAccessControlHeader(String headerName) {
        return headerName.toLowerCase().startsWith("access-control-");
    }
}

