/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

public class OpenIdAudienceValidator
implements OAuth2TokenValidator<Jwt> {
    private final String audience;
    private final boolean requireAudience;

    public OpenIdAudienceValidator(String audience, boolean requireAudience) {
        this.audience = audience;
        this.requireAudience = requireAudience;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        List audiences = jwt.getAudience();
        if (this.requireAudience) {
            if (audiences == null) {
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "Missing aud claim", null)});
            }
            if (!audiences.contains(this.audience)) {
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "The aud claim is not valid", null)});
            }
            return OAuth2TokenValidatorResult.success();
        }
        if (audiences != null && !audiences.isEmpty()) {
            if (!audiences.contains(this.audience)) {
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "The aud claim is not valid", null)});
            }
            return OAuth2TokenValidatorResult.success();
        }
        for (Map.Entry claim : jwt.getClaims().entrySet()) {
            if (!(claim.getValue() instanceof String) || !this.audience.equals(claim.getValue())) continue;
            return OAuth2TokenValidatorResult.success();
        }
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "The aud claim is not valid", null)});
    }
}

