/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.UserDeletedEvent;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;

@Service(value="accountsService")
public class ProxyAccountsService
implements AccountsService,
ApplicationContextAware,
ApplicationEventPublisherAware {
    private ApplicationContext applicationContext;
    private AccountsService accountsServiceImpl;
    @Autowired
    private SecurityConfig securityConfig;
    private ApplicationEventPublisher eventPublisher;

    @PostConstruct
    public void init() {
        AutowireCapableBeanFactory factory = this.applicationContext.getAutowireCapableBeanFactory();
        this.accountsServiceImpl = (AccountsService)factory.createBean(this.securityConfig.getAccountsServiceImplClass());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public Collection<Account> getAll() {
        return this.accountsServiceImpl.getAll();
    }

    @Nullable
    public Account getAccount(String username) {
        return this.accountsServiceImpl.getAccount(username);
    }

    public Account getDefaultAdminAccount() {
        return this.accountsServiceImpl.getDefaultAdminAccount();
    }

    public void editUserAccount(Account user, boolean updatePassword) {
        this.accountsServiceImpl.editUserAccount(user, updatePassword);
    }

    public void saveUser(Account account) {
        this.accountsServiceImpl.saveUser(account);
    }

    public void addNewUser(Account user) {
        this.accountsServiceImpl.addNewUser(user);
    }

    public void delete(String username) {
        this.accountsServiceImpl.delete(username);
        this.eventPublisher.publishEvent((ApplicationEvent)new UserDeletedEvent(username));
    }

    public boolean isLocal() {
        return this.accountsServiceImpl.isLocal();
    }

    public AuthenticatedUser loadUserByUsername(String username) {
        return this.accountsServiceImpl.loadUserByUsername(username);
    }

    public AuthenticatedUser loadUserByUsername(String username, Collection<GrantedAuthority> authorities) {
        return this.accountsServiceImpl.loadUserByUsername(username, authorities);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getImplementationName() {
        return this.accountsServiceImpl.getImplementationName();
    }

    public Class<? extends AccountsService> getImplementationClass() {
        return this.accountsServiceImpl.getImplementationClass();
    }

    @VisibleForTesting
    public AccountsService getAccountsServiceImpl() {
        return this.accountsServiceImpl;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.accountsServiceImpl.getAuthenticationProvider();
    }
}

