/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.security.SecurityConfig;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

public class ExtendedAnonymousFilter
extends AnonymousAuthenticationFilter {
    @Autowired
    private SecurityConfig securityConfig;

    public ExtendedAnonymousFilter() {
        super("extendedAnonymousFilter");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.securityConfig.hasToCheckAuthentication()) {
            if (this.securityConfig.hasOverrideAuthority()) {
                SecurityContextHolder.getContext().setAuthentication(this.securityConfig.getOverrideAuthentication());
                chain.doFilter(req, res);
                return;
            }
            if (this.securityConfig.isEnabledFreeAccess() && SecurityContextHolder.getContext().getAuthentication() == null) {
                SecurityContextHolder.getContext().setAuthentication(this.securityConfig.getFreeAccessAuthentication());
                chain.doFilter(req, res);
                return;
            }
        }
        super.doFilter(req, res, chain);
    }
}

