/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters.duration;

import com.ontotext.rdf.transformer.graphql.json.converters.duration.BaseDurationValueConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class YearMonthDurationValueConverter
extends BaseDurationValueConverter {
    private static final Pattern DURATION_PATTERN = Pattern.compile("-?P(\\d+Y)?(\\d+M)?");

    @Override
    protected boolean isDurationValid(String value) {
        Matcher matcher = DURATION_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)matcher.group(1)) || !StringUtils.isBlank((CharSequence)matcher.group(2));
    }

    @Override
    public String getSupportedType() {
        return "YearMonthDuration";
    }
}

