/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters.datetime;

import com.ontotext.rdf.transformer.graphql.json.converters.AbstractValueConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Calendar;
import java.util.Date;

public abstract class BaseTemporalValueConverter
extends AbstractValueConverter {
    private static final long YEAR_ZERO_TIMESTAMP = -62167392000000L;
    private static final ZoneId UTC = ZoneId.of("Z");
    private DateTimeFormatter formatterWithTimeZone;

    @Override
    public Object convert(Object value) {
        if (value instanceof Calendar) {
            Date date = ((Calendar)value).getTime();
            long timestamp = this.correctZeroYear(date, date.getTime());
            return this.getDateTimeFormatter().withZone(((Calendar)value).getTimeZone().toZoneId()).format(Instant.ofEpochMilli(timestamp));
        }
        if (value instanceof Date) {
            long timestamp = this.correctZeroYear((Date)value, ((Date)value).getTime());
            return this.getFormatterWithTimeZone().format(Instant.ofEpochMilli(timestamp));
        }
        if (value instanceof TemporalAccessor) {
            return this.getDateTimeFormatter().format((TemporalAccessor)value);
        }
        if (value instanceof Number) {
            long timestamp = ((Number)value).longValue();
            timestamp = this.correctZeroYear(Date.from(Instant.ofEpochMilli(timestamp)), timestamp);
            return this.getFormatterWithTimeZone().format(Instant.ofEpochMilli(timestamp));
        }
        if (value instanceof String) {
            return this.convertFromString((String)value);
        }
        return null;
    }

    private Object convertFromString(String value) {
        try {
            DateTimeFormatter specificFormatter = this.getFormatterWithTimeZone();
            TemporalAccessor temporalAccessor = (TemporalAccessor)specificFormatter.parse((CharSequence)value, this.getSpecificType());
            return specificFormatter.format(temporalAccessor);
        }
        catch (DateTimeParseException dtpe) {
            if (BaseTemporalValueConverter.isMissingZoneOffset(dtpe)) {
                return this.convertFromString(value + "Z");
            }
            return value;
        }
    }

    static boolean isMissingZoneOffset(Throwable error) {
        if (error == null) {
            return false;
        }
        if (error instanceof DateTimeException && error.getMessage().startsWith("Unable to obtain ZoneOffset")) {
            return true;
        }
        return BaseTemporalValueConverter.isMissingZoneOffset(error.getCause());
    }

    private long correctZeroYear(Date value, long timestamp) {
        if (timestamp < -62167392000000L) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(value);
            calendar.set(0, 0);
            calendar.add(1, -1);
            return calendar.getTimeInMillis();
        }
        return timestamp;
    }

    @Override
    public Object convertStrict(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Calendar || value instanceof Date || value instanceof TemporalAccessor || value instanceof Number || value instanceof String)) {
            throw this.invalidValue(value);
        }
        if (value instanceof String) {
            try {
                DateTimeFormatter specificFormatter = this.getFormatterWithTimeZone();
                TemporalAccessor temporalAccessor = (TemporalAccessor)specificFormatter.parse((CharSequence)value.toString(), this.getSpecificType());
                return specificFormatter.format(temporalAccessor);
            }
            catch (DateTimeParseException dtpe) {
                throw this.invalidValue(value);
            }
        }
        return this.convert(value);
    }

    protected DateTimeFormatter getFormatterWithTimeZone() {
        if (this.formatterWithTimeZone == null) {
            this.formatterWithTimeZone = this.getDateTimeFormatter().withZone(UTC);
        }
        return this.formatterWithTimeZone;
    }

    abstract DateTimeFormatter getDateTimeFormatter();

    abstract <T> TemporalQuery<T> getSpecificType();
}

