/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters;

import com.ontotext.rdf.transformer.graphql.json.converters.BaseNumberValueConverter;
import java.math.BigDecimal;

public class DecimalValueConverter
extends BaseNumberValueConverter {
    @Override
    public Object convert(Object decimal) {
        if (decimal instanceof Double) {
            return BigDecimal.valueOf((Double)decimal).toString();
        }
        if (decimal instanceof BigDecimal) {
            return decimal.toString();
        }
        if (decimal instanceof String) {
            return this.stringToBigDecimal(decimal).toString();
        }
        if (decimal instanceof Float) {
            return decimal.toString();
        }
        if (decimal instanceof Number) {
            return BigDecimal.valueOf(((Number)decimal).doubleValue()).toString();
        }
        return null;
    }

    @Override
    public Object convertStrict(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number) && !(value instanceof String)) {
            throw this.invalidValue(value);
        }
        return this.convert(value);
    }

    @Override
    public String getSupportedType() {
        return "Decimal";
    }
}

