/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.google.common.collect.ImmutableSet;
import com.ontotext.models.SomlSchema;
import com.ontotext.rdf.transformer.RdfTransformer;
import com.ontotext.rdf.transformer.RdfTransformerFactory;
import com.ontotext.rdf.transformer.ValueSerializationMode;
import com.ontotext.rdf.transformer.ValueSerializer;
import com.ontotext.rdf.transformer.graphql.DefaultGraphQlResultBuilderFactory;
import com.ontotext.rdf.transformer.graphql.GraphQlResultBuilderFactory;
import com.ontotext.rdf.transformer.graphql.json.JsonValueSerializer;
import com.ontotext.rdf.transformer.graphql.json.Rdf2GraphQlNodeTransformer;
import com.ontotext.rdf.transformer.graphql.json.ValueConverterFactory;
import java.util.Set;

public class GraphQlRdfNodeTransformerFactory
implements RdfTransformerFactory {
    private final ValueSerializer valueSerializer;
    private final ValueSerializationMode serializationMode;
    private GraphQlResultBuilderFactory resultBuilderFactory;
    private final Set<String> supportedFormats;

    public GraphQlRdfNodeTransformerFactory() {
        this(new DefaultGraphQlResultBuilderFactory());
    }

    public GraphQlRdfNodeTransformerFactory(GraphQlResultBuilderFactory resultBuilderFactory) {
        this(ValueSerializationMode.DEFAULT, resultBuilderFactory);
    }

    public GraphQlRdfNodeTransformerFactory(ValueSerializationMode serializationMode, GraphQlResultBuilderFactory resultBuilderFactory) {
        this.valueSerializer = GraphQlRdfNodeTransformerFactory.createSerializerForMode(serializationMode);
        this.serializationMode = serializationMode;
        this.resultBuilderFactory = resultBuilderFactory;
        this.supportedFormats = ImmutableSet.builder().addAll(resultBuilderFactory.getSupportedMimeTypes()).build();
    }

    public RdfTransformer createTransformer(String format, SomlSchema schema) {
        if (!this.supportedFormats.contains(format)) {
            throw new IllegalArgumentException("Unsupported format: " + format + ". Supported formats are: " + String.valueOf(this.supportedFormats));
        }
        return new Rdf2GraphQlNodeTransformer(format, schema, this.valueSerializer, this.resultBuilderFactory);
    }

    public RdfTransformerFactory withValueSerializationMode(ValueSerializationMode mode) {
        return new GraphQlRdfNodeTransformerFactory(mode, this.resultBuilderFactory);
    }

    private static ValueSerializer createSerializerForMode(ValueSerializationMode serializationMode) {
        if (serializationMode == ValueSerializationMode.STRICT) {
            return new JsonValueSerializer(serializationMode, ValueConverterFactory.strictConverters());
        }
        return new JsonValueSerializer(serializationMode, ValueConverterFactory.relaxedConverters());
    }

    public Set<String> outputFormat() {
        return this.supportedFormats;
    }

    public ValueSerializationMode getValueSerializationMode() {
        return this.serializationMode;
    }
}

