/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql;

import com.ontotext.rdf.transformer.graphql.GraphQlResultBuilder;
import com.ontotext.rdf.transformer.graphql.GraphQlResultBuilderFactory;
import com.ontotext.rdf.transformer.graphql.java.JavaGraphQlResultBuilderFactory;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultGraphQlResultBuilderFactory
implements GraphQlResultBuilderFactory {
    private static Map<String, GraphQlResultBuilderFactory> buildersByMimeType;
    private static final GraphQlResultBuilderFactory DEFAULT_FACTORY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBuilders() {
        if (buildersByMimeType != null) {
            return;
        }
        Class<DefaultGraphQlResultBuilderFactory> clazz = DefaultGraphQlResultBuilderFactory.class;
        synchronized (DefaultGraphQlResultBuilderFactory.class) {
            if (buildersByMimeType != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            LinkedHashMap<String, GraphQlResultBuilderFactory> factoryMap = new LinkedHashMap<String, GraphQlResultBuilderFactory>();
            List builderFactories = PluginsManager.loadPlugins(GraphQlResultBuilderFactory.class);
            for (GraphQlResultBuilderFactory builderFactory : builderFactories) {
                Set<String> supportedMimeTypes = builderFactory.getSupportedMimeTypes();
                for (String supportedMimeType : supportedMimeTypes) {
                    factoryMap.putIfAbsent(supportedMimeType, builderFactory);
                }
            }
            if (factoryMap.isEmpty()) {
                Loggers.graphqlLogger().info("Using the default result factory: {}", DEFAULT_FACTORY.getClass());
                for (String supportedMimeType : DEFAULT_FACTORY.getSupportedMimeTypes()) {
                    factoryMap.putIfAbsent(supportedMimeType, DEFAULT_FACTORY);
                }
            }
            buildersByMimeType = factoryMap;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public GraphQlResultBuilder newBuilder(String mimeType) {
        DefaultGraphQlResultBuilderFactory.loadBuilders();
        GraphQlResultBuilderFactory builderFactory = buildersByMimeType.get(mimeType);
        if (builderFactory == null) {
            throw new IllegalArgumentException(String.format("Unsupported mimeType %s. The supported mime types are %s", mimeType, String.join((CharSequence)", ", this.getSupportedMimeTypes())));
        }
        return builderFactory.newBuilder(mimeType);
    }

    @Override
    public Set<String> getSupportedMimeTypes() {
        DefaultGraphQlResultBuilderFactory.loadBuilders();
        return buildersByMimeType.keySet();
    }

    static {
        DEFAULT_FACTORY = new JavaGraphQlResultBuilderFactory();
    }
}

