/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.injection.TargetQueryParserFactory;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.rdf.api.Graph;

public class OntopNativeMappingParser
implements SQLMappingParser {
    private static final ImmutableList<String> DEPRECATED_TAGS = ImmutableList.of((Object)"[ClassDeclaration]", (Object)"[ObjectPropertyDeclaration]", (Object)"[DataPropertyDeclaration]");
    private static final String SOURCE_DECLARATION_TAG = "[SourceDeclaration]";
    private static final String COMMENT_SYMBOL = ";";
    private final TargetQueryParserFactory targetQueryParserFactory;
    private final SQLPPMappingFactory ppMappingFactory;
    private final SpecificationFactory specificationFactory;
    private final SQLPPSourceQueryFactory sourceQueryFactory;

    @Inject
    private OntopNativeMappingParser(SpecificationFactory specificationFactory, TargetQueryParserFactory targetQueryParserFactory, SQLPPMappingFactory ppMappingFactory, SQLPPSourceQueryFactory sourceQueryFactory) {
        this.targetQueryParserFactory = targetQueryParserFactory;
        this.ppMappingFactory = ppMappingFactory;
        this.specificationFactory = specificationFactory;
        this.sourceQueryFactory = sourceQueryFactory;
    }

    public SQLPPMapping parse(File file) throws InvalidMappingException, MappingIOException {
        SQLPPMapping sQLPPMapping;
        if (!file.exists()) {
            throw new MappingIOException("WARNING: Cannot locate OBDA file at: " + file.getPath());
        }
        if (!file.canRead()) {
            throw new MappingIOException(String.format("Error while reading the file located at %s.\nMake sure you have the read permission at the location specified.", file.getAbsolutePath()));
        }
        FileReader reader = new FileReader(file);
        try {
            sQLPPMapping = this.load(reader, this.specificationFactory, this.ppMappingFactory, file.getName());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MappingIOException((Exception)e);
            }
        }
        ((Reader)reader).close();
        return sQLPPMapping;
    }

    public SQLPPMapping parse(Reader reader) throws InvalidMappingException, MappingIOException {
        return this.load(reader, this.specificationFactory, this.ppMappingFactory, ".obda file");
    }

    public SQLPPMapping parse(Graph mappingGraph) {
        throw new IllegalArgumentException("The Ontop native mapping language has no RDF serialization. Passing a RDF graphto the OntopNativeMappingParser is thus invalid.");
    }

    private SQLPPMapping load(Reader reader, SpecificationFactory specificationFactory, SQLPPMappingFactory ppMappingFactory, String fileName) throws MappingIOException, InvalidMappingException {
        ImmutableMap.Builder prefixes = ImmutableMap.builder();
        ImmutableList.Builder mappings = ImmutableList.builder();
        ArrayList<String> invalidMappingIndicators = new ArrayList<String>();
        try (LineNumberReader lineNumberReader = new LineNumberReader(reader);){
            try {
                String line;
                while ((line = lineNumberReader.readLine()) != null) {
                    if (line.isEmpty() || line.trim().indexOf(COMMENT_SYMBOL) == 0) continue;
                    if (line.contains("[PrefixDeclaration]")) {
                        prefixes.putAll(OntopNativeMappingParser.readPrefixDeclaration(lineNumberReader));
                        continue;
                    }
                    if (line.contains("[MappingDeclaration]")) {
                        TargetQueryParser parser = this.targetQueryParserFactory.createParser(specificationFactory.createPrefixManager(prefixes.build()));
                        mappings.addAll(this.readMappingDeclaration(lineNumberReader, parser, invalidMappingIndicators));
                        continue;
                    }
                    DEPRECATED_TAGS.stream().filter(line::contains).forEach(tag -> {
                        throw new RuntimeException("The tag " + tag + " is no longer supported. You may safely remove the content from the file.");
                    });
                    if (line.contains(SOURCE_DECLARATION_TAG)) {
                        throw new RuntimeException("Source declaration is not supported anymore (since 3.0). Please give this information with the Ontop configuration.");
                    }
                    throw new RuntimeException("Unknown syntax: " + line);
                }
            }
            catch (Exception e) {
                throw new IOException(String.format("ERROR reading %s at line: %d\nMESSAGE: %s", fileName, lineNumberReader.getLineNumber(), e.getMessage()), e);
            }
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
        if (!invalidMappingIndicators.isEmpty()) {
            throw new InvalidMappingException("\nThe syntax of the mapping is invalid (and therefore cannot be processed). Problems:\n\n" + String.join((CharSequence)"\n", invalidMappingIndicators));
        }
        PrefixManager prefixManager = specificationFactory.createPrefixManager(prefixes.build());
        return ppMappingFactory.createSQLPreProcessedMapping(mappings.build(), prefixManager);
    }

    private static ImmutableMap<String, String> readPrefixDeclaration(BufferedReader reader) throws IOException {
        String line;
        ImmutableMap.Builder prefixes = ImmutableMap.builder();
        while (!(line = reader.readLine()).isEmpty()) {
            String[] tokens = line.split("[\t| ]+");
            prefixes.put((Object)tokens[0], (Object)tokens[1]);
        }
        return prefixes.build();
    }

    private ImmutableList<SQLPPTriplesMap> readMappingDeclaration(LineNumberReader reader, TargetQueryParser parser, List<String> invalidMappingIndicators) throws IOException {
        String line;
        ImmutableList.Builder mappings = ImmutableList.builder();
        MappingBuilder current = new MappingBuilder(invalidMappingIndicators, reader::getLineNumber);
        String currentLabel = "";
        block10: while ((line = reader.readLine()) != null) {
            String label;
            if (line.trim().equals("]]")) {
                current.build().ifPresent(arg_0 -> ((ImmutableList.Builder)mappings).add(arg_0));
                return mappings.build();
            }
            if (line.isEmpty()) {
                current.build().ifPresent(arg_0 -> ((ImmutableList.Builder)mappings).add(arg_0));
                current = new MappingBuilder(invalidMappingIndicators, reader::getLineNumber);
                continue;
            }
            if (line.trim().indexOf(COMMENT_SYMBOL) == 0 || !current.isValid()) continue;
            String[] tokens = line.split("[\t| ]+", 2);
            String value = tokens[tokens.length - 1].trim();
            if (tokens.length > 1 && !(label = tokens[0].trim()).isEmpty()) {
                currentLabel = label;
            }
            switch (currentLabel) {
                case "mappingId": {
                    current.setMappingId(value);
                    continue block10;
                }
                case "target": {
                    current.setTarget(value, parser);
                    continue block10;
                }
                case "source": {
                    current.setSource(value);
                    continue block10;
                }
            }
            throw new IOException(String.format("Unknown parameter name \"%s\" at line: %d.", tokens[0], reader.getLineNumber()));
        }
        throw new IOException(String.format("End collection symbol %s is missing.", "]]"));
    }

    private final class MappingBuilder {
        private final List<String> invalidMappingIndicators;
        private final Supplier<Integer> line;
        private String mappingId = "";
        private final ImmutableList.Builder<String> sourceQuery = ImmutableList.builder();
        private String targetString = null;
        private ImmutableList<TargetAtom> targetQuery = null;
        boolean isMappingValid = true;

        MappingBuilder(List<String> invalidMappingIndicators, Supplier<Integer> line) {
            this.invalidMappingIndicators = invalidMappingIndicators;
            this.line = line;
        }

        private void fail(String message) {
            this.invalidMappingIndicators.add((!this.mappingId.isEmpty() ? String.format("MappingId = '%s'\n", this.mappingId) : "") + message);
            this.isMappingValid = false;
        }

        boolean isValid() {
            return this.isMappingValid;
        }

        Optional<OntopNativeSQLPPTriplesMap> build() {
            return !this.mappingId.isEmpty() && this.isMappingValid ? Optional.of(new OntopNativeSQLPPTriplesMap(this.mappingId, OntopNativeMappingParser.this.sourceQueryFactory.createSourceQuery(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)this.sourceQuery.build())), this.targetString, this.targetQuery)) : Optional.empty();
        }

        void setMappingId(String value) {
            this.mappingId = value;
            if (this.mappingId.isEmpty()) {
                this.fail(String.format("Line %d: Mapping ID is missing\n", this.line.get()));
            }
        }

        void setTarget(String value, TargetQueryParser parser) {
            this.targetString = value;
            if (!this.targetString.isEmpty()) {
                try {
                    this.targetQuery = parser.parse(this.targetString);
                }
                catch (TargetQueryParserException e) {
                    this.fail(String.format("Line %d: Invalid target: '%s'\nDebug information\n%s", this.line.get(), this.targetString, e.getMessage()));
                }
            } else {
                this.fail(String.format("Line %d: Target is missing\n", this.line.get()));
            }
        }

        void setSource(String value) {
            if (!value.isEmpty()) {
                this.sourceQuery.add((Object)value);
            } else {
                this.fail(String.format("Line %d: Source query is missing\n", this.line.get()));
            }
        }
    }
}

