/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.entitychange;

import com.google.common.collect.Iterables;
import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.SnippetResult;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangePersistence;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntityChangeResult
implements DocumentsResult {
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private static final int DEFAULT_OPERATION_NUMBER = 10;
    private final List<List<EntityItem>> previousResultsCache;
    private final Logger logger;
    private final EntityChangePersistence persistence;
    private final int userSuppliedLimit;
    private int currentPagingOffset;
    private int currentPagingLimit;
    private long totalSize = -1L;
    private Iterator<EntityItem> iterator;
    private EntityItem currentHit;
    private List<EntityItem> searchHits;
    private boolean endReachedOnce;
    private boolean noMoreStoredResults;
    private final String subjectMatch;
    private String operationNumber;
    private String txId;
    private boolean addOnly;
    private List<IRI> transactionIds;

    EntityChangeResult(Logger logger, int userSuppliedOffset, int userSuppliedLimit, @Nullable String subjectMatch, String txId, String operationNumber, boolean addOnly, EntityChangePersistence persistence) {
        this.logger = logger;
        this.userSuppliedLimit = userSuppliedLimit;
        this.currentPagingOffset = userSuppliedOffset;
        this.currentPagingLimit = userSuppliedLimit > 0 ? userSuppliedLimit : 1000;
        this.subjectMatch = subjectMatch;
        this.operationNumber = operationNumber;
        this.txId = txId;
        this.addOnly = addOnly;
        this.persistence = persistence;
        this.previousResultsCache = new ArrayList<List<EntityItem>>();
        this.advancePage();
    }

    private void advancePage() {
        boolean isFirstPage;
        this.loadTransactionRange();
        boolean bl = isFirstPage = this.searchHits == null;
        if (this.userSuppliedLimit != 0 && !isFirstPage) {
            return;
        }
        if (!isFirstPage) {
            this.currentPagingOffset += this.searchHits.size();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Advancing page: offset: {}, limit: {}, txIds: {}", new Object[]{this.currentPagingOffset, this.currentPagingLimit, this.transactionIds});
        }
        if (this.transactionIds.isEmpty()) {
            this.searchHits = Collections.emptyList();
        } else {
            this.searchHits = this.addOnly ? this.persistence.getAddedEntities(this.transactionIds, this.subjectMatch, this.currentPagingOffset, this.currentPagingLimit, EntityItem::new) : this.persistence.getChangedEntities(this.transactionIds, this.subjectMatch, this.currentPagingOffset, this.currentPagingLimit, EntityItem::new);
            this.previousResultsCache.add(this.searchHits);
        }
        this.iterator = this.searchHits.iterator();
    }

    private void loadTransactionRange() {
        if (this.transactionIds != null) {
            return;
        }
        int txLimit = 10;
        if (this.operationNumber != null) {
            try {
                txLimit = Integer.parseInt(this.operationNumber);
            }
            catch (NumberFormatException nfe) {
                this.logger.warn("Could not parse the parameter 'operationNumber' = '{}'  to int. Using default of 1", (Object)this.operationNumber);
            }
        }
        this.transactionIds = this.persistence.getTransactionRange(this.txId, txLimit);
    }

    public long totalSize() {
        if (this.totalSize < 0L) {
            this.totalSize = this.persistence.getExpectedTotalCount(this.transactionIds, this.addOnly);
        }
        return this.totalSize;
    }

    public double getCurrentScore() {
        return 0.0;
    }

    public String getCurrentSubject() {
        return this.currentHit.getId();
    }

    public String getCurrentTransactionId() {
        return this.currentHit.getTransactionId();
    }

    public String getOriginalTransactionId() {
        return this.currentHit.getOriginalTx();
    }

    public String getCurrentTimestamp() {
        return this.currentHit.getTimestamp();
    }

    public String getCurrentOperation() {
        return this.currentHit.getOperation();
    }

    public Collection<SnippetResult> getCurrentSnippets() {
        return Collections.emptyList();
    }

    public boolean next() {
        boolean hasMore;
        if (this.endReachedOnce) {
            this.endReachedOnce = false;
            this.reset();
        }
        if (hasMore = this.iterator.hasNext()) {
            this.currentHit = this.iterator.next();
        } else if (!this.noMoreStoredResults) {
            this.advancePage();
            boolean bl = hasMore = this.iterator.hasNext() && this.next();
        }
        if (!hasMore) {
            this.endReachedOnce = true;
            this.noMoreStoredResults = true;
        }
        return hasMore;
    }

    private void reset() {
        this.iterator = Iterables.concat(this.previousResultsCache).iterator();
    }

    public void close() {
        if (this.previousResultsCache != null) {
            this.previousResultsCache.clear();
        }
        if (this.searchHits != null) {
            this.searchHits.clear();
            this.searchHits = null;
        }
        if (this.transactionIds != null) {
            this.transactionIds.clear();
            this.transactionIds = null;
        }
    }

    private static class EntityItem {
        private final String id;
        private final BindingSet bindings;

        EntityItem(BindingSet bindings) {
            this.id = EntitiesUtil.valueToString((Value)bindings.getValue("entity"));
            this.bindings = bindings;
        }

        String getId() {
            return this.id;
        }

        String getTransactionId() {
            return EntitiesUtil.valueToString((Value)this.bindings.getValue("txId"));
        }

        String getTimestamp() {
            return EntitiesUtil.valueToString((Value)this.bindings.getValue("txAt"));
        }

        String getOperation() {
            return EntitiesUtil.valueToString((Value)this.bindings.getValue("op"));
        }

        String getOriginalTx() {
            return EntitiesUtil.valueToString((Value)this.bindings.getValue("originalTx"));
        }
    }
}

