/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.entitychange;

import com.google.common.collect.ImmutableList;
import com.ontotext.trree.plugin.externalsync.ConnectorPredicate;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangePersistence;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangeSearchOptions;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangeStore;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.iterators.OperationIterator;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.iterators.OriginalTransactionIdIterator;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.iterators.TransactionIdIterator;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.iterators.TransactionTimeStampIterator;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class EntityChangePlugin
extends ExternalSyncPlugin {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("external-sync-entity-change-option-description", Locale.getDefault());
    public static final String BASE_IRI = "http://www.ontotext.com/connectors/entity-change";
    static final IRI TRANSACTION = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change#transaction");
    static final IRI OPERATION_NUMBER = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change#operationNumber");
    static final IRI ADD_ONLY = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change#addOnly");
    private static final String INDEX_PREVIOUS_DATA_NAME = "indexPreviousData";
    static final Option<Boolean> INDEX_PREVIOUS_DATA = Option.flag((String)"indexPreviousData", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)true).build();
    private static final String CREATE_SETTINGS_PARAM_NAME = "indexCreateSettings";
    static final Option<Map<String, Object>> CREATE_SETTINGS = Option.jsonString((String)"indexCreateSettings", (ResourceBundle)RESOURCE_BUNDLE).build();
    private static final ImmutableList<Option<?>> OPTIONS = ImmutableList.builder().add((Object)EntityChangePlugin.createFieldsOptions((String)"fields", (Option[])new Option[]{EntityChangePlugin.createFieldsOptions((String)"objectFields", (Option[])new Option[]{EntityChangePlugin.createFieldsOptions((String)"objectFields", (Option[])new Option[]{EntityChangePlugin.createFieldsOptions((String)"objectFields", (Option[])new Option[0])})})})).addAll((Iterable)DEFAULT_OPTIONS).add(CREATE_SETTINGS).add(INDEX_PREVIOUS_DATA).build();
    private long transactionParam;
    private long operationNumberParam;
    private long addOnlyParam;
    private long transactionId;
    private long originalTx;
    private long transactionTimestamp;
    private long operation;

    public String getName() {
        return "entity-change";
    }

    protected Enum<? extends ConnectorPredicate>[] getCustomPluginPredicates() {
        return CustomControlPredicates.values();
    }

    protected void registerCustomPredicates(Entities entities) {
        this.transactionId = this.registerControlPredicateWithIterator(entities, CustomControlPredicates.TRANSACTION_ID, TransactionIdIterator.class);
        this.originalTx = this.registerControlPredicateWithIterator(entities, CustomControlPredicates.ORIGINAL_TRANSACTION_ID, OriginalTransactionIdIterator.class);
        this.transactionTimestamp = this.registerControlPredicateWithIterator(entities, CustomControlPredicates.TIMESTAMP, TransactionTimeStampIterator.class);
        this.operation = this.registerControlPredicateWithIterator(entities, CustomControlPredicates.OPERATION, OperationIterator.class);
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.transactionId || predicate == this.transactionTimestamp || predicate == this.operation || predicate == this.originalTx) {
            return subject == Long.MAX_VALUE ? 0.3 : 1.3;
        }
        return super.estimate(subject, predicate, object, context, pluginConnection, requestContext);
    }

    protected ExternalStore openExistingStore(String storeName, Options storeOptions, PluginConnection pluginConnection) {
        return EntityChangeStore.open(storeName, storeOptions, this, pluginConnection);
    }

    protected ExternalStore createNewStore(String storeName, Options options, PluginConnection pluginConnection, Entities entitiesForCreation) {
        return EntityChangeStore.create(storeName, options, this, pluginConnection, entitiesForCreation);
    }

    public List<Option<?>> getAllOptions() {
        return OPTIONS;
    }

    protected String getURIComponent() {
        return "entity-change";
    }

    public String getShortName() {
        return "Entity-Change";
    }

    protected SearchOptions createSearchOptions() {
        return new EntityChangeSearchOptions();
    }

    protected long[] getCustomSearchOptions(Entities entities) {
        this.transactionParam = entities.put((Value)TRANSACTION, Entities.Scope.SYSTEM);
        this.operationNumberParam = entities.put((Value)OPERATION_NUMBER, Entities.Scope.SYSTEM);
        this.addOnlyParam = entities.put((Value)ADD_ONLY, Entities.Scope.SYSTEM);
        return new long[]{this.transactionParam, this.operationNumberParam, this.addOnlyParam};
    }

    protected void processCustomSearchOption(long predicate, SearchOptions searchOptions, String optionStr) {
        if (this.transactionParam == predicate) {
            ((EntityChangeSearchOptions)searchOptions).setTransaction(optionStr);
        }
        if (this.operationNumberParam == predicate) {
            ((EntityChangeSearchOptions)searchOptions).setOperationNumber(optionStr);
        }
        if (this.addOnlyParam == predicate) {
            ((EntityChangeSearchOptions)searchOptions).setAddOnly(Boolean.parseBoolean(optionStr));
        }
    }

    public void shutdown(ShutdownReason shutdownReason) {
        super.shutdown(shutdownReason);
        try {
            EntityChangePersistence.shutdown();
        }
        catch (Exception ex) {
            this.getLogger().warn("Could not shutdown persistence due to:", (Throwable)ex);
        }
    }

    public void checkRequiredCapabilities(PluginConnection pluginConnection) {
    }

    static enum CustomControlPredicates implements ConnectorPredicate
    {
        TRANSACTION_ID("transactionId"),
        ORIGINAL_TRANSACTION_ID("originalTx"),
        TIMESTAMP("timestamp"),
        OPERATION("operation");

        private final String uriSuffix;

        private CustomControlPredicates(String uriSuffix) {
            this.uriSuffix = uriSuffix;
        }

        public String getURISuffix() {
            return this.uriSuffix;
        }
    }
}

