/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.builders.Builder;

public abstract class BaseBuilder<T extends OWLObject, B>
implements Builder<T> {
    protected final OWLDataFactory df;
    protected final List<OWLAnnotation> annotations = new ArrayList<OWLAnnotation>();

    @Inject
    protected BaseBuilder(OWLDataFactory df) {
        this.df = OWLAPIPreconditions.checkNotNull(df);
    }

    public B withAnnotation(OWLAnnotation arg) {
        this.annotations.add(arg);
        return (B)this;
    }

    public B withAnnotations(Collection<OWLAnnotation> arg) {
        this.annotations.addAll(arg);
        return (B)this;
    }

    public B withAnnotations(Stream<OWLAnnotation> arg) {
        OWLAPIStreamUtils.add(this.annotations, arg);
        return (B)this;
    }

    public B clearAnnotations() {
        this.annotations.clear();
        return (B)this;
    }

    @Override
    public abstract T buildObject();

    @Override
    public List<OWLOntologyChange> applyChanges(OWLOntology o) {
        Object object = this.buildObject();
        if (!(object instanceof OWLAxiom)) {
            return Collections.emptyList();
        }
        AddAxiom change = new AddAxiom(o, (OWLAxiom)object);
        o.applyChange(change);
        OWLProfileReport report = Profiles.OWL2_DL.checkOntology(o);
        List<OWLOntologyChange> changes = OWLAPIStreamUtils.asList(report.getViolations().stream().flatMap(v -> v.repair().stream()));
        o.getOWLOntologyManager().applyChanges(changes);
        changes.add(change);
        return changes;
    }
}

