/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum TIMEVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    DAY_OF_WEEK_CLASS(Namespaces.TIME, "DayOfWeek", EntityType.CLASS),
    GENERAL_YEAR(Namespaces.TIME, "generalYear", EntityType.CLASS),
    TEMPORAL_DURATION(Namespaces.TIME, "TemporalDuration", EntityType.CLASS),
    GENERAL_DURATION_DESCRIPTION(Namespaces.TIME, "GeneralDurationDescription", EntityType.CLASS),
    DURATION_DESCRIPTION(Namespaces.TIME, "DurationDescription", EntityType.CLASS),
    YEAR_CLASS(Namespaces.TIME, "Year", EntityType.CLASS),
    TEMPORAL_UNIT(Namespaces.TIME, "TemporalUnit", EntityType.CLASS),
    DURATION(Namespaces.TIME, "Duration", EntityType.CLASS),
    TEMPORAL_ENTITY(Namespaces.TIME, "TemporalEntity", EntityType.CLASS),
    INSTANT(Namespaces.TIME, "Instant", EntityType.CLASS),
    INTERVAL(Namespaces.TIME, "Interval", EntityType.CLASS),
    PROPER_INTERVAL(Namespaces.TIME, "ProperInterval", EntityType.CLASS),
    DATE_TIME_INTERVAL(Namespaces.TIME, "DateTimeInterval", EntityType.CLASS),
    TEMPORAL_POSITION(Namespaces.TIME, "TemporalPosition", EntityType.CLASS),
    GENERAL_DATE_TIME_DESCRIPTION(Namespaces.TIME, "GeneralDateTimeDescription", EntityType.CLASS),
    DATE_TIME_DESCRIPTION(Namespaces.TIME, "DateTimeDescription", EntityType.CLASS),
    MONTH_OF_YEAR_CLASS(Namespaces.TIME, "MonthOfYear", EntityType.CLASS),
    JANUARY(Namespaces.TIME, "January", EntityType.CLASS),
    TIME_POSITION(Namespaces.TIME, "TimePosition", EntityType.CLASS),
    TEMPORAL_REFERENCE_SYSTEM(Namespaces.TIME, "TRS", EntityType.CLASS),
    TIME_ZONE_CLASS(Namespaces.TIME, "TimeZone", EntityType.CLASS),
    AFTER(Namespaces.TIME, "after", EntityType.OBJECT_PROPERTY),
    INTERVAL_AFTER(Namespaces.TIME, "intervalAfter", EntityType.OBJECT_PROPERTY),
    BEFORE(Namespaces.TIME, "intervalBefore", EntityType.OBJECT_PROPERTY),
    DAY_OF_WEEK_PROPERTY(Namespaces.TIME, "dayOfWeek", EntityType.OBJECT_PROPERTY),
    HAS_DATE_TIME_DESCRIPTION(Namespaces.TIME, "hasDateTimeDescription", EntityType.OBJECT_PROPERTY),
    HAS_TEMPORAL_DURATION(Namespaces.TIME, "hasTemporalDuration", EntityType.OBJECT_PROPERTY),
    HAS_DURATION(Namespaces.TIME, "hasDuration", EntityType.OBJECT_PROPERTY),
    HAS_DURATION_DESCRIPTION(Namespaces.TIME, "hasDurationDescription", EntityType.OBJECT_PROPERTY),
    HAS_TIME(Namespaces.TIME, "hasTime", EntityType.OBJECT_PROPERTY),
    HAS_BEGINNING(Namespaces.TIME, "hasBeginning", EntityType.OBJECT_PROPERTY),
    HAS_END(Namespaces.TIME, "hasEnd", EntityType.OBJECT_PROPERTY),
    INSIDE(Namespaces.TIME, "inside", EntityType.OBJECT_PROPERTY),
    TIME_ZONE_PROPERTY(Namespaces.TIME, "timeZone", EntityType.OBJECT_PROPERTY),
    INTERVAL_CONTAINS(Namespaces.TIME, "intervalContains", EntityType.OBJECT_PROPERTY),
    INTERVAL_DISJOINT(Namespaces.TIME, "intervalDisjoint", EntityType.OBJECT_PROPERTY),
    INTERVAL_EQUALS(Namespaces.TIME, "intervalEquals", EntityType.OBJECT_PROPERTY),
    INTERVAL_FINISHED_BY(Namespaces.TIME, "intervalFinishedBy", EntityType.OBJECT_PROPERTY),
    INTERVAL_IN(Namespaces.TIME, "intervalIn", EntityType.OBJECT_PROPERTY),
    INTERVAL_DURING(Namespaces.TIME, "intervalDuring", EntityType.OBJECT_PROPERTY),
    INTERVAL_FINISHES(Namespaces.TIME, "intervalFinishes", EntityType.OBJECT_PROPERTY),
    INTERVAL_STARTS(Namespaces.TIME, "intervalStarts", EntityType.OBJECT_PROPERTY),
    INTERVAL_MEETS(Namespaces.TIME, "intervalMeets", EntityType.OBJECT_PROPERTY),
    INTERVAL_MET_BY(Namespaces.TIME, "intervalMetBy", EntityType.OBJECT_PROPERTY),
    INTERVAL_OVERLAPPED_BY(Namespaces.TIME, "intervalOverlappedBy", EntityType.OBJECT_PROPERTY),
    INTERVAL_OVERLAP(Namespaces.TIME, "intervalOverlaps", EntityType.OBJECT_PROPERTY),
    INTERVAL_STARTED_BY(Namespaces.TIME, "intervalStartedBy", EntityType.OBJECT_PROPERTY),
    MONTH_OF_YEAR_PROPERTY(Namespaces.TIME, "monthOfYear", EntityType.OBJECT_PROPERTY),
    IN_TEMPORAL_POSITION(Namespaces.TIME, "inTemporalPosition", EntityType.OBJECT_PROPERTY),
    IN_DATE_TIME(Namespaces.TIME, "inDateTime", EntityType.OBJECT_PROPERTY),
    IN_TIME_POSITION(Namespaces.TIME, "inTimePosition", EntityType.OBJECT_PROPERTY),
    HAS_TRS(Namespaces.TIME, "hasTRS", EntityType.OBJECT_PROPERTY),
    UNIT_TYPE(Namespaces.TIME, "unitType", EntityType.OBJECT_PROPERTY),
    DAY(Namespaces.TIME, "day", EntityType.DATA_PROPERTY),
    DAY_OF_YEAR(Namespaces.TIME, "dayOfYear", EntityType.DATA_PROPERTY),
    DAYS(Namespaces.TIME, "days", EntityType.DATA_PROPERTY),
    HAS_XSD_DURATION(Namespaces.TIME, "hasXSDDuration", EntityType.DATA_PROPERTY),
    HOUR(Namespaces.TIME, "hour", EntityType.DATA_PROPERTY),
    HOURS(Namespaces.TIME, "hours", EntityType.DATA_PROPERTY),
    IN_XSD_DATE_TIME_STAMP(Namespaces.TIME, "inXSDDateTimeStamp", EntityType.DATA_PROPERTY),
    IN_XSD_G_YEAR(Namespaces.TIME, "inXSDgYear", EntityType.DATA_PROPERTY),
    IN_XSD_G_YEAR_MONTH(Namespaces.TIME, "inXSDgYearMonth", EntityType.DATA_PROPERTY),
    MINUTE(Namespaces.TIME, "minute", EntityType.DATA_PROPERTY),
    MINUTES(Namespaces.TIME, "minutes", EntityType.DATA_PROPERTY),
    MONTH(Namespaces.TIME, "month", EntityType.DATA_PROPERTY),
    MONTHS(Namespaces.TIME, "months", EntityType.DATA_PROPERTY),
    NOMINAL_POSITION(Namespaces.TIME, "nominalPosition", EntityType.DATA_PROPERTY),
    NUMERIC_DURATION(Namespaces.TIME, "numericDuration", EntityType.DATA_PROPERTY),
    NUMERIC_POSITION(Namespaces.TIME, "numericPosition", EntityType.DATA_PROPERTY),
    SECOND(Namespaces.TIME, "second", EntityType.DATA_PROPERTY),
    SECONDS(Namespaces.TIME, "seconds", EntityType.DATA_PROPERTY),
    WEEK(Namespaces.TIME, "week", EntityType.DATA_PROPERTY),
    WEEKS(Namespaces.TIME, "weeks", EntityType.DATA_PROPERTY),
    YEAR_PROPERTY(Namespaces.TIME, "year", EntityType.DATA_PROPERTY),
    YEARS(Namespaces.TIME, "years", EntityType.DATA_PROPERTY),
    XSD_DATE_TIME(Namespaces.TIME, "xsdDateTime", EntityType.DATA_PROPERTY),
    IN_XSD_DATE_TIME(Namespaces.TIME, "inXSDDateTime", EntityType.DATA_PROPERTY),
    UNIT_DAY(Namespaces.TIME, "unitDay", EntityType.NAMED_INDIVIDUAL),
    FRIDAY(Namespaces.TIME, "Friday", EntityType.NAMED_INDIVIDUAL),
    UNIT_HOUR(Namespaces.TIME, "unitHour", EntityType.NAMED_INDIVIDUAL),
    UNIT_MINUTE(Namespaces.TIME, "unitMinute", EntityType.NAMED_INDIVIDUAL),
    MONDAY(Namespaces.TIME, "Monday", EntityType.NAMED_INDIVIDUAL),
    UNIT_MONTH(Namespaces.TIME, "unitMonth", EntityType.NAMED_INDIVIDUAL),
    SATURDAY(Namespaces.TIME, "Saturday", EntityType.NAMED_INDIVIDUAL),
    UNIT_SECOND(Namespaces.TIME, "unitSecond", EntityType.NAMED_INDIVIDUAL),
    SUNDAY(Namespaces.TIME, "Sunday", EntityType.NAMED_INDIVIDUAL),
    THURSDAY(Namespaces.TIME, "Thursday", EntityType.NAMED_INDIVIDUAL),
    TUESDAY(Namespaces.TIME, "Tuesday", EntityType.NAMED_INDIVIDUAL),
    WEDNESDAY(Namespaces.TIME, "Wednesday", EntityType.NAMED_INDIVIDUAL),
    UNIT_WEEK(Namespaces.TIME, "unitWeek", EntityType.NAMED_INDIVIDUAL),
    UNIT_YEAR(Namespaces.TIME, "unitYear", EntityType.NAMED_INDIVIDUAL);

    private final IRI iri;
    private final Namespaces namespace;
    private final String shortName;
    private final String prefixedName;
    private final EntityType<?> entityType;

    private TIMEVocabulary(Namespaces namespace, String shortName, EntityType<?> entityType) {
        this.namespace = namespace;
        this.shortName = shortName;
        this.prefixedName = namespace.getPrefixName() + ":" + shortName;
        this.iri = IRI.create(namespace.toString(), shortName);
        this.entityType = entityType;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    public Namespaces getNamespace() {
        return this.namespace;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }
}

