/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.providers.AnnotationPropertyProvider;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum SKOSVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    BROADMATCH("broadMatch", EntityType.OBJECT_PROPERTY),
    BROADER("broader", EntityType.OBJECT_PROPERTY),
    BROADERTRANSITIVE("broaderTransitive", EntityType.OBJECT_PROPERTY),
    CLOSEMATCH("closeMatch", EntityType.OBJECT_PROPERTY),
    EXACTMATCH("exactMatch", EntityType.OBJECT_PROPERTY),
    HASTOPCONCEPT("hasTopConcept", EntityType.OBJECT_PROPERTY),
    INSCHEME("inScheme", EntityType.OBJECT_PROPERTY),
    MAPPINGRELATION("mappingRelation", EntityType.OBJECT_PROPERTY),
    MEMBER("member", EntityType.OBJECT_PROPERTY),
    MEMBERLIST("memberList", EntityType.OBJECT_PROPERTY),
    NARROWMATCH("narrowMatch", EntityType.OBJECT_PROPERTY),
    NARROWER("narrower", EntityType.OBJECT_PROPERTY),
    NARROWTRANSITIVE("narrowTransitive", EntityType.OBJECT_PROPERTY),
    RELATED("related", EntityType.OBJECT_PROPERTY),
    RELATEDMATCH("relatedMatch", EntityType.OBJECT_PROPERTY),
    SEMANTICRELATION("semanticRelation", EntityType.OBJECT_PROPERTY),
    TOPCONCEPTOF("topConceptOf", EntityType.OBJECT_PROPERTY),
    COLLECTION("Collection", EntityType.CLASS),
    CONCEPT("Concept", EntityType.CLASS),
    CONCEPTSCHEME("ConceptScheme", EntityType.CLASS),
    ORDEREDCOLLECTION("OrderedCollection", EntityType.CLASS),
    TOPCONCEPT("TopConcept", EntityType.CLASS),
    ALTLABEL("altLabel", EntityType.ANNOTATION_PROPERTY),
    CHANGENOTE("changeNote", EntityType.ANNOTATION_PROPERTY),
    DEFINITION("definition", EntityType.ANNOTATION_PROPERTY),
    EDITORIALNOTE("editorialNote", EntityType.ANNOTATION_PROPERTY),
    EXAMPLE("example", EntityType.ANNOTATION_PROPERTY),
    HIDDENLABEL("hiddenLabel", EntityType.ANNOTATION_PROPERTY),
    HISTORYNOTE("historyNote", EntityType.ANNOTATION_PROPERTY),
    NOTE("note", EntityType.ANNOTATION_PROPERTY),
    PREFLABEL("prefLabel", EntityType.ANNOTATION_PROPERTY),
    SCOPENOTE("scopeNote", EntityType.ANNOTATION_PROPERTY),
    DOCUMENT("Document", EntityType.CLASS),
    IMAGE("Image", EntityType.CLASS),
    COLLECTABLEPROPERTY("CollectableProperty", EntityType.ANNOTATION_PROPERTY),
    RESOURCE("Resource", EntityType.CLASS),
    COMMENT("comment", EntityType.ANNOTATION_PROPERTY);

    public static final Set<IRI> ALL_IRIS;
    private final String localName;
    private final IRI iri;
    private final EntityType<?> entityType;
    private final String prefixedName;

    static {
        ALL_IRIS = OWLAPIStreamUtils.asSet(SKOSVocabulary.stream().map(v -> v.getIRI()));
    }

    private SKOSVocabulary(String localname, EntityType<?> entityType) {
        this.localName = localname;
        this.prefixedName = Namespaces.SKOS.getPrefixName() + ":" + localname;
        this.entityType = entityType;
        this.iri = IRI.create(Namespaces.SKOS.toString(), localname);
    }

    private static Stream<SKOSVocabulary> stream() {
        return Stream.of(SKOSVocabulary.values());
    }

    public static Set<OWLAnnotationProperty> getAnnotationProperties(AnnotationPropertyProvider dataFactory) {
        return OWLAPIStreamUtils.asSet(SKOSVocabulary.stream().filter(v -> v.entityType.equals(EntityType.ANNOTATION_PROPERTY)).map(v -> dataFactory.getOWLAnnotationProperty(v.iri)));
    }

    public static Set<OWLObjectProperty> getObjectProperties(OWLDataFactory dataFactory) {
        return OWLAPIStreamUtils.asSet(SKOSVocabulary.stream().filter(v -> v.entityType.equals(EntityType.OBJECT_PROPERTY)).map(v -> dataFactory.getOWLObjectProperty(v.iri)));
    }

    public static Set<OWLDataProperty> getDataProperties(OWLDataFactory dataFactory) {
        return OWLAPIStreamUtils.asSet(SKOSVocabulary.stream().filter(v -> v.entityType.equals(EntityType.DATA_PROPERTY)).map(v -> dataFactory.getOWLDataProperty(v.iri)));
    }

    public static Set<OWLClass> getClasses(OWLDataFactory dataFactory) {
        return OWLAPIStreamUtils.asSet(SKOSVocabulary.stream().filter(v -> v.entityType.equals(EntityType.CLASS)).map(v -> dataFactory.getOWLClass(v.iri)));
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public String getLocalName() {
        return this.localName;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public String getShortForm() {
        return this.localName;
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }
}

