/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public enum Construct {
    ROLE_DOMAIN_RANGE("RRESTR", new Construct[0]),
    ATOMIC_NEGATION("NEG", new Construct[0]),
    CONCEPT_COMPLEX_NEGATION("C", new Construct[0]),
    CONCEPT_UNION("U", new Construct[0]),
    CONCEPT_INTERSECTION("CINT", new Construct[0]),
    UNIVERSAL_RESTRICTION("UNIVRESTR", new Construct[0]),
    LIMITED_EXISTENTIAL("LIMEXIST", new Construct[0]),
    FULL_EXISTENTIAL("E", LIMITED_EXISTENTIAL),
    ROLE_HIERARCHY("H", new Construct[0]),
    ROLE_TRANSITIVE("+", new Construct[0]),
    ROLE_REFLEXIVITY_CHAINS("Rr", ROLE_HIERARCHY, ROLE_TRANSITIVE),
    ROLE_COMPLEX("R", ROLE_REFLEXIVITY_CHAINS, ROLE_HIERARCHY, ROLE_TRANSITIVE),
    NOMINALS("O", new Construct[0]),
    ROLE_INVERSE("I", new Construct[0]),
    F("F", new Construct[0]),
    N("N", F),
    Q("Q", N, F),
    D("(D)", new Construct[0]);

    public static EnumSet<Construct> incompatibleRoleFetures;
    private final String s;
    Set<Construct> includedConstructs = Collections.emptySet();

    static {
        incompatibleRoleFetures = EnumSet.of(ROLE_REFLEXIVITY_CHAINS, ROLE_INVERSE);
    }

    private Construct(String s, Construct ... components) {
        this.s = s;
        if (components.length > 0) {
            this.includedConstructs = new HashSet<Construct>(Arrays.asList(components));
        }
    }

    public Set<Construct> includedConstructs() {
        return this.includedConstructs;
    }

    public void removeSubsumedConstructs(Set<Construct> constructs) {
        if (this.includedConstructs.isEmpty()) {
            return;
        }
        if (constructs.contains((Object)this)) {
            constructs.removeAll(this.includedConstructs);
        }
    }

    public static void trim(Set<Construct> constructs) {
        Construct[] constructArray = Construct.values();
        int n = constructArray.length;
        int n2 = 0;
        while (n2 < n) {
            Construct c = constructArray[n2];
            c.removeSubsumedConstructs(constructs);
            ++n2;
        }
    }

    public String toString() {
        return this.s;
    }
}

