/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles.violations;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.OWLProfileViolationVisitor;
import org.semanticweb.owlapi.profiles.OWLProfileViolationVisitorEx;
import org.semanticweb.owlapi.profiles.violations.UndeclaredEntityViolation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class UseOfUndeclaredAnnotationProperty
extends OWLProfileViolation
implements UndeclaredEntityViolation {
    @Nullable
    private final OWLAnnotation annotation;

    public UseOfUndeclaredAnnotationProperty(OWLOntology ontology, @Nullable OWLAxiom axiom, @Nullable OWLAnnotation annotation, OWLAnnotationProperty prop) {
        super(ontology, axiom, OWLAPIPreconditions.checkNotNull(prop));
        this.annotation = annotation;
    }

    @Override
    public OWLAnnotationProperty getExpression() {
        return (OWLAnnotationProperty)super.getExpression();
    }

    @Override
    public OWLEntity getEntity() {
        return this.getExpression();
    }

    @Override
    public void accept(OWLProfileViolationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> Optional<O> accept(OWLProfileViolationVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.toString("Use of undeclared annotation property: %s in annotation", this.getExpression(), this.nullSafeAnnotation());
    }

    protected String nullSafeAnnotation() {
        return this.annotation == null ? "" : this.annotation.toString();
    }

    @Override
    public List<OWLOntologyChange> repair() {
        return this.list(new AddAxiom(this.ontology, this.df.getOWLDeclarationAxiom(this.getExpression())));
    }
}

