/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.change.SetOntologyIDData;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class SetOntologyID
extends OWLOntologyChange {
    private static final String ONTOLOGY_ID_CANNOT_BE_NULL = "ontology id cannot be null";
    private final OWLOntologyID ontologyID;
    private final OWLOntologyID newOntologyID;

    public SetOntologyID(OWLOntology ont, OWLOntologyID ontologyID) {
        super(ont);
        this.ontologyID = OWLAPIPreconditions.checkNotNull(ont.getOntologyID(), ONTOLOGY_ID_CANNOT_BE_NULL);
        this.newOntologyID = OWLAPIPreconditions.checkNotNull(ontologyID, ONTOLOGY_ID_CANNOT_BE_NULL);
    }

    SetOntologyID(OWLOntology ont, OWLOntologyID ontologyID, OWLOntologyID newOntologyID) {
        super(ont);
        this.ontologyID = OWLAPIPreconditions.checkNotNull(ontologyID, ONTOLOGY_ID_CANNOT_BE_NULL);
        this.newOntologyID = OWLAPIPreconditions.checkNotNull(newOntologyID, ONTOLOGY_ID_CANNOT_BE_NULL);
    }

    public SetOntologyID(OWLOntology ont, IRI ontologyIRI) {
        this(ont, new OWLOntologyID(OWLAPIPreconditions.optional(ontologyIRI), OWLAPIPreconditions.emptyOptional(IRI.class)));
    }

    @Override
    public SetOntologyIDData getChangeData() {
        return new SetOntologyIDData(this.newOntologyID);
    }

    public OWLOntologyID getOriginalOntologyID() {
        return this.ontologyID;
    }

    public OWLOntologyID getNewOntologyID() {
        return this.newOntologyID;
    }

    @Override
    public void accept(OWLOntologyChangeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLOntologyChangeVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return String.format("SetOntologyID(%s OntologyID(%s))", this.newOntologyID, this.ontologyID);
    }

    public int hashCode() {
        return 57 + this.ontologyID.hashCode() + this.newOntologyID.hashCode() * 3;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SetOntologyID)) {
            return false;
        }
        SetOntologyID change = (SetOntologyID)obj;
        return change.ontologyID.equals(this.ontologyID) && change.newOntologyID.equals(this.newOntologyID);
    }

    @Override
    public OWLOntologyChange reverseChange() {
        return new SetOntologyID(this.getOntology(), this.newOntologyID, this.getOntology().getOntologyID());
    }
}

