/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasAnnotationPropertiesInSignature;
import org.semanticweb.owlapi.model.HasClassesInSignature;
import org.semanticweb.owlapi.model.HasContainsEntityInSignature;
import org.semanticweb.owlapi.model.HasDataPropertiesInSignature;
import org.semanticweb.owlapi.model.HasDatatypesInSignature;
import org.semanticweb.owlapi.model.HasGetEntitiesInSignature;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.HasIndividualsInSignature;
import org.semanticweb.owlapi.model.HasObjectPropertiesInSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLSignature
extends HasGetEntitiesInSignature,
HasClassesInSignature,
HasAnnotationPropertiesInSignature,
HasObjectPropertiesInSignature,
HasDataPropertiesInSignature,
HasDatatypesInSignature,
HasIndividualsInSignature,
HasContainsEntityInSignature,
HasImportsClosure {
    default public Set<OWLClass> getClassesInSignature(Imports imports) {
        return OWLAPIStreamUtils.asSet(this.classesInSignature(imports));
    }

    default public Stream<OWLClass> classesInSignature(Imports imports) {
        return imports.stream(this).flatMap(HasClassesInSignature::classesInSignature).distinct().sorted();
    }

    default public Set<OWLObjectProperty> getObjectPropertiesInSignature(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.objectPropertiesInSignature(includeImportsClosure));
    }

    default public Stream<OWLObjectProperty> objectPropertiesInSignature(Imports imports) {
        return imports.stream(this).flatMap(HasObjectPropertiesInSignature::objectPropertiesInSignature).distinct().sorted();
    }

    default public Set<OWLDataProperty> getDataPropertiesInSignature(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.dataPropertiesInSignature(includeImportsClosure));
    }

    default public Stream<OWLDataProperty> dataPropertiesInSignature(Imports imports) {
        return imports.stream(this).flatMap(HasDataPropertiesInSignature::dataPropertiesInSignature).distinct().sorted();
    }

    default public Set<OWLNamedIndividual> getIndividualsInSignature(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.individualsInSignature(includeImportsClosure));
    }

    default public Stream<OWLNamedIndividual> individualsInSignature(Imports imports) {
        return imports.stream(this).flatMap(HasIndividualsInSignature::individualsInSignature).distinct().sorted();
    }

    default public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.referencedAnonymousIndividuals(includeImportsClosure));
    }

    default public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals(Imports imports) {
        return imports.stream(this).flatMap(OWLSignature::referencedAnonymousIndividuals).distinct().sorted();
    }

    default public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        return OWLAPIStreamUtils.asSet(this.referencedAnonymousIndividuals());
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals();

    default public Set<OWLDatatype> getDatatypesInSignature(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.datatypesInSignature(includeImportsClosure));
    }

    default public Stream<OWLDatatype> datatypesInSignature(Imports imports) {
        return imports.stream(this).flatMap(HasDatatypesInSignature::datatypesInSignature).distinct().sorted();
    }

    default public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.annotationPropertiesInSignature(includeImportsClosure));
    }

    default public Stream<OWLAnnotationProperty> annotationPropertiesInSignature(Imports imports) {
        return imports.stream(this).flatMap(HasAnnotationPropertiesInSignature::annotationPropertiesInSignature).distinct().sorted();
    }

    default public boolean containsEntityInSignature(OWLEntity owlEntity, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.containsEntityInSignature(owlEntity));
    }

    default public boolean containsEntityInSignature(IRI entityIRI, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.containsEntityInSignature(entityIRI));
    }

    public boolean containsClassInSignature(IRI var1, Imports var2);

    public boolean containsObjectPropertyInSignature(IRI var1, Imports var2);

    public boolean containsDataPropertyInSignature(IRI var1, Imports var2);

    public boolean containsAnnotationPropertyInSignature(IRI var1, Imports var2);

    public boolean containsDatatypeInSignature(IRI var1, Imports var2);

    public boolean containsIndividualInSignature(IRI var1, Imports var2);

    public boolean containsDatatypeInSignature(IRI var1);

    default public boolean containsEntityInSignature(IRI entityIRI) {
        return this.containsClassInSignature(entityIRI) || this.containsObjectPropertyInSignature(entityIRI) || this.containsDataPropertyInSignature(entityIRI) || this.containsIndividualInSignature(entityIRI) || this.containsDatatypeInSignature(entityIRI) || this.containsAnnotationPropertyInSignature(entityIRI);
    }

    public boolean containsClassInSignature(IRI var1);

    public boolean containsObjectPropertyInSignature(IRI var1);

    public boolean containsDataPropertyInSignature(IRI var1);

    public boolean containsAnnotationPropertyInSignature(IRI var1);

    public boolean containsIndividualInSignature(IRI var1);

    default public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        if (EntityType.CLASS.equals(type)) {
            return this.classesInSignature().count() > 0L;
        }
        if (EntityType.DATA_PROPERTY.equals(type)) {
            return this.dataPropertiesInSignature().count() > 0L;
        }
        if (EntityType.OBJECT_PROPERTY.equals(type)) {
            return this.objectPropertiesInSignature().count() > 0L;
        }
        if (EntityType.ANNOTATION_PROPERTY.equals(type)) {
            return this.annotationPropertiesInSignature().count() > 0L;
        }
        if (EntityType.DATATYPE.equals(type)) {
            return this.datatypesInSignature().count() > 0L;
        }
        if (EntityType.NAMED_INDIVIDUAL.equals(type)) {
            return this.individualsInSignature().count() > 0L;
        }
        throw new IllegalArgumentException("Entity type " + String.valueOf(type) + " is not valid for entity presence check");
    }

    default public boolean containsEntitiesOfTypeInSignature(EntityType<?> type, Imports includeImportsClosure) {
        return includeImportsClosure.stream(this).anyMatch(o -> o.containsEntitiesOfTypeInSignature(type));
    }

    default public Set<OWLEntity> getEntitiesInSignature(IRI iri, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.entitiesInSignature(iri, includeImportsClosure));
    }

    default public Stream<OWLEntity> entitiesInSignature(IRI iri, Imports imports) {
        return imports.stream(this).flatMap(o -> o.entitiesInSignature(iri)).distinct().sorted();
    }

    public Set<IRI> getPunnedIRIs(Imports var1);

    @Deprecated
    default public boolean containsReference(OWLEntity entity, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.containsReference(entity));
    }

    @Deprecated
    public boolean containsReference(OWLEntity var1);
}

