/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasAnnotationPropertiesInSignature;
import org.semanticweb.owlapi.model.HasAnonymousIndividuals;
import org.semanticweb.owlapi.model.HasClassesInSignature;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.HasContainsEntityInSignature;
import org.semanticweb.owlapi.model.HasDataPropertiesInSignature;
import org.semanticweb.owlapi.model.HasDatatypesInSignature;
import org.semanticweb.owlapi.model.HasHashIndex;
import org.semanticweb.owlapi.model.HasIndex;
import org.semanticweb.owlapi.model.HasIndividualsInSignature;
import org.semanticweb.owlapi.model.HasObjectPropertiesInSignature;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLObject
extends Comparable<OWLObject>,
Serializable,
HasSignature,
HasContainsEntityInSignature,
HasAnonymousIndividuals,
HasClassesInSignature,
HasObjectPropertiesInSignature,
HasDataPropertiesInSignature,
HasIndividualsInSignature,
HasDatatypesInSignature,
HasAnnotationPropertiesInSignature,
HasIndex,
HasHashIndex,
HasComponents,
IsAnonymous {
    default public Set<OWLClassExpression> getNestedClassExpressions() {
        return OWLAPIStreamUtils.asSet(this.nestedClassExpressions());
    }

    default public Stream<OWLClassExpression> nestedClassExpressions() {
        return OWLAPIStreamUtils.empty();
    }

    public void accept(OWLObjectVisitor var1);

    public <O> O accept(OWLObjectVisitorEx<O> var1);

    default public boolean isTopEntity() {
        return false;
    }

    default public boolean isBottomEntity() {
        return false;
    }

    default public boolean isIRI() {
        return false;
    }

    default public boolean isIndividual() {
        return false;
    }

    default public boolean isAxiom() {
        return false;
    }

    default public boolean isOntology() {
        return false;
    }

    default public boolean isAnonymousExpression() {
        return !this.isAxiom() && !this.isIndividual() && !this.isOntology() && !this.isIRI() && !(this instanceof OWLLiteral) && this.isAnonymous();
    }

    default public boolean hasSharedStructure() {
        HashMap counters = new HashMap();
        Stream<OWLObject> filter = OWLAPIStreamUtils.flatComponents(this).filter(x -> x instanceof OWLObject).map(x -> (OWLObject)x).filter(OWLObject::isAnonymousExpression);
        filter.forEach(x -> {
            int n = counters.computeIfAbsent(x, q -> new AtomicInteger(0)).incrementAndGet();
        });
        return counters.values().stream().anyMatch(x -> x.get() > 1);
    }

    public int initHashCode();

    public static int hashIteration(int a, int b) {
        return a * 37 + b;
    }
}

