/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public interface MIMETypeAware {
    @Nullable
    public String getDefaultMIMEType();

    default public List<String> getMIMETypes() {
        String defaultMIMEType = this.getDefaultMIMEType();
        if (defaultMIMEType == null || defaultMIMEType.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.getDefaultMIMEType());
    }

    default public boolean handlesMimeType(String mimeType) {
        String type = MIMETypeAware.stripWeight(mimeType);
        return this.getMIMETypes().stream().map(MIMETypeAware::stripWeight).anyMatch(m -> m.equals(type));
    }

    public static String stripWeight(String mime) {
        int semiColon = mime.indexOf(59);
        if (semiColon > -1) {
            return mime.substring(0, semiColon).trim();
        }
        return mime.trim();
    }
}

