/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class ConvertSuperClassesToEquivalentClass
extends AbstractCompositeOntologyChange {
    public ConvertSuperClassesToEquivalentClass(OWLDataFactory dataFactory, OWLClass cls, Collection<OWLOntology> ontologies, OWLOntology targetOntology) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null"), OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null"), OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
    }

    private void generateChanges(OWLOntology targetOntology, OWLClass cls, Collection<OWLOntology> ontologies) {
        ArrayList descs = new ArrayList();
        for (OWLOntology ont : ontologies) {
            ont.subClassAxiomsForSubClass(cls).forEach(ax -> {
                this.addChange(new RemoveAxiom(ont, (OWLAxiom)ax));
                descs.add(ax.getSuperClass());
            });
        }
        OWLObjectIntersectionOf equivalentClass = this.df.getOWLObjectIntersectionOf(descs);
        this.addChange(new AddAxiom(targetOntology, this.df.getOWLEquivalentClassesAxiom(Arrays.asList(cls, equivalentClass))));
    }
}

