/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.kafka;

import com.google.common.collect.ImmutableList;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.ClassNameValidator;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaProducerRegistry;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaStore;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaTopicExistValidator;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaUrlValidation;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.ShutdownReason;
import java.io.File;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;

public class KafkaPlugin
extends ExternalSyncPlugin {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("external-sync-kafka-option-description", Locale.getDefault());
    static final String KAFKA_NODE_PARAM_NAME = "kafkaNode";
    static final String KAFKA_SSL_PARAM_NAME = "kafkaSSL";
    static final String KAFKA_TOPIC_PARAM_NAME = "kafkaTopic";
    static final String KAFKA_PRODUCER_CONFIG_PARAM_NAME = "kafkaProducerConfig";
    static final String KAFKA_PLAIN_AUTH_USERNAME_PARAM_NAME = "kafkaPlainAuthUsername";
    static final String KAFKA_PLAIN_AUTH_PASSWORD_PARAM_NAME = "kafkaPlainAuthPassword";
    static final String KAFKA_COMPRESSION_TYPE_PARAM_NAME = "kafkaCompressionType";
    static final String KAFKA_PRODUCER_ID_PARAM_NAME = "kafkaProducerId";
    static final String KAFKA_PROPAGATE_CONFIG_PARAM_NAME = "kafkaPropagateConfig";
    static final String KAFKA_IGNORE_DELETE_ALL_PARAM_NAME = "kafkaIgnoreDeleteAll";
    static final String KAFKA_USE_TRANSACTION_PARAM_NAME = "kafkaUseTransaction";
    static final Option<String> KAFKA_NODE = Option.string((String)"kafkaNode", (ResourceBundle)RESOURCE_BUNDLE).withValidator((Validator)new KafkaUrlValidation()).withValidator((Validator)new KafkaTopicExistValidator()).required().updatable().build();
    static final Option<Boolean> KAFKA_SSL = Option.flag((String)"kafkaSSL", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)false).updatable().build();
    static final Option<String> KAFKA_TOPIC = Option.string((String)"kafkaTopic", (ResourceBundle)RESOURCE_BUNDLE).required().build();
    static final Option<Map<String, Object>> KAFKA_PRODUCER_CONFIG = Option.jsonString((String)"kafkaProducerConfig", (ResourceBundle)RESOURCE_BUNDLE).withValidator((Validator)KafkaProducerRegistry.ProducerConfigValidator.INSTANCE).updatable().build();
    static final Option<String> KAFKA_PLAIN_AUTH_USERNAME = Option.string((String)"kafkaPlainAuthUsername", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    static final Option<String> KAFKA_PLAIN_AUTH_PASSWORD = Option.string((String)"kafkaPlainAuthPassword", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    static final Option<String> AUTHENTICATION_CONFIGURATOR_CLASS = Option.string((String)"authenticationConfiguratorClass", (ResourceBundle)RESOURCE_BUNDLE).withValidator((Validator)new ClassNameValidator()).updatable().build();
    static final Option<String> KAFKA_COMPRESSION_TYPE = Option.string((String)"kafkaCompressionType", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)"snappy").updatable().build();
    static final Option<Long> BULK_UPDATE_BATCH_SIZE = Option.longNumber((String)"bulkUpdateBatchSize", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    static final Option<Long> BULK_UPDATE_REQUEST_SIZE = Option.longNumber((String)"bulkUpdateRequestSize", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    static final Option<Boolean> KAFKA_USE_TRANSACTION = Option.flag((String)"kafkaUseTransaction", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)true).updatable().build();
    static final Option<String> KAFKA_PRODUCER_ID = Option.string((String)"kafkaProducerId", (ResourceBundle)RESOURCE_BUNDLE).build();
    static final Option<Boolean> KAFKA_PROPAGATE_CONFIG = Option.flag((String)"kafkaPropagateConfig", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)false).updatable().unsaved().build();
    static final Option<Boolean> KAFKA_IGNORE_DELETE_ALL = Option.flag((String)"kafkaIgnoreDeleteAll", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)false).build();
    private static final ImmutableList<Option<?>> OPTIONS = ImmutableList.builder().add(KafkaPlugin.createFieldsOptionsKafka("fields", KafkaPlugin.createFieldsOptionsKafka("objectFields", KafkaPlugin.createFieldsOptionsKafka("objectFields", KafkaPlugin.createFieldsOptionsKafka("objectFields", KafkaPlugin.createFieldsOptionsKafka("objectFields", KafkaPlugin.createFieldsOptionsKafka("objectFields", new Option[0]))))))).addAll((Iterable)DEFAULT_OPTIONS).add(KAFKA_NODE).add(KAFKA_TOPIC).add(KAFKA_SSL).add(KAFKA_PLAIN_AUTH_USERNAME).add(KAFKA_PLAIN_AUTH_PASSWORD).add(AUTHENTICATION_CONFIGURATOR_CLASS).add(BULK_UPDATE_BATCH_SIZE).add(BULK_UPDATE_REQUEST_SIZE).add(KAFKA_COMPRESSION_TYPE).add(KAFKA_PRODUCER_ID).add(KAFKA_PRODUCER_CONFIG).add(KAFKA_IGNORE_DELETE_ALL).add(KAFKA_PROPAGATE_CONFIG).add(KAFKA_USE_TRANSACTION).build();
    KafkaProducerRegistry kafkaProducerRegistry;
    private Set<KafkaProducerRegistry.ReferencedProducer> activeKafkaTransactions;

    private static Option<List<Option<?>>> createFieldsOptionsKafka(String optionName, Option<?> ... options) {
        Option[] moreOptions = new Option[options.length + 1];
        moreOptions[0] = Option.flag((String)"array", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)false).build();
        System.arraycopy(options, 0, moreOptions, moreOptions.length - options.length, options.length);
        return KafkaPlugin.createFieldsOptions((String)optionName, (boolean)true, (boolean)false, (boolean)false, (Option[])moreOptions);
    }

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        String repositoryId = null;
        File dataDir = this.getDataDir();
        if (dataDir.getParent() != null && (dataDir = dataDir.getParentFile()).getParent() != null) {
            repositoryId = dataDir.getParentFile().getName();
        }
        if (repositoryId == null) {
            repositoryId = DigestUtils.md5Hex((String)this.getDataDir().getAbsolutePath());
        }
        this.kafkaProducerRegistry = new KafkaProducerRegistry(this, repositoryId);
        super.initialize(initReason, pluginConnection);
    }

    public void shutdown(ShutdownReason shutdownReason) {
        super.shutdown(shutdownReason);
        if (this.kafkaProducerRegistry != null) {
            this.kafkaProducerRegistry.close();
            this.kafkaProducerRegistry = null;
        }
    }

    public String getName() {
        return "kafka-connector";
    }

    protected ExternalStore openExistingStore(String storeName, Options storeOptions, PluginConnection pluginConnection) {
        return KafkaStore.open(storeName, storeOptions, this, pluginConnection);
    }

    protected ExternalStore createNewStore(String storeName, Options options, PluginConnection pluginConnection, Entities entitiesForCreation) {
        return KafkaStore.create(storeName, options, this, pluginConnection, entitiesForCreation);
    }

    public List<Option<?>> getAllOptions() {
        return OPTIONS;
    }

    protected String getURIComponent() {
        return "kafka";
    }

    public String getShortName() {
        return "Kafka";
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        super.transactionStarted(pluginConnection);
    }

    public void commitExternalTransaction() {
        if (this.activeKafkaTransactions != null) {
            for (KafkaProducerRegistry.ReferencedProducer producer : this.activeKafkaTransactions) {
                try {
                    producer.commit();
                }
                catch (Exception e) {
                    this.abortKafkaTransactions();
                    throw e;
                }
            }
            this.activeKafkaTransactions = null;
        }
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        this.abortKafkaTransactions();
        super.transactionAborted(pluginConnection);
    }

    private void abortKafkaTransactions() {
        if (this.activeKafkaTransactions != null) {
            for (KafkaProducerRegistry.ReferencedProducer producer : this.activeKafkaTransactions) {
                try {
                    producer.rollback();
                }
                catch (Exception e) {
                    this.getLogger().warn("Failed to abort Kafka transaction", (Throwable)e);
                }
            }
            this.activeKafkaTransactions = null;
        }
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        assert (this.activeKafkaTransactions == null);
        super.transactionCompleted(pluginConnection);
    }

    synchronized void beginKafkaTransaction(KafkaProducerRegistry.ReferencedProducer kafkaProducer) {
        if (this.activeKafkaTransactions == null) {
            this.activeKafkaTransactions = Collections.newSetFromMap(new IdentityHashMap());
        }
        if (this.activeKafkaTransactions.add(kafkaProducer)) {
            kafkaProducer.begin();
        }
    }

    protected Set<String> getOptionsToRedactForUser() {
        return Set.of(KAFKA_NODE_PARAM_NAME, KAFKA_PLAIN_AUTH_USERNAME_PARAM_NAME, KAFKA_PLAIN_AUTH_PASSWORD_PARAM_NAME, "authenticationConfiguratorClass");
    }
}

