/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.kafka;

import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaPlugin;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaProducerRegistry;
import com.ontotext.trree.plugin.externalsync.impl.kafka.KafkaStore;
import com.ontotext.trree.sdk.HealthCheckable;
import com.ontotext.trree.sdk.HealthResult;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class KafkaDriver
implements HealthCheckable {
    private static final int KAFKA_ID_LENGTH_LIMIT = 1024;
    private final KafkaPlugin plugin;
    private final Logger logger;
    private final String indexName;
    private final KafkaProducerRegistry.ReferencedProducer kafkaProducer;
    private final AtomicBoolean kafkaTransactionIsActive = new AtomicBoolean();
    private final AtomicLong numDocumentsWrittenInTransaction = new AtomicLong();
    private final String kafkaTopic;
    private final boolean ignoreDeleteAll;
    private boolean useKafkaTransactions;
    private final KafkaStore store;

    KafkaDriver(KafkaPlugin plugin, KafkaStore store, String indexName, Options options) {
        this.plugin = plugin;
        this.store = store;
        this.logger = plugin.getLogger();
        this.indexName = indexName;
        this.kafkaTopic = (String)options.getValue(KafkaPlugin.KAFKA_TOPIC);
        this.ignoreDeleteAll = (Boolean)options.getValueWithDefault(KafkaPlugin.KAFKA_IGNORE_DELETE_ALL);
        this.useKafkaTransactions = (Boolean)options.getValueWithDefault(KafkaPlugin.KAFKA_USE_TRANSACTION);
        this.kafkaProducer = plugin.kafkaProducerRegistry.acquireProducer(store);
    }

    private void beginInternal() {
        if (this.useKafkaTransactions && this.store.isTestingTransaction() && this.kafkaTransactionIsActive.compareAndSet(false, true)) {
            this.plugin.beginKafkaTransaction(this.kafkaProducer);
        }
    }

    private void updateDocument(String uri, Map<?, ?> document) {
        if (uri == null || uri.length() <= 1024) {
            if (this.store.isTestingTransaction()) {
                this.beginInternal();
                this.kafkaProducer.sendRecord(this.kafkaTopic, uri, document);
            }
            this.numDocumentsWrittenInTransaction.incrementAndGet();
        } else {
            this.logger.warn("[{}] Skipping document with id longer than {} characters: {}", new Object[]{this.indexName, 1024, uri});
        }
    }

    void begin() {
        this.kafkaTransactionIsActive.set(false);
        this.numDocumentsWrittenInTransaction.set(0L);
    }

    void delete(String uri) {
        this.updateDocument(uri, null);
    }

    void deleteAll() {
        if (!this.ignoreDeleteAll) {
            this.updateDocument(null, null);
        } else {
            this.logger.warn("[{}] Removal of all statements from repository ignored (kafkaIgnoreDeleteAll is true)", (Object)this.store.getName());
        }
    }

    public void index(String uri, Map<String, Object> document) {
        this.updateDocument(uri, document);
    }

    void close() {
        this.plugin.kafkaProducerRegistry.releaseProducer(this.store, this.kafkaProducer);
    }

    public HealthResult runHealthCheck() {
        try {
            long startTime = System.currentTimeMillis();
            int numPartitions = this.kafkaProducer.getNumPartitions(this.kafkaTopic);
            long endTime = System.currentTimeMillis();
            if (numPartitions > 0) {
                String message = String.format("list partitions took %d ms, %d partitions", endTime - startTime, numPartitions);
                if (this.store.isOutOfSync()) {
                    return new HealthResult(this.indexName, HealthResult.Status.YELLOW, message + " but data may be out of sync");
                }
                return new HealthResult(this.indexName, HealthResult.Status.GREEN, message);
            }
            return new HealthResult(this.indexName, HealthResult.Status.YELLOW, "Zero partitions for topic " + this.kafkaTopic);
        }
        catch (Exception e) {
            return new HealthResult(this.indexName, HealthResult.Status.RED, "Cannot read Kafka partitions: " + e.getMessage());
        }
    }

    void init() {
        this.kafkaProducer.init();
    }

    void updateOptions(Options newOptions) {
        this.useKafkaTransactions = (Boolean)newOptions.getValueWithDefault(KafkaPlugin.KAFKA_USE_TRANSACTION);
        this.kafkaProducer.updateConfig(this.store, newOptions);
    }

    long getNumberOfDocumentsInTransaction() {
        return this.numDocumentsWrittenInTransaction.get();
    }
}

