/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.engine.kotlin;

import com.ontotext.script.engine.kotlin.ScriptEngineProvider;
import com.ontotext.script.engine.kotlin.TemplateEvaluator;
import com.ontotext.script.model.JsBaseTemporalValue;
import com.ontotext.script.model.JsIriValue;
import com.ontotext.script.model.JsNumberValue;
import com.ontotext.script.model.JsStringValue;
import com.ontotext.script.model.JsUtils;
import com.ontotext.script.model.JsValue;
import com.ontotext.script.model.ValueResolver;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0012J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u001a\u0010\u001b\u001a\u00020\u00192\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u001dJ\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0012\u0010$\u001a\u00020#2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0002J\f\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0016\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010&\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/ontotext/script/engine/kotlin/TemplateEvaluator;", "", "engineContext", "Lcom/ontotext/script/engine/kotlin/ScriptEngineProvider;", "(Lcom/ontotext/script/engine/kotlin/ScriptEngineProvider;)V", "currentNowValue", "Lcom/ontotext/script/model/JsValue;", "escapeFunRegex", "Lkotlin/text/Regex;", "escapeRegex", "expPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "expRegex", "formatRegex", "nonWordCharsRegex", "nowRegex", "escapeJsStrings", "", "expression", "eval", "template", "evalExp", "exp", "evalValue", "", "genValue", "generate", "templates", "", "invokeFun", "value", "token", "iri", "isLeadingSchema", "", "isValueNotResolved", "now", "pattern", "parseAndEval", "resolveIriPrefix", "item", "uuid", "graphdb-graphql-value-generation"})
@SourceDebugExtension(value={"SMAP\nTemplateEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateEvaluator.kt\ncom/ontotext/script/engine/kotlin/TemplateEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,340:1\n1855#2,2:341\n*S KotlinDebug\n*F\n+ 1 TemplateEvaluator.kt\ncom/ontotext/script/engine/kotlin/TemplateEvaluator\n*L\n34#1:341,2\n*E\n"})
public class TemplateEvaluator {
    @NotNull
    private final ScriptEngineProvider engineContext;
    @NotNull
    private final Regex expRegex;
    private final Pattern expPattern;
    @NotNull
    private final Regex nowRegex;
    @NotNull
    private final Regex escapeRegex;
    @NotNull
    private final Regex nonWordCharsRegex;
    @NotNull
    private final Regex escapeFunRegex;
    @NotNull
    private final Regex formatRegex;
    @Nullable
    private JsValue<?> currentNowValue;

    public TemplateEvaluator(@NotNull ScriptEngineProvider engineContext) {
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        this.engineContext = engineContext;
        this.expRegex = new Regex("\\$\\{([^{}]*)}");
        this.expPattern = Pattern.compile("\\$\\{([^{}]*)}");
        this.nowRegex = new Regex("now\\(\"(.+)\"\\)");
        this.escapeRegex = new Regex("[\\W_]+$");
        this.nonWordCharsRegex = new Regex("^\\W+");
        this.escapeFunRegex = new Regex("escape\\(\"(.+)\"\\)");
        this.formatRegex = new Regex("format\\(\"(.+)\"\\)");
    }

    public final void generate(@NotNull List<? extends JsValue<Object>> templates) {
        Intrinsics.checkNotNullParameter(templates, (String)"templates");
        Iterable $this$forEach$iv = templates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsValue template = (JsValue)element$iv;
            boolean bl = false;
            this.evalValue((JsValue<Object>)template);
        }
    }

    private final void evalValue(JsValue<Object> template) {
        if (!template.isLazy() || !template.isEmpty()) {
            return;
        }
        ValueResolver valueResolver = template.getValueResolver();
        Intrinsics.checkNotNullExpressionValue((Object)valueResolver, (String)"getValueResolver(...)");
        ValueResolver resolver = valueResolver;
        String string = resolver.getEvaluation();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEvaluation(...)");
        Object value = this.eval(string);
        if (this.isValueNotResolved(value)) {
            resolver.setComputedValue(null);
        } else {
            resolver.setComputedValue(value);
        }
    }

    @NotNull
    public final Object eval(@NotNull String template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        String expression = this.escapeJsStrings(template);
        if (StringsKt.startsWith$default((String)expression, (String)"genValue`", (boolean)false, (int)2, null)) {
            expression = StringsKt.replace$default((String)StringsKt.replace$default((String)expression, (String)"genValue`", (String)"", (boolean)false, (int)4, null), (String)"`", (String)"", (boolean)false, (int)4, null);
            return this.genValue(expression);
        }
        if (StringsKt.startsWith$default((String)expression, (String)"_iri`", (boolean)false, (int)2, null)) {
            expression = StringsKt.replace$default((String)StringsKt.replace$default((String)expression, (String)"_iri`", (String)"", (boolean)false, (int)4, null), (String)"`", (String)"", (boolean)false, (int)4, null);
            return this.iri(expression);
        }
        return this.expRegex.replace((CharSequence)expression, (Function1)new Function1<MatchResult, CharSequence>(this){
            final /* synthetic */ TemplateEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return String.valueOf(TemplateEvaluator.access$evalExp(this.this$0, "\"" + it.getValue() + "\""));
            }
        });
    }

    private final String escapeJsStrings(String expression) {
        return new Regex("('.+')").replace((CharSequence)expression, (Function1)escapeJsStrings.1.INSTANCE);
    }

    private final String genValue(String expression) {
        CharSequence charSequence = expression;
        if (!new Regex("(?<!\\\\)\\$").containsMatchIn(charSequence)) {
            return expression;
        }
        Matcher matcher = this.expPattern.matcher(expression);
        StringBuffer result = new StringBuffer();
        boolean foundExp = false;
        while (matcher.find()) {
            String string;
            foundExp = true;
            String string2 = matcher.group(1);
            if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) continue;
            String exp = string2;
            Object object = this.evalExp(exp);
            if (object == null) {
                object = "";
            }
            Object resolved = object;
            if (resolved instanceof JsValue && ((JsValue)resolved).isLazy()) {
                this.evalValue((JsValue<Object>)((JsValue)resolved));
                string = this.isValueNotResolved(resolved) ? (resolved instanceof JsNumberValue ? "0" : "") : resolved.toString();
            } else {
                string = this.isValueNotResolved(resolved) ? (resolved instanceof JsNumberValue ? "0" : "") : resolved.toString();
            }
            String value = StringsKt.replace$default((String)string, (String)"$", (String)"\\$", (boolean)false, (int)4, null);
            matcher.appendReplacement(result, value);
        }
        matcher.appendTail(result);
        if (!foundExp) {
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.genValue(string);
    }

    private final String iri(String template) {
        StringBuffer result = new StringBuffer();
        List matches = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)this.expRegex, (CharSequence)template, (int)0, (int)2, null));
        int lastIndex = 0;
        Iterator iterator = matches.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String lastSection;
            int index = n++;
            MatchResult match = (MatchResult)iterator.next();
            Object object = match.getGroups().get(1);
            if (object == null || (object = object.getValue()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) continue;
            Object expression = object;
            Intrinsics.checkNotNullExpressionValue((Object)template.substring(lastIndex, match.getRange().getFirst()), (String)"substring(...)");
            String prefix = index == 0 ? this.resolveIriPrefix(lastSection) : lastSection.toString();
            Object value = this.evalExp((String)expression);
            if (value instanceof JsValue) {
                ((JsValue)value).escape();
                if (((JsValue)value).isIri() && value instanceof JsIriValue) {
                    ((JsIriValue)value).compact();
                }
                if (((JsValue)value).isLazy()) {
                    this.evalValue((JsValue<Object>)((JsValue)value));
                }
                if (this.isValueNotResolved(value)) {
                    var13_13 = prefix;
                    var14_14 = this.escapeRegex;
                    var15_15 = "";
                    result.append(var14_14.replace(var13_13, var15_15));
                } else {
                    result.append(prefix).append(value);
                }
            } else if (value == null) {
                var13_13 = prefix;
                var14_14 = this.escapeRegex;
                var15_15 = "";
                result.append(var14_14.replace(var13_13, var15_15));
            } else {
                result.append(prefix).append(value.toString());
            }
            lastIndex = match.getRange().getLast() + 1;
        }
        if (lastIndex < template.length()) {
            if (((CharSequence)result).length() == 0) {
                String string = template.substring(lastIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.append(this.resolveIriPrefix(string));
            } else {
                String string = template.substring(lastIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.append(string);
            }
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Object evalExp(String exp) {
        Object object = this.parseAndEval(exp);
        if (object == null) {
            Object object2;
            try {
                object2 = this.engineContext.getEngine().eval(exp);
            }
            catch (ScriptException e) {
                if (!(e.getCause() instanceof ArithmeticException)) {
                    throw new IllegalArgumentException("Failed to evaluate expression: " + exp, e);
                }
                return "error";
            }
            object = object2;
        }
        return object;
    }

    private final Object parseAndEval(String expression) {
        if (StringsKt.startsWith$default((String)expression, (String)"now(", (boolean)false, (int)2, null)) {
            Object object;
            return StringsKt.endsWith$default((String)expression, (String)"()", (boolean)false, (int)2, null) ? this.now() : this.now((object = Regex.find$default((Regex)this.nowRegex, (CharSequence)expression, (int)0, (int)2, null)) != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null);
        }
        if (Intrinsics.areEqual((Object)expression, (Object)"uuid()")) {
            return this.uuid();
        }
        Object prop = this.engineContext.getBindings().get(expression);
        if (prop != null) {
            return prop;
        }
        CharSequence charSequence = expression;
        Regex regex = new Regex("\\.");
        int n = 0;
        List tokens = regex.split(charSequence, n);
        Object object = this.engineContext.getBindings().get(CollectionsKt.first((List)tokens));
        if (object == null) {
            return null;
        }
        Object any = object;
        tokens.stream().skip(1L).forEach(arg_0 -> TemplateEvaluator.parseAndEval$lambda$1((Function1)new Function1<String, Unit>(this, any){
            final /* synthetic */ TemplateEvaluator this$0;
            final /* synthetic */ Object $any;
            {
                this.this$0 = $receiver;
                this.$any = $any;
                super(1);
            }

            public final void invoke(String token) {
                Intrinsics.checkNotNull((Object)token);
                TemplateEvaluator.access$invokeFun(this.this$0, this.$any, token);
            }
        }, arg_0));
        return any;
    }

    private final void invokeFun(Object value, String token) {
        if (Intrinsics.areEqual((Object)token, (Object)"lowerCase()")) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.ontotext.script.model.JsStringValue");
            JsStringValue cfr_ignored_0 = (JsStringValue)value;
            ((JsStringValue)value).lowerCase();
        } else if (Intrinsics.areEqual((Object)token, (Object)"upperCase()")) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.ontotext.script.model.JsStringValue");
            JsStringValue cfr_ignored_1 = (JsStringValue)value;
            ((JsStringValue)value).upperCase();
        } else if (Intrinsics.areEqual((Object)token, (Object)"escape()")) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.ontotext.script.model.JsValue<*>");
            JsValue cfr_ignored_2 = (JsValue)value;
            ((JsValue)value).escape();
        } else if (StringsKt.startsWith$default((String)token, (String)"escape(", (boolean)false, (int)2, null)) {
            Object object = Regex.find$default((Regex)this.escapeFunRegex, (CharSequence)token, (int)0, (int)2, null);
            String escapeValue = object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.ontotext.script.model.JsValue<*>");
            JsValue cfr_ignored_3 = (JsValue)value;
            ((JsValue)value).escape(escapeValue);
        } else if (StringsKt.startsWith$default((String)token, (String)"format(", (boolean)false, (int)2, null)) {
            Object object = Regex.find$default((Regex)this.formatRegex, (CharSequence)token, (int)0, (int)2, null);
            String patternValue = object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.ontotext.script.model.JsBaseTemporalValue<*>");
            JsBaseTemporalValue cfr_ignored_4 = (JsBaseTemporalValue)value;
            ((JsBaseTemporalValue)value).format(patternValue);
        } else if (Intrinsics.areEqual((Object)token, (Object)"compact()")) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.ontotext.script.model.JsIriValue");
            JsIriValue cfr_ignored_5 = (JsIriValue)value;
            ((JsIriValue)value).compact();
        }
    }

    private final JsValue<Object> uuid() {
        JsValue jsValue = JsUtils.uuid();
        Intrinsics.checkNotNullExpressionValue((Object)jsValue, (String)"uuid(...)");
        return jsValue;
    }

    private final JsValue<?> now() {
        return this.now(null);
    }

    private final JsValue<?> now(String pattern) {
        if (this.currentNowValue == null) {
            this.currentNowValue = JsUtils.now(null);
        }
        JsValue<?> jsValue = this.currentNowValue;
        Intrinsics.checkNotNull(jsValue);
        JsValue value = jsValue.copy();
        if (value instanceof JsBaseTemporalValue) {
            JsBaseTemporalValue jsBaseTemporalValue = ((JsBaseTemporalValue)value).format(pattern);
            Intrinsics.checkNotNullExpressionValue((Object)jsBaseTemporalValue, (String)"format(...)");
            return (JsValue)jsBaseTemporalValue;
        }
        Intrinsics.checkNotNull((Object)value);
        return value;
    }

    private final String resolveIriPrefix(String item) {
        Regex regex = this.nonWordCharsRegex;
        CharSequence charSequence = item;
        String string = "";
        String trimmedValue = regex.replace(charSequence, string);
        if (StringsKt.contains$default((CharSequence)trimmedValue, (CharSequence)":", (boolean)false, (int)2, null)) {
            Object object;
            String string2 = trimmedValue.substring(0, StringsKt.indexOf$default((CharSequence)trimmedValue, (String)":", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String prefix = string2;
            if (this.isLeadingSchema(prefix)) {
                object = trimmedValue;
            } else if (this.engineContext.getPrefixes().containsKey(prefix)) {
                String string3 = this.engineContext.getPrefixes().get(prefix);
                String string4 = trimmedValue.substring(StringsKt.indexOf$default((CharSequence)trimmedValue, (String)":", (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                object = string3 + string4;
            } else {
                throw new RuntimeException("Invalid iri pattern prefix '" + trimmedValue + "'");
            }
            return object;
        }
        return this.engineContext.getPrefixes().get("base_iri") + trimmedValue;
    }

    private final boolean isLeadingSchema(String value) {
        return StringsKt.startsWith$default((String)value, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"https", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"mailto", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"urn", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"geo", (boolean)false, (int)2, null);
    }

    private final boolean isValueNotResolved(Object value) {
        if (value == null) {
            return true;
        }
        String str = value.toString();
        return str == null || Intrinsics.areEqual((Object)str, (Object)"null") || Intrinsics.areEqual((Object)str, (Object)"NaN") || Intrinsics.areEqual((Object)str, (Object)"Infinity") || Intrinsics.areEqual((Object)str, (Object)"") || Intrinsics.areEqual((Object)str, (Object)"error");
    }

    private static final void parseAndEval$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$evalExp(TemplateEvaluator $this, String exp) {
        return $this.evalExp(exp);
    }

    public static final /* synthetic */ void access$invokeFun(TemplateEvaluator $this, Object value, String token) {
        $this.invokeFun(value, token);
    }
}

