/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.engine.kotlin;

import com.ontotext.script.engine.JsValueGenerator;
import com.ontotext.script.engine.kotlin.ScriptEngineProvider;
import com.ontotext.script.engine.kotlin.TemplateEvaluator;
import com.ontotext.script.model.JsValue;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;

public class KotlinJsValueGenerator
implements JsValueGenerator {
    public void generateValues(List<JsValue> patterns, Map<String, Object> bindings) {
        if (patterns.isEmpty()) {
            return;
        }
        List<JsValue> values = patterns.stream().map(val -> val).toList();
        try {
            KotlinJsValueGenerator.createTemplateEvaluator(bindings).generate(values);
        }
        catch (Exception se) {
            if (se instanceof ScriptException) {
                throw new IllegalArgumentException(se);
            }
            if (se instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)se;
                throw re;
            }
            throw new IllegalArgumentException(se);
        }
    }

    public Object evalTemplate(String templateFunction, String expression, Map<String, Object> bindings) {
        return KotlinJsValueGenerator.createTemplateEvaluator(bindings).eval(templateFunction + "`" + expression + "`");
    }

    @NotNull
    private static TemplateEvaluator createTemplateEvaluator(Map<String, Object> bindings) {
        Map prefixes = (Map)bindings.get("_prefix");
        ScriptEngineProvider engineProvider = new ScriptEngineProvider(bindings, prefixes);
        return new TemplateEvaluator(engineProvider);
    }

    public void close() {
    }
}

