/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.rdf4j;

import com.ontotext.metamodel.storage.ImmediateSchemaNotificationService;
import com.ontotext.metamodel.storage.PollingSchemaNotificationService;
import com.ontotext.metamodel.storage.SchemaBindingChanged;
import com.ontotext.metamodel.storage.SchemaEvent;
import com.ontotext.metamodel.storage.SchemaNotificationService;
import com.ontotext.metamodel.storage.SchemaNotificationStrategy;
import com.ontotext.metamodel.storage.SomlSchemaIdStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorageUpdate;
import com.ontotext.metamodel.storage.rdf4j.DefaultRepositoryCreator;
import com.ontotext.metamodel.storage.rdf4j.Rdf4JSomlSchemaStore;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.sparql.ChainingRepositoryCreator;
import com.ontotext.sparql.FileRepositoryCreator;
import com.ontotext.sparql.RepositoryCreator;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointConfiguration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class Rdf4JSomlSchemaStoreBuilder {
    private final SparqlEndpointConfiguration configuration;
    private boolean autoCreateRepository = true;
    private String repositoryConfig;
    private Boolean disableDefault;
    private Integer pollingInterval;
    private Boolean async;
    private final SparqlConnectionFactory connectionFactory;
    private SomlSchemaStorage.SchemaExistsStrategy existsStrategy;
    private SchemaNotificationService notificationService;
    private SomlSchemaIdStorage idStorage;

    public Rdf4JSomlSchemaStoreBuilder(SparqlEndpointConfiguration configuration, SparqlConnectionFactory connectionFactory) {
        this.configuration = Objects.requireNonNull(configuration, "Connection configuration is required");
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "Connection factory is required");
    }

    public SparqlEndpointConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isAutoCreateRepository() {
        return this.autoCreateRepository;
    }

    public Rdf4JSomlSchemaStoreBuilder setAutoCreateRepository(boolean autoCreateRepository) {
        this.autoCreateRepository = autoCreateRepository;
        return this;
    }

    public String getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public Rdf4JSomlSchemaStoreBuilder setRepositoryConfig(String repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
        return this;
    }

    public boolean isDisableDefault() {
        return Boolean.TRUE.equals(this.disableDefault);
    }

    public Rdf4JSomlSchemaStoreBuilder setDisableDefault(Boolean disableDefault) {
        this.disableDefault = disableDefault;
        return this;
    }

    public SparqlConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public SomlSchemaStorage.SchemaExistsStrategy getExistsStrategy() {
        return this.existsStrategy;
    }

    public Rdf4JSomlSchemaStoreBuilder setExistsStrategy(SomlSchemaStorage.SchemaExistsStrategy existsStrategy) {
        this.existsStrategy = existsStrategy;
        return this;
    }

    public SchemaNotificationService getNotificationService() {
        return this.notificationService;
    }

    public Rdf4JSomlSchemaStoreBuilder setNotificationService(SchemaNotificationService notificationService) {
        this.notificationService = notificationService;
        return this;
    }

    public Rdf4JSomlSchemaStoreBuilder useImmediateNotificationService() {
        this.notificationService = new ImmediateSchemaNotificationService();
        return this;
    }

    public Integer getPollingInterval() {
        return this.pollingInterval;
    }

    public Boolean isAsync() {
        return this.async;
    }

    public Rdf4JSomlSchemaStoreBuilder usePollingNotificationService(int pollingInterval, boolean async) {
        this.pollingInterval = pollingInterval;
        this.async = async;
        this.notificationService = new LazyPollingNotificationService(pollingInterval, async);
        return this;
    }

    public Rdf4JSomlSchemaStore build() {
        SchemaNotificationService localNotificationService;
        SparqlEndpoint endpoint = this.getConfiguration().getEndpoint();
        RepositoryCreator repositoryCreator = this.getRepositoryCreators();
        if (repositoryCreator != null) {
            this.getConnectionFactory().setExclusiveRepositoryCreator(endpoint.getRepository(), repositoryCreator);
        }
        if ((localNotificationService = this.getNotificationService()) == null) {
            throw new IllegalStateException("SchemaNotificationService must be set before building store instance");
        }
        Rdf4JSomlSchemaStore store = new Rdf4JSomlSchemaStore((EndpointProvider)this.getConfiguration(), this.getConnectionFactory(), localNotificationService);
        if (localNotificationService instanceof LazyPollingNotificationService) {
            ((LazyPollingNotificationService)localNotificationService).init(store, this.getSchemaIdStorage());
            localNotificationService.start();
        }
        if (this.getExistsStrategy() == null) {
            store.setSchemaExistsStrategy((SomlSchemaStorage.SchemaExistsStrategy)new SomlSchemaStorage.DefaultSchemaExistsStrategy());
        } else {
            store.setSchemaExistsStrategy(this.getExistsStrategy());
        }
        return store;
    }

    @Nullable
    private RepositoryCreator getRepositoryCreators() {
        ArrayList<Object> creators = new ArrayList<Object>();
        if (this.isAutoCreateRepository()) {
            if (StringUtils.isNotEmpty((CharSequence)this.getRepositoryConfig())) {
                creators.add(new FileRepositoryCreator(this.getRepositoryConfig()));
                if (this.disableDefault == null) {
                    this.disableDefault = true;
                }
            }
            if (!this.isDisableDefault()) {
                creators.add((Object)new DefaultRepositoryCreator());
            }
        }
        ChainingRepositoryCreator repositoryCreator = null;
        if (!creators.isEmpty()) {
            repositoryCreator = new ChainingRepositoryCreator(creators);
        }
        return repositoryCreator;
    }

    public Rdf4JSomlSchemaStoreBuilder setSchemaIdStorage(SomlSchemaIdStorage idStorage) {
        this.idStorage = idStorage;
        return this;
    }

    public SomlSchemaIdStorage getSchemaIdStorage() {
        return this.idStorage;
    }

    private static class LazyPollingNotificationService
    implements SchemaNotificationService {
        private SchemaNotificationService delegate;
        private SomlSchemaStorage schemaStorage;
        private SomlSchemaIdStorage idStorage;
        private final int pollingInterval;
        private final boolean async;

        public LazyPollingNotificationService(int pollingInterval, boolean async) {
            this.pollingInterval = pollingInterval;
            this.async = async;
        }

        void init(SomlSchemaStorage schemaStorage, SomlSchemaIdStorage idStorage) {
            this.schemaStorage = schemaStorage;
            this.idStorage = idStorage;
            this.delegate = null;
        }

        public void start() {
            this.getDelegate().start();
        }

        public void setNotificationStrategy(SchemaNotificationStrategy strategy) {
            this.getDelegate().setNotificationStrategy(strategy);
        }

        public SchemaNotificationStrategy getStrategy() {
            return this.getDelegate().getStrategy();
        }

        public void notifyListeners(SchemaEvent event) {
            this.getDelegate().notifyListeners(event);
        }

        public void registerListener(Consumer<SomlSchemaStorageUpdate> consumer) {
            this.getDelegate().registerListener(consumer);
        }

        public void registerBindListener(Consumer<SchemaBindingChanged> consumer) {
            this.getDelegate().registerBindListener(consumer);
        }

        public void unregisterListener(Consumer<SomlSchemaStorageUpdate> consumer) {
            this.getDelegate().unregisterListener(consumer);
        }

        public void unregisterBindListener(Consumer<SchemaBindingChanged> consumer) {
            this.getDelegate().unregisterBindListener(consumer);
        }

        public void stop() {
            this.getDelegate().stop();
        }

        private SchemaNotificationService getDelegate() {
            if (this.delegate == null) {
                this.delegate = new PollingSchemaNotificationService(this.schemaStorage, this.idStorage, this.pollingInterval, this.async);
            }
            return this.delegate;
        }
    }
}

