/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.iterators.master;

import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.iterators.master.AbstractResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.RegisteredIterator;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public final class MasterResultIterator
extends AbstractResultIterator {
    private String queryString;
    private String similarityQueryString;
    private boolean done = false;
    public ExternalRetrieve state;
    private long entitySubjectFilter;
    private ExternalSyncRequestContext context;
    private SearchOptions searchOptions;

    public MasterResultIterator(PluginConnection pluginConnection, SearchOptions searchOptions, ExternalSyncRequestContext context) {
        this.setPluginConnection(pluginConnection);
        BNode node = SimpleValueFactory.getInstance().createBNode();
        this.subject = this.getEntities().put((Value)node, Entities.Scope.REQUEST);
        this.searchOptions = searchOptions;
        this.context = context;
    }

    public boolean next() {
        if (this.closed) {
            return false;
        }
        if (this.done) {
            this.context.unregisterIterator(this);
            return false;
        }
        this.done = true;
        return true;
    }

    public void setQueryString(@Nullable String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getSimilarityQueryString() {
        return this.similarityQueryString;
    }

    public void setSimilarityQueryString(String similarityQueryString) {
        this.similarityQueryString = similarityQueryString;
    }

    public SearchOptions getSearchOptions() {
        return this.searchOptions;
    }

    public void setState(ExternalRetrieve state) {
        this.state = state;
    }

    @Override
    public void close() {
        super.close();
        if (this.state != null) {
            this.state.close();
        }
    }

    public boolean isSnippets() {
        return this.context.isCollectSnippets();
    }

    public boolean isTrackTotalHits() {
        return this.context.isTrackTotalHits();
    }

    public boolean isTrackScore() {
        return this.context.isTrackScore();
    }

    public void setEntitySubjectFilter(long entitySubjectFilter) {
        this.entitySubjectFilter = entitySubjectFilter;
    }

    public long getEntitySubjectFilter() {
        return this.entitySubjectFilter;
    }

    public void unregisterIterator(RegisteredIterator itty) {
        if (itty instanceof AbstractResultIterator) {
            this.context.unregisterIterator((AbstractResultIterator)((Object)itty));
        }
    }

    public ClassLoader getPluginClassLoader() {
        return this.context.getPluginClassLoader();
    }
}

