/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl;

import com.ontotext.trree.plugin.externalsync.api.SyncDocument;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import gnu.trove.TLongArrayList;
import org.eclipse.rdf4j.model.IRI;

public final class FieldNameTransform
extends Enum<FieldNameTransform> {
    public static final /* enum */ FieldNameTransform NONE_TRANSFORM = new FieldNameTransform("none", false);
    public static final /* enum */ FieldNameTransform PREDICATE_TRANSFORM = new FieldNameTransform("predicate", true);
    public static final /* enum */ FieldNameTransform PREDICATE_LOCAL_NAME_TRANSFORM = new FieldNameTransform("predicate.localName", true);
    private final boolean predicateNeeded;
    private final String transformString;
    private static final /* synthetic */ FieldNameTransform[] $VALUES;

    public static FieldNameTransform[] values() {
        return (FieldNameTransform[])$VALUES.clone();
    }

    public static FieldNameTransform valueOf(String name) {
        return Enum.valueOf(FieldNameTransform.class, name);
    }

    private FieldNameTransform(String transformString, boolean predicateNeeded) {
        this.transformString = transformString;
        this.predicateNeeded = predicateNeeded;
    }

    public boolean isPredicateNeeded() {
        return this.predicateNeeded;
    }

    public String getTransformString() {
        return this.transformString;
    }

    public String apply(Property property, SyncDocument<?> doc, TLongArrayList values, int valueIndex) {
        String fieldName = property.getFieldNameWithoutSuffix();
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                TLongArrayList predicateValues = doc.getPredicateValues(property.getFieldNameWithSuffix());
                assert (predicateValues.size() == values.size());
                long predicateValue = predicateValues.getQuick(valueIndex);
                if (predicateValue == 0L) break;
                IRI predicate = (IRI)doc.resolveId(predicateValue);
                if (this == PREDICATE_LOCAL_NAME_TRANSFORM) {
                    fieldName = predicate.getLocalName();
                    if (!fieldName.isEmpty()) break;
                    return predicate.stringValue();
                }
                fieldName = predicate.stringValue();
            }
        }
        return fieldName;
    }

    public static FieldNameTransform lookupTransform(String transformString) {
        for (FieldNameTransform fnt : FieldNameTransform.values()) {
            if (!fnt.transformString.equalsIgnoreCase(transformString)) continue;
            return fnt;
        }
        return null;
    }

    public static boolean isValidTransform(String transformString) {
        return FieldNameTransform.lookupTransform(transformString) != null;
    }

    private static /* synthetic */ FieldNameTransform[] $values() {
        return new FieldNameTransform[]{NONE_TRANSFORM, PREDICATE_TRANSFORM, PREDICATE_LOCAL_NAME_TRANSFORM};
    }

    static {
        $VALUES = FieldNameTransform.$values();
    }
}

