/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.ontotext.trree.SystemGraphs;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.TransactionFingerprintTracker;
import com.ontotext.trree.plugin.externalsync.api.CloseableIterator;
import com.ontotext.trree.plugin.externalsync.api.ConnectorException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.ExternalStoreStatus;
import com.ontotext.trree.plugin.externalsync.api.LongLongIndex;
import com.ontotext.trree.plugin.externalsync.api.SyncDocument;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.OptionsUtil;
import com.ontotext.trree.plugin.externalsync.filter.Expression;
import com.ontotext.trree.plugin.externalsync.filter.FilterType;
import com.ontotext.trree.plugin.externalsync.filter.FilterUtil;
import com.ontotext.trree.plugin.externalsync.filter.ParsedFilter;
import com.ontotext.trree.plugin.externalsync.filter.TrueExpression;
import com.ontotext.trree.plugin.externalsync.impl.FieldNameTransform;
import com.ontotext.trree.plugin.externalsync.impl.ImplicitFilteringStatementIterator;
import com.ontotext.trree.plugin.externalsync.impl.InvalidFieldValueException;
import com.ontotext.trree.plugin.externalsync.impl.LongLongIndexModifiablePairCollection;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.SingletonStatementIterator;
import com.ontotext.trree.plugin.externalsync.impl.TypeAndPropertyKeeper;
import com.ontotext.trree.plugin.externalsync.util.ClassLoaderUtil;
import com.ontotext.trree.plugin.externalsync.util.LanguageMatcher;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TLongLongIterator;
import gnu.trove.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;

public abstract class AbstractExternalStore<T>
implements ExternalStore {
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("(?<grandfathered>(?:en-GB-oed|i-(?:ami|bnn|default|enochian|hak|klingon|lux|mingo|navajo|pwn|t(?:a[oy]|su))|sgn-(?:BE-(?:FR|NL)|CH-DE))|(?:art-lojban|cel-gaulish|no-(?:bok|nyn)|zh-(?:guoyu|hakka|min(?:-nan)?|xiang)))|(?:(?<language>(?:[A-Za-z]{2,3}(?:-(?<extlang>[A-Za-z]{3}(?:-[A-Za-z]{3}){0,2}))?)|[A-Za-z]{4}|[A-Za-z]{5,8})(?:-(?<script>[A-Za-z]{4}))?(?:-(?<region>[A-Za-z]{2}|[0-9]{3}))?(?:-(?<variant>[A-Za-z0-9]{5,8}|[0-9][A-Za-z0-9]{3}))*(?:-(?<extension>[0-9A-WY-Za-wy-z](?:-[A-Za-z0-9]{2,8})+))*)(?:-(?<privateUse>x(?:-[A-Za-z0-9]{1,8})+))?");
    public static final String NATIVE_PREFIX = "native:";
    protected final TypeAndPropertyKeeper typePropertyKeeper;
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    protected final long rdfTypeId;
    protected final long rdfsResourceId;
    private final long implicitGraphId;
    private final long explicitGraphId;
    private final long defaultDocumentPredicateId;
    private final long defaultDocumentContextId;
    private final long defaultValuePredicateId;
    private final long defaultValueContextId;
    protected final String name;
    protected final Logger logger;
    protected Options options;
    protected final boolean readonly;
    protected final LanguageMatcher languageMatcher;
    protected final ExternalSyncPlugin plugin;
    private final List<Property> properties;
    private final TransactionFingerprintTracker fingerprintTracker;
    protected TreeSet<Long> entitiesToRefresh;
    protected boolean dynamicOptionsUpdated;
    private boolean filtersUseGraph;
    protected Expression documentFilterExpr;
    protected long transaction;
    protected boolean isTestingTransaction;
    protected Set<String> fieldsThatAreURIs = new HashSet<String>();
    private LongLongIndex dependeesIndex;
    protected final AtomicBoolean initialised;
    private final ExternalStoreStatus status;
    protected boolean wasJustCreated;
    private final String multifieldSuffix;
    private volatile boolean errorInAnotherThread;

    public List<Property> getProperties() {
        return this.properties;
    }

    protected AbstractExternalStore(String name, Options options, boolean wasJustCreated, long initialFingerprint, ExternalSyncPlugin plugin, PluginConnection pluginConnection, Entities entities) {
        this.name = name;
        this.options = options;
        this.wasJustCreated = wasJustCreated;
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.initialised = new AtomicBoolean(false);
        this.multifieldSuffix = this.parseMajorVersion(options.getVersion()) >= 2 ? "$" : "/";
        this.readonly = options.getValueOr(ExternalSyncPlugin.READONLY, false);
        List<Option<?>> propertyList = options.getValue(ExternalSyncPlugin.FIELDS_PLACEHOLDER);
        assert (propertyList != null);
        ImmutableList.Builder propertyBuilder = ImmutableList.builder();
        HashSet<String> existingFieldNames = new HashSet<String>();
        HashSet<String> fieldNamesThatHaveSuffixes = new HashSet<String>();
        for (Option<?> o : propertyList) {
            Property p = this.getPropertyFromElement(o, entities, null);
            String fieldName = p.getFieldNameWithoutSuffix();
            String fieldNameSuffix = p.getFieldNameSuffix();
            if (!this.isValidFieldName(fieldName, true)) {
                throw new ConnectorUserException(String.format("Field name '%s' may not be used.", fieldName));
            }
            String fieldNameWithoutSuffix = fieldName.toLowerCase();
            Object fieldNameWithSuffix = fieldNameWithoutSuffix;
            if (fieldNameSuffix != null) {
                if (!this.isValidFieldNameSuffix(fieldNameSuffix)) {
                    throw new ConnectorUserException(String.format("Field name suffix '%s' may not be used.", fieldNameSuffix));
                }
                fieldNameWithSuffix = (String)fieldNameWithSuffix + this.multifieldSuffix + fieldNameSuffix.toLowerCase();
                fieldNamesThatHaveSuffixes.add(fieldNameWithoutSuffix);
                if (existingFieldNames.contains(fieldNameWithoutSuffix)) {
                    throw new ConnectorUserException(String.format("Field name '%s' was defined once without suffix and once with a suffix.", fieldName));
                }
            } else if (fieldNamesThatHaveSuffixes.contains(fieldNameWithoutSuffix)) {
                throw new ConnectorUserException(String.format("Field name '%s' was defined once without suffix and once with a suffix.", fieldName));
            }
            if (existingFieldNames.contains(fieldNameWithSuffix)) {
                throw new ConnectorUserException(String.format("Field name '%s' used more than once.", fieldName));
            }
            existingFieldNames.add((String)fieldNameWithSuffix);
            propertyBuilder.add((Object)p);
            this.logger.debug("[{}] Creating property chain of size {} - {}.", new Object[]{name, p.getPropertyChain().size(), p.getPropertyChain()});
        }
        ImmutableList properties = propertyBuilder.build();
        this.rdfTypeId = entities.resolve((Value)RDF.TYPE);
        this.typePropertyKeeper = this.createTypeAndPropertyKeeper(options, entities, (ImmutableList<Property>)properties);
        List<String> languages = options.getValueOr(ExternalSyncPlugin.LANGUAGES, Collections.emptyList());
        this.languageMatcher = new LanguageMatcher(languages);
        this.documentFilterExpr = this.parseFilter(options.getValue(ExternalSyncPlugin.DOCUMENT_FILTER), FilterType.DOCUMENT, entities, null);
        Expression rootValueFilterExpr = this.parseFilter(options.getValue(ExternalSyncPlugin.VALUE_FILTER), FilterType.VALUE, entities, null);
        for (Property p : properties) {
            this.parsePropertyFilters(p, entities);
        }
        Property thisProperty = this.typePropertyKeeper.getThisProperty();
        if (thisProperty != null && rootValueFilterExpr != null) {
            thisProperty.setValueFilterExpr(rootValueFilterExpr);
        }
        this.typePropertyKeeper.finalizeStructures();
        this.properties = this.typePropertyKeeper.getProperties();
        this.validateProperties();
        this.rdfsResourceId = entities.resolve((Value)RDFS.RESOURCE);
        this.implicitGraphId = SystemGraphs.IMPLICIT_GRAPH.getId();
        this.defaultDocumentPredicateId = this.explicitGraphId = (long)SystemGraphs.EXPLICIT_GRAPH.getId();
        this.defaultDocumentContextId = this.explicitGraphId;
        this.defaultValuePredicateId = this.explicitGraphId;
        this.defaultValueContextId = this.explicitGraphId;
        this.status = new ExternalStoreStatus();
        this.fingerprintTracker = TransactionFingerprintTracker.createOrLoadExisting(initialFingerprint, plugin.getDataDir(), name);
        if (plugin.isInitialized()) {
            this.transactionStarted(pluginConnection);
        }
    }

    private Expression parseFilter(@Nullable String filter, FilterType filterType, Entities entities, @Nullable Property context) {
        Expression result = TrueExpression.INSTANCE;
        if (filter != null && !filter.isEmpty()) {
            ParsedFilter parsedFilter = FilterUtil.parseFilter(filter, entities, this.typePropertyKeeper, filterType, context);
            result = parsedFilter.expression;
            this.filtersUseGraph |= parsedFilter.needsToCollectGraph;
            if (context != null) {
                context.addFilterDependencies(parsedFilter.filterDependencies);
            }
        }
        return result;
    }

    private void parsePropertyFilters(Property property, Entities entities) {
        property.setDocumentFilterExpr(this.parseFilter(property.getDocumentFilterString(), FilterType.NESTED_DOCUMENT, entities, property));
        property.setValueFilterExpr(this.parseFilter(property.getValueFilterString(), FilterType.PER_FIELD_VALUE, entities, property));
        for (Property childProperty : property.getObject()) {
            this.parsePropertyFilters(childProperty, entities);
        }
    }

    private void onEntityUpdate(long subject) {
        this.fingerprintTracker.updateEntity(subject);
    }

    @Override
    public final long getFingerprint() {
        return this.fingerprintTracker.getFingerprint();
    }

    private TypeAndPropertyKeeper createTypeAndPropertyKeeper(Options options, Entities entitiesForCreation, ImmutableList<Property> properties) {
        List<String> typeUris = options.getValueOr(ExternalSyncPlugin.TYPES, Collections.emptyList());
        long[] types = typeUris.isEmpty() && options.getValue(ExternalSyncPlugin.DETECT_FIELDS) != false ? new long[]{-2147483647L} : (typeUris.size() == 1 && "$any".equals(typeUris.get(0)) ? new long[]{-2147483647L} : (typeUris.size() == 1 && "$untyped".equals(typeUris.get(0)) ? new long[]{-2147483646L} : OptionsUtil.resolveAllEntities(typeUris, entitiesForCreation)));
        return new TypeAndPropertyKeeper(types, this.rdfTypeId, properties);
    }

    private static void throwExceptionIfOptionExists(Map map, String key) {
        if (map.containsKey(key)) {
            throw new ConnectorUserException("The option '" + key + "' has been removed. Please consult the documentation.");
        }
    }

    @VisibleForTesting
    static Value parseDefaultValue(String strValue) {
        IRI value = null;
        if (strValue.startsWith("\"")) {
            int nextQuote;
            int from = 1;
            while ((nextQuote = strValue.indexOf(34, from)) >= 0) {
                if (strValue.charAt(nextQuote - 1) != '\\') {
                    String literal = strValue.substring(1, nextQuote);
                    String rest = strValue.substring(nextQuote + 1);
                    if (rest.startsWith("^^") && rest.length() > 2) {
                        IRI datatype = null;
                        if (rest.charAt(2) == '<' && rest.endsWith(">")) {
                            datatype = valueFactory.createIRI(rest.substring(3, rest.length() - 1));
                        } else if (rest.startsWith("^^xsd:") && rest.length() > 6) {
                            datatype = valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#" + rest.substring("^^xsd:".length()));
                        }
                        if (datatype != null) {
                            value = valueFactory.createLiteral(literal, datatype);
                        }
                    } else if (rest.startsWith("@")) {
                        String language = rest.substring(1);
                        if (LANGUAGE_PATTERN.matcher(language).matches()) {
                            value = valueFactory.createLiteral(literal, language);
                        }
                    } else if (rest.isEmpty()) {
                        value = valueFactory.createLiteral(literal);
                    }
                }
                if (value == null) {
                    ++from;
                    continue;
                }
                break;
            }
        } else if (strValue.startsWith("<") && strValue.endsWith(">")) {
            try {
                value = valueFactory.createIRI(strValue.substring(1, strValue.length() - 1));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectorUserException("Invalid URI for default value.", e);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Property getPropertyFromElement(Object o, Entities entities, @Nullable Property parentProperty) {
        String datatype;
        String filter;
        if (!(o instanceof Map)) throw new ClientErrorException("Invalid json for property parameter");
        Map propMap = (Map)o;
        if (!propMap.containsKey("propertyChain") || !propMap.containsKey("fieldName")) throw new ClientErrorException("Invalid json for property parameter! ");
        AbstractExternalStore.throwExceptionIfOptionExists(propMap, "index");
        AbstractExternalStore.throwExceptionIfOptionExists(propMap, "sort");
        AbstractExternalStore.throwExceptionIfOptionExists(propMap, "syncAsIs");
        AbstractExternalStore.throwExceptionIfOptionExists(propMap, "manageExternalSchema");
        String fieldNameTransformString = (String)propMap.get("fieldNameTransform");
        FieldNameTransform fieldNameTransform = FieldNameTransform.NONE_TRANSFORM;
        if (fieldNameTransformString != null) {
            fieldNameTransform = FieldNameTransform.lookupTransform(fieldNameTransformString);
            assert (fieldNameTransform != null);
        }
        List chain = (List)propMap.get("propertyChain");
        Property p = Property.createProperty(AbstractExternalStore.processName((String)propMap.get("fieldName")), fieldNameTransform, chain, entities, parentProperty, this.multifieldSuffix);
        if (propMap.containsKey("indexed")) {
            p.setIndexed((Boolean)propMap.get("indexed"));
        }
        if (propMap.containsKey("stored")) {
            p.setStored((Boolean)propMap.get("stored"));
        }
        if (propMap.containsKey("analyzed")) {
            p.setAnalyzed((Boolean)propMap.get("analyzed"));
        }
        if (propMap.containsKey("multivalued")) {
            p.setMultivalued((Boolean)propMap.get("multivalued"));
        }
        if (propMap.containsKey("ignoreInvalidValues")) {
            p.setIgnoreInvalidValues((Boolean)propMap.get("ignoreInvalidValues"));
        }
        if (propMap.containsKey("facet")) {
            p.setFacet((Boolean)propMap.get("facet"));
        }
        if (propMap.containsKey("fielddata")) {
            p.setFielddata((Boolean)propMap.get("fielddata"));
        }
        if (propMap.containsKey("array")) {
            p.setArray((Boolean)propMap.get("array"));
        }
        if (propMap.containsKey("analyzer")) {
            p.setAnalyzer((String)propMap.get("analyzer"));
        }
        if (propMap.containsKey("objectFields")) {
            if (p.getFieldNameTransform().isPredicateNeeded()) {
                throw new ConnectorUserException("Nested fields may only use the identity() field name transformation");
            }
            for (Object obj : (List)propMap.get("objectFields")) {
                Property objProperty = this.getPropertyFromElement(obj, entities, p);
                p.addObjectProperty(objProperty);
            }
        }
        if (propMap.containsKey("valueFilter")) {
            filter = (String)propMap.get("valueFilter");
            p.setValueFilterString(filter);
        }
        if (propMap.containsKey("documentFilter")) {
            if (p.getObject().isEmpty()) {
                throw new ConnectorUserException("Only nested fields may define a document filter");
            }
            filter = (String)propMap.get("documentFilter");
            p.setDocumentFilterString(filter);
        }
        if (propMap.containsKey("startFromParent")) {
            if (parentProperty == null) {
                throw new ConnectorUserException("'startFromParent' can be used only within a nested document");
            }
            Long parentCount = (Long)propMap.get("startFromParent");
            if (parentCount == null || parentCount < 0L) {
                throw new ConnectorUserException("'startFromParent' must be a non-negative number");
            }
            Property localParentProperty = parentProperty;
            int i = 0;
            while ((long)i < parentCount - 1L) {
                if ((localParentProperty = localParentProperty.getParentProperty()) == null) {
                    throw new ConnectorUserException("'startFromParent' refers to a non-existent parent");
                }
                ++i;
            }
            p.setObjectStartFromParent(parentCount);
        }
        p.setNativeSettings(OptionsUtil.parseJson(propMap.get("nativeSettings"), Collections.emptyMap()));
        if (propMap.containsKey("defaultValue")) {
            Value value = AbstractExternalStore.parseDefaultValue(((String)propMap.get("defaultValue")).trim());
            if (value == null) {
                throw new ClientErrorException("Default value must be a literal (\"\" enclosed with an optional datatype or language) or a URI (<> enclosed).");
            }
            long defaultValue = entities.put(value, Entities.Scope.DEFAULT);
            p.setDefaultValue(defaultValue);
        }
        if ((datatype = (String)propMap.get("datatype")) == null || datatype.trim().isEmpty()) return p;
        try {
            IRI datatypeUri = datatype.startsWith("xsd:") ? valueFactory.createIRI("http://www.w3.org/2001/XMLSchema#" + datatype.substring("xsd:".length())) : valueFactory.createIRI((String)("vector".equals(datatype) ? NATIVE_PREFIX + datatype : datatype));
            String nativeType = this.getNativeTypeFromDatatype(datatypeUri, p.isMultivalued());
            if (nativeType == null) {
                throw new ClientErrorException("Datatype URI is not supported: " + datatype);
            }
            if (datatypeUri.getNamespace().equals("http://www.w3.org/2001/XMLSchema#")) {
                p.setXsdType(datatypeUri);
            }
            p.setNativeType(nativeType);
            return p;
        }
        catch (IllegalArgumentException e) {
            throw new ClientErrorException("Invalid datatype URI: " + datatype);
        }
    }

    private static String processName(String item) {
        if (item.indexOf(94) > 0) {
            return item.substring(0, item.indexOf(94));
        }
        return item;
    }

    @Override
    public TypeAndPropertyKeeper getTypeAndPropertyKeeper() {
        return this.typePropertyKeeper;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void close() throws IOException {
        try {
            this.closeInternalResources();
        }
        finally {
            this.closeNetworkResources();
        }
    }

    private void closeInternalResources() {
        try {
            if (this.dependeesIndex != null) {
                this.dependeesIndex.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[{}] Error closing chains index.", (Object)this.name, (Object)e);
        }
    }

    protected void closeNetworkResources() {
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void drop(boolean force) throws Exception {
        block6: {
            block5: {
                try {
                    if (this.dependeesIndex != null) {
                        this.dependeesIndex.drop();
                        this.dependeesIndex = null;
                    }
                }
                catch (Exception e) {
                    if (force) break block5;
                    throw e;
                }
            }
            try {
                File storeDir = new File(this.plugin.getDataDir(), this.name);
                FileUtils.deleteDirectory((File)storeDir);
            }
            catch (Exception e) {
                if (force) break block6;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void syncAllEntities(PluginConnection pluginConnection, Entities entities, Statements statements, boolean repair) {
        this.init();
        if (!repair) {
            this.plugin.setCurrentlyBeingBuilt(this.name, this);
        }
        this.status.status = ExternalStoreStatus.Status.BUILDING;
        this.status.buildBeginTime = System.currentTimeMillis();
        this.status.repair = repair;
        boolean skipInitialIndexing = this.options.getValueWithDefault(ExternalSyncPlugin.SKIP_INITIAL_INDEXING);
        String operation = repair ? (skipInitialIndexing ? "Repair (with skip)" : "Repair") : (skipInitialIndexing ? "Initial (with skip)" : "Initial");
        try {
            ClassLoaderUtil.executeWithPluginClassLoader(((Object)((Object)this.plugin)).getClass().getClassLoader(), () -> {
                long[] types = this.typePropertyKeeper.getTypes();
                if (types[0] > 0L) {
                    StatementIterator sit;
                    long type2;
                    for (long type2 : this.typePropertyKeeper.getTypes()) {
                        this.status.estimatedEntities += statements.estimateSize(0L, this.rdfTypeId, type2, 0L);
                        this.logger.debug("[{}] Estimated number of entities {} after type {}", new Object[]{this.name, this.status.estimatedEntities, type2});
                    }
                    this.logger.info("[{}] {} indexing for {} (estimated) entities.", new Object[]{this.name, operation, this.status.estimatedEntities});
                    long[] lArray = this.typePropertyKeeper.getTypes();
                    int n = lArray.length;
                    for (int i = 0; i < n && this.syncAllEntitiesFromIterator(sit = statements.get(0L, this.rdfTypeId, type2 = lArray[i]), entities, statements, skipInitialIndexing); ++i) {
                    }
                } else {
                    StatementIterator sit;
                    if (types[0] == -2147483647L) {
                        this.status.estimatedEntities += statements.estimateSize(0L, this.rdfTypeId, 0L, 0L);
                    } else if (types[0] == -2147483646L) {
                        this.status.estimatedEntities += statements.uniqueSubjects(0L);
                    }
                    this.logger.info("[{}] {} indexing for {} (estimated) entities.", new Object[]{this.name, operation, this.status.estimatedEntities});
                    if (types[0] == -2147483647L) {
                        sit = this.getUniqueSubjects(statements, this.rdfTypeId);
                    } else if (types[0] == -2147483646L) {
                        sit = this.getUniqueSubjects(statements, 0L);
                    } else {
                        throw new IllegalStateException("Unexpected type ID: " + types[0]);
                    }
                    this.syncAllEntitiesFromIterator(sit, entities, statements, skipInitialIndexing);
                }
                if (!this.errorInAnotherThread) {
                    if (!repair) {
                        this.transactionCompleted(pluginConnection);
                    }
                    this.logger.info("[{}] {} indexing done, {} entities.", new Object[]{this.name, operation, this.status.processedEntities});
                }
            });
        }
        finally {
            this.plugin.resetCurrentlyBeingBuilt(this.name);
            this.status.status = ExternalStoreStatus.Status.BUILT;
            this.status.estimatedEntities = 0L;
            this.status.processedEntities = 0L;
            this.status.buildBeginTime = 0L;
            this.status.repair = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncAllEntitiesFromIterator(StatementIterator sit, Entities entities, Statements statements, boolean skip) {
        try {
            while (sit.next()) {
                if (this.status.processedEntities % 1000L == 0L && this.errorInAnotherThread) {
                    this.logger.info("[{}] Giving up on indexing because of error in another thread.", (Object)this.name);
                    boolean bl = false;
                    return bl;
                }
                if (this.syncEntityIfItMatches(sit.subject, entities, statements, skip)) {
                    ++this.status.indexedEntities;
                }
                ++this.status.processedEntities;
            }
        }
        finally {
            sit.close();
        }
        return true;
    }

    protected boolean syncEntityIfItMatches(long subject, Entities entities, Statements statements, boolean skip) {
        List<Property> propertiesToSync;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Check indexing {}: {}", new Object[]{this.name, subject, this.getValueForLog(entities, subject)});
        }
        if ((propertiesToSync = this.typePropertyKeeper.getEntityPropertyToIndex(subject, statements)) != null) {
            if (this.logger.isDebugEnabled()) {
                Value value = entities.get(subject);
                this.logger.debug("[{}] Indexing document with subject {}", (Object)this.name, (Object)value);
            }
            return this.syncEntity(subject, this.defaultDocumentPredicateId, this.defaultDocumentContextId, this.newSyncDocument(propertiesToSync.size(), subject, entities, statements), propertiesToSync, entities, statements, skip);
        }
        return false;
    }

    protected boolean refreshEntity(long subject, Entities entities, Statements statements) {
        Value value = entities.get(subject);
        this.onEntityUpdate(subject);
        boolean synced = this.syncEntityIfItMatches(subject, entities, statements, false);
        if (!synced && this.isEntityIndexed(subject)) {
            this.deleteEntity(subject, value);
        }
        return synced;
    }

    protected abstract void deleteEntity(long var1, Value var3);

    protected abstract boolean syncEntity(long var1, long var3, long var5, SyncDocument<T> var7, List<Property> var8, Entities var9, Statements var10, boolean var11);

    protected boolean isEntityIndexed(long subject) {
        return true;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public long[] getExtraPropertiesToListenFor() {
        return ArrayUtils.EMPTY_LONG_ARRAY;
    }

    @Override
    public CloseableIterator<Long> getEntitiesForChangeUpdate(long subject, long property, @Nullable TLongHashSet removedTypes, Entities entities, Statements statements) {
        this.init();
        if (this.shouldProcessChainUpdate(subject, property, removedTypes, entities, statements)) {
            return this.getIteratorForDirectChainLevel(subject);
        }
        return this.getIteratorForPreviousChainLevel(subject, removedTypes, entities, statements);
    }

    private boolean checkAndLogChangeUpdate(long type, long property, Entities entities) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Do we track property {} <{}> for type {} <{}>", new Object[]{this.name, property, this.getValueForLog(entities, property), type, this.getValueForLog(entities, type)});
        }
        if (this.typePropertyKeeper.isTypeAndPropertyInAnyChain(type, property)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] Update because of chain change: {} <{}> for type {} <{}>", new Object[]{this.name, property, this.getValueForLog(entities, property), type, this.getValueForLog(entities, type)});
            }
            this.logger.debug("[{}] We do track it.", (Object)this.name);
            return true;
        }
        this.logger.debug("[{}] We do NOT track it.", (Object)this.name);
        return false;
    }

    private boolean shouldProcessChainUpdate(long subject, long property, @Nullable TLongHashSet removedTypes, Entities entities, Statements statements) {
        StatementIterator sit;
        boolean hasNext;
        boolean result = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Checking direct chain for subject {} <{}> on property {} <{}>", new Object[]{this.name, subject, this.getValueForLog(entities, subject), property, this.getValueForLog(entities, property)});
        }
        if (hasNext = (sit = this.getTypesForSubject(subject, statements)).next()) {
            while (!result && hasNext) {
                result = this.checkAndLogChangeUpdate(sit.object, property, entities);
                hasNext = sit.next();
            }
        } else {
            result = this.checkAndLogChangeUpdate(this.rdfsResourceId, property, entities);
        }
        sit.close();
        if (removedTypes != null) {
            TLongIterator itty = removedTypes.iterator();
            while (!result && itty.hasNext()) {
                result = this.checkAndLogChangeUpdate(itty.next(), property, entities);
            }
        }
        return result;
    }

    private TLongLongHashMap getPreviousChainLevelTriggers(long subject, @Nullable TLongHashSet removedTypes, Entities entities, Statements statements) {
        TLongLongHashMap subjectPredicatePairs = new TLongLongHashMap();
        StatementIterator sit = statements.get(0L, 0L, subject);
        while (sit.next()) {
            if (!this.shouldProcessChainUpdate(sit.subject, sit.predicate, removedTypes, entities, statements)) continue;
            subjectPredicatePairs.put(sit.subject, sit.predicate);
        }
        sit.close();
        return subjectPredicatePairs;
    }

    private CloseableIterator<Long> getIteratorForPreviousChainLevel(long subject, @Nullable TLongHashSet removedTypes, Entities entities, Statements statements) {
        TLongLongHashMap result = this.getPreviousChainLevelTriggers(subject, removedTypes, entities, statements);
        if (!result.isEmpty()) {
            final TLongLongIterator itemItty = result.iterator();
            return new CloseableIterator<Long>(){
                long currentSubject;
                long currentPredicate;
                CloseableIterator<Long> currentDirectItty;

                @Override
                public boolean hasNext() {
                    if (this.currentDirectItty != null && this.currentDirectItty.hasNext()) {
                        return true;
                    }
                    while (itemItty.hasNext()) {
                        itemItty.advance();
                        this.currentSubject = itemItty.key();
                        this.currentPredicate = itemItty.value();
                        this.currentDirectItty = AbstractExternalStore.this.getIteratorForDirectChainLevel(this.currentSubject);
                        if (!this.currentDirectItty.hasNext()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public Long next() {
                    return (Long)this.currentDirectItty.next();
                }

                @Override
                public void remove() {
                    throw new NotImplementedException();
                }

                @Override
                public void close() throws Exception {
                    this.currentDirectItty.close();
                }
            };
        }
        return CloseableIterator.EMPTY_ITERATOR;
    }

    protected final CloseableIterator<Long> getIteratorForDirectChainLevel(long subject) {
        return this.readonly ? CloseableIterator.EMPTY_ITERATOR : this.dependeesIndex.find(subject);
    }

    private StatementIterator getTypesForSubject(long subject, Statements statements) {
        return statements.get(subject, this.rdfTypeId, 0L);
    }

    @Override
    public JSONObject getSettingsAsJSON() {
        JSONObject settings = this.typePropertyKeeper.getSettingsAsJSON();
        JSONArray fields = new JSONArray();
        fields.addAll(this.fieldsThatAreURIs);
        settings.put((Object)"fieldsThatAreURIs", (Object)fields);
        return settings;
    }

    @Override
    public void setSettingsFromJSON(JSONObject json) {
        this.typePropertyKeeper.setSettingsFromJSON(json);
        Object o = json.get((Object)"fieldsThatAreURIs");
        if (o instanceof JSONArray) {
            this.fieldsThatAreURIs = new HashSet<String>((Collection<String>)((JSONArray)o));
        }
    }

    @Override
    public boolean settingsHaveChanged() {
        return this.dynamicOptionsUpdated;
    }

    @Override
    public void markEntityForRefresh(long subject) {
        if (!this.readonly) {
            this.entitiesToRefresh.add(subject);
        }
    }

    @Override
    public final boolean refreshMarkedEntities(PluginConnection pluginConnection) {
        Entities entities = pluginConnection.getEntities();
        Statements statements = pluginConnection.getStatements();
        this.logger.info("[{}] About to refresh {} entities.", (Object)this.name, (Object)this.entitiesToRefresh.size());
        Iterator<Long> itty = this.entitiesToRefresh.iterator();
        if (itty.hasNext()) {
            this.plugin.checkRequiredCapabilities(pluginConnection);
            this.init();
        }
        long numIndexed = 0L;
        while (itty.hasNext()) {
            if (numIndexed % 1000L == 0L && this.errorInAnotherThread) {
                this.logger.info("[{}] Giving up on indexing because of error in another thread.", (Object)this.name);
                break;
            }
            long subject = itty.next();
            this.refreshEntity(subject, entities, statements);
            ++numIndexed;
        }
        boolean result = !this.entitiesToRefresh.isEmpty();
        this.entitiesToRefresh = null;
        return result;
    }

    @Override
    public void notifyErrorInAnotherThread() {
        this.errorInAnotherThread = true;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void transactionStarted(PluginConnection pluginConnection) {
        this.entitiesToRefresh = new TreeSet();
        this.errorInAnotherThread = false;
        this.dynamicOptionsUpdated = false;
        this.transaction = pluginConnection.getTransactionId();
        this.isTestingTransaction = pluginConnection.isTesting();
        this.fingerprintTracker.transactionStarted(this.transaction);
    }

    @Override
    public long getTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isTestingTransaction() {
        return this.isTestingTransaction;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean transactionCompleted(PluginConnection pluginConnection) {
        this.commitDependeesIndex();
        try {
            this.fingerprintTracker.transactionCompleted(pluginConnection.getTransactionId());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to commit transaction " + pluginConnection.getTransactionId(), e);
        }
        this.wasJustCreated = false;
        return true;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void rollbackCurrent(PluginConnection pluginConnection) throws IOException {
        this.fingerprintTracker.rollback();
        this.rollbackDependeesIndex();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void rollbackLastCommitted(PluginConnection pluginConnection) throws IOException {
        this.fingerprintTracker.rollbackCommitted();
    }

    @Override
    public void notifyTypeChanges(TLongObjectHashMap<TLongHashSet> typeMap) {
        this.dynamicOptionsUpdated |= this.typePropertyKeeper.addChainTypes(typeMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean syncPropertyChain(SyncDocument<T> doc, Property property, int pos, long currentSubject, long previousPredicate, long previousContext, Entities entities, Statements statements) {
        boolean isLastInChain;
        boolean syncedAny = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Field {}, element {}, predicate {}", new Object[]{this.name, property, pos, this.getValueForLog(entities, property.owlimIds[pos])});
        }
        if (property.owlimIds[pos] != 0L) {
            if (pos > 0) {
                this.syncToDependeeIndex(doc, currentSubject, property.owlimIds[pos], property.nextHopIdsAtPosition[pos - 1], entities, statements);
            } else if (doc.isNested()) {
                this.syncToDependeeIndex(doc, currentSubject, property.owlimIds[pos], new long[0], entities, statements);
            }
        }
        boolean bl = isLastInChain = pos + 1 == property.owlimIds.length;
        SingletonStatementIterator wrappedItty = isLastInChain && (property.isSelf() || property.isLang() || property.isGraph() || property.isLocalName()) ? new SingletonStatementIterator(currentSubject, previousPredicate, currentSubject, previousContext) : (property.isLiteralAt(pos) ? statements.get(currentSubject, 0L, 0L, 0L) : (!property.inverseIri[pos] ? statements.get(currentSubject, property.owlimIds[pos], 0L, 0L) : statements.get(0L, property.owlimIds[pos], currentSubject, 0L)));
        try (ImplicitFilteringStatementIterator sit = new ImplicitFilteringStatementIterator(this.implicitGraphId, wrappedItty);){
            while (sit.next()) {
                long syncValue;
                long l = syncValue = property.inverseIri[pos] ? sit.subject : sit.object;
                if (property.isLiteralAt(pos) && entities.getType(sit.object) != Entities.Type.LITERAL) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}]    has value {}: {}", new Object[]{this.name, syncValue, this.getValueForLog(entities, syncValue)});
                }
                boolean propertyHasFilterAtThisPosition = property.hasFilterAtPosition(pos);
                boolean passedFilter = true;
                if (isLastInChain) {
                    boolean isLiteral;
                    boolean doSync = true;
                    if (property.isGraph()) {
                        syncValue = sit.context;
                        this.logger.debug("[{}]    \treplaced value with graph() {}: {}", new Object[]{this.name, syncValue, this.getValueForLog(entities, syncValue)});
                    }
                    boolean bl2 = isLiteral = entities.getType(syncValue) == Entities.Type.LITERAL;
                    if (property.isLang()) {
                        if (!isLiteral) {
                            doSync = false;
                        }
                    } else if (isLiteral) {
                        doSync = this.languageMatcher.languageTagMatches(entities.getLanguage(syncValue));
                    } else {
                        this.syncToDependeeIndex(doc, syncValue, 0L, property.nextHopIdsAtPosition[pos], entities, statements);
                    }
                    if (!doSync) continue;
                    if (propertyHasFilterAtThisPosition) {
                        passedFilter = this.evaluateValueFilter(property, pos, syncValue, sit.context, doc);
                    }
                    if (passedFilter) {
                        this.syncPropertyValue(doc, property, sit.predicate, syncValue, sit.context, 0, entities, statements);
                        this.logger.debug("[{}]      Last in chain, value will be included in document.", (Object)this.name);
                        syncedAny = true;
                        continue;
                    }
                    this.logger.debug("[{}]      Last in chain, value did not pass filter and will not be included in document.", (Object)this.name);
                    continue;
                }
                if (propertyHasFilterAtThisPosition) {
                    passedFilter = this.evaluateValueFilter(property, pos, syncValue, sit.context, doc);
                }
                if (passedFilter) {
                    if (propertyHasFilterAtThisPosition) {
                        this.syncPropertyValue(doc, property, sit.predicate, syncValue, sit.context, property.owlimIds.length - pos - 1, entities, statements);
                    }
                    syncedAny |= this.syncPropertyChain(doc, property, pos + 1, syncValue, sit.predicate, sit.context, entities, statements);
                    continue;
                }
                this.logger.debug("[{}]      Value did not pass filter. Stop processing chain.", (Object)this.name);
                this.syncToDependeeIndex(doc, syncValue, 0L, property.nextHopIdsAtPosition[pos], entities, statements);
            }
        }
        return syncedAny;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncToDependeeIndex(SyncDocument<T> doc, long dependeeSubject, long dependeePredicate, long[] dependeePredicates, Entities entities, Statements statements) {
        if (dependeePredicate == 0L && dependeePredicates.length == 0) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]    adding to dependee index: {} <{}>", new Object[]{this.name, dependeeSubject, this.getValueForLog(entities, dependeeSubject)});
        }
        this.syncDependee(doc, dependeeSubject);
        boolean atLeastOneTypeAdded = false;
        try (StatementIterator sitType = statements.get(dependeeSubject, this.rdfTypeId, 0L);){
            while (sitType.next()) {
                if (sitType.object == this.rdfsResourceId) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logDependeeTracking(sitType.object, dependeePredicate, dependeePredicates, entities);
                }
                this.dynamicOptionsUpdated |= this.typePropertyKeeper.addDependeeTypeAndProperty(sitType.object, dependeePredicate, dependeePredicates);
                atLeastOneTypeAdded = true;
            }
        }
        if (!atLeastOneTypeAdded) {
            if (this.logger.isDebugEnabled()) {
                this.logDependeeTracking(this.rdfsResourceId, dependeePredicate, dependeePredicates, entities);
            }
            this.dynamicOptionsUpdated |= this.typePropertyKeeper.addDependeeTypeAndProperty(this.rdfsResourceId, dependeePredicate, dependeePredicates);
        }
    }

    private void logDependeeTracking(long type, long dependeePredicate, long[] dependeePredicates, Entities entities) {
        if (dependeePredicate != 0L) {
            this.logger.debug("[{}]        tracking dependee predicate changes for X of type {} <{}>, where X's predicate is {} <{}>", new Object[]{this.name, type, this.getValueForLog(entities, type), dependeePredicate, this.getValueForLog(entities, dependeePredicate)});
        }
        for (long nextHopId : dependeePredicates) {
            this.logger.debug("[{}]        tracking dependee predicate changes for X of type {} <{}>, where X's predicate is {} <{}>", new Object[]{this.name, type, this.getValueForLog(entities, type), nextHopId, this.getValueForLog(entities, nextHopId)});
        }
    }

    protected boolean syncEntityToDocument(SyncDocument<T> doc, long subject, long predicate, long context, List<Property> properties, Entities entities, Statements statements) {
        Property thisProperty;
        boolean hasSyncedAnyProperty = false;
        Property property = thisProperty = doc.isNested() ? null : this.typePropertyKeeper.getThisProperty();
        if (thisProperty == null || this.syncPropertyChain(doc, thisProperty, 0, subject, predicate, context, entities, statements)) {
            for (Property property2 : properties) {
                long defaultValue;
                if (property2.isReferenceTo()) continue;
                if (doc.isNested()) {
                    SyncDocument<T> startDoc = doc.getNthParentDocument(property2.getObjectStartFromParent());
                    subject = startDoc.getDocumentId();
                }
                boolean propertyHasSynced = this.syncPropertyChain(doc, property2, 0, subject, predicate, context, entities, statements);
                hasSyncedAnyProperty |= propertyHasSynced;
                if (propertyHasSynced || (defaultValue = property2.getDefaultValue()) == 0L) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}]    field had no values to sync but it has a default value {}: {}", new Object[]{this.name, defaultValue, this.getValueForLog(entities, defaultValue)});
                }
                this.syncPropertyValue(doc, property2, this.defaultValuePredicateId, defaultValue, this.defaultValueContextId, 0, entities, statements);
                hasSyncedAnyProperty = true;
            }
        }
        if (hasSyncedAnyProperty) {
            boolean hasPassedFilter = doc.passesDocumentFilter();
            if (!hasPassedFilter) {
                this.logger.debug("[{}] Document will not sync because it did not pass filter.", (Object)this.name);
            } else {
                this.logger.debug("[{}] Document will sync.", (Object)this.name);
            }
            hasSyncedAnyProperty = hasPassedFilter;
        } else {
            this.logger.debug("[{}] Document will not sync because it did not include any values.", (Object)this.name);
        }
        if (!doc.isNested()) {
            this.setDependees(subject, doc.dependees);
        }
        return hasSyncedAnyProperty;
    }

    protected void syncPropertyValue(SyncDocument<T> doc, Property property, long predicate, long value, long context, int level, Entities entities, Statements statements) {
        if (level == 0) {
            List<Property> nestedObject = property.getObject();
            if (nestedObject.isEmpty()) {
                doc.addValue(property.getFieldName(), predicate, value, context, level);
                for (Property referredFrom : property.getReferredFromProperties()) {
                    doc.addValue(referredFrom.getFieldName(), predicate, value, context, level);
                }
                if (entities.getType(value) == Entities.Type.URI && !this.fieldsThatAreURIs.contains(property.getFieldNameWithoutSuffix())) {
                    this.dynamicOptionsUpdated |= this.fieldsThatAreURIs.addAll(property.getAllFieldNames());
                }
            } else {
                SyncDocument<T> nestedDoc = doc.createdNested(nestedObject.size(), value, context, this.newNativeDocument(), property.getDocumentFilterExpr());
                if (this.syncEntityToDocument(nestedDoc, value, predicate, context, nestedObject, entities, statements)) {
                    doc.addNested(property.getFieldName(), nestedDoc);
                    for (Property referredFrom : property.getReferredFromProperties()) {
                        doc.addNested(referredFrom.getFieldName(), nestedDoc);
                    }
                }
            }
        } else {
            doc.addValue(property.getFieldName(), predicate, value, context, level);
        }
    }

    protected void syncDependee(SyncDocument<T> doc, long chainSubject) {
        doc.dependees.add(chainSubject);
    }

    protected abstract boolean isValidFieldNameImplementation(String var1, boolean var2);

    protected final boolean isValidFieldName(String fieldName, boolean isTopField) {
        return !fieldName.startsWith("_") && !fieldName.startsWith("-") && !fieldName.contains(",") && !fieldName.contains(this.multifieldSuffix) && this.isValidFieldNameImplementation(fieldName, isTopField);
    }

    private boolean isValidFieldNameSuffix(String fieldNameSuffix) {
        return true;
    }

    protected boolean convertSyncDocumentToNativeDocument(SyncDocument<T> doc, List<Property> propertiesToSync) {
        boolean anyProperty = false;
        for (Property property : propertiesToSync) {
            TLongArrayList values = doc.getValues(property.getFieldNameWithSuffix(), false);
            for (int i = 0; i < values.size(); ++i) {
                long value = values.getQuick(i);
                if (value == 0L) continue;
                String fieldName = doc.getFieldName(property, values, i);
                if (property.getFieldNameTransform() == FieldNameTransform.NONE_TRANSFORM || this.isValidFieldName(fieldName, !doc.isNested())) {
                    Value valueObject;
                    if (property.isLang()) {
                        valueObject = doc.resolveIdToLanguage(value);
                    } else if (property.isLocalName()) {
                        valueObject = doc.resolveId(value);
                        if (valueObject instanceof IRI) {
                            valueObject = valueFactory.createLiteral(((IRI)valueObject).getLocalName());
                        }
                    } else {
                        valueObject = doc.resolveId(value);
                    }
                    anyProperty |= this.writePropertyValueToNativeDocument(doc.nativeDocument, property, fieldName, valueObject);
                    continue;
                }
                this.logger.warn("[{}] Skipping field name created from transformation as the resultant name is disallowed: {} -> {}", new Object[]{this.name, property.getFieldNameWithoutSuffix(), fieldName});
            }
            List<SyncDocument<T>> nestedDocs = doc.getNestedValues(property.getFieldNameWithSuffix());
            for (SyncDocument<T> nestedDoc : nestedDocs) {
                List<Property> nestedProps = property.getObject();
                anyProperty |= this.convertSyncDocumentToNativeDocument(nestedDoc, nestedProps);
                this.addNativeNestedDocument(doc.nativeDocument, property, nestedDoc.nativeDocument);
            }
        }
        return anyProperty;
    }

    protected abstract boolean writePropertyValueToNativeDocument(T var1, Property var2, String var3, Value var4);

    protected void addNativeNestedDocument(T doc, Property property, T nestedDoc) {
    }

    protected abstract T newNativeDocument();

    @Override
    public boolean isFieldURI(String fieldName) {
        return this.fieldsThatAreURIs.contains(fieldName);
    }

    protected abstract String getNativeTypeFromDatatype(IRI var1, boolean var2);

    @Override
    @OverridingMethodsMustInvokeSuper
    public void removeAllEntities() {
        this.removeAllDependeesIndex();
    }

    @Override
    public TreeSet<Long> getEntitiesToRefresh() {
        return this.entitiesToRefresh;
    }

    @Override
    public void remove(boolean force) throws Exception {
        Exception exception = null;
        try {
            this.drop(force);
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception == null || force) {
            try {
                this.closeInternalResources();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                }
                this.logger.warn("[{}] Error on closeInternalResources() after drop() but drop() already threw an exception.", (Object)this.name);
            }
            try {
                this.closeNetworkResources();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                }
                this.logger.warn("[{}] Error on closeNetworkResources() after drop()/closeInternalResources() but drop()/closeInternalResources() already threw an exception.", (Object)this.name);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void validateProperties() {
    }

    @Override
    public ValueFactory getValueFactory() {
        return valueFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init() {
        if (!this.initialised.get()) {
            AbstractExternalStore abstractExternalStore = this;
            synchronized (abstractExternalStore) {
                if (this.initialised.get()) {
                    return;
                }
                this.checkVersionCompatibility(this.options.getVersion());
                ClassLoaderUtil.executeWithPluginClassLoader(((Object)((Object)this.plugin)).getClass().getClassLoader(), this::initImpl);
                this.initDependeesIndex();
                this.initialised.set(true);
            }
        }
    }

    private Pair<Integer, Integer> parseVersion(@Nullable String version) {
        int major = 1;
        int minor = 0;
        if (version != null) {
            String[] versionParts = version.split("\\.");
            major = Integer.parseInt(versionParts[0]);
            minor = Integer.parseInt(versionParts[1]);
        }
        return Pair.of((Object)major, (Object)minor);
    }

    private int parseMajorVersion(@Nullable String version) {
        return (Integer)this.parseVersion(version).getLeft();
    }

    private void checkVersionCompatibility(@Nullable String version) {
        Pair<Integer, Integer> parsedVersion = this.parseVersion(version);
        if ((Integer)parsedVersion.getLeft() != 3) {
            throw new ConnectorServerException(String.format("%s connector instance %s was created by a previous GraphDB version and is incompatible with this version. Please consult the documentation and recreate the instance.", this.plugin.getShortName(), this.name));
        }
        if ((Integer)parsedVersion.getRight() != 0) {
            this.logger.warn("{} connector instance {} was created by a previous GraphDB version and may function suboptimally. Repairing the instance is recommended.", (Object)this.plugin.getShortName(), (Object)this.name);
        }
    }

    private boolean evaluateValueFilter(Property property, int pos, long syncValue, long syncContext, SyncDocument<T> doc) {
        return property.getValueFilterExpr().evaluatePartial(property.owlimIds.length - pos - 1, syncValue, syncContext, doc, true);
    }

    protected abstract void initImpl();

    @Override
    public ExternalStoreStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean wasJustCreated() {
        return this.wasJustCreated;
    }

    public final HealthResult runHealthCheck() {
        try {
            this.init();
        }
        catch (Exception e) {
            return new HealthResult(this.getName(), HealthResult.Status.RED, "cannot initialise instance: " + e.getMessage());
        }
        return this.runHealthCheckInternal();
    }

    public abstract HealthResult runHealthCheckInternal();

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    protected final void setDependees(long subject, Set<Long> dependees) {
        if (!this.readonly) {
            this.dependeesIndex.set(subject, dependees);
        }
    }

    private void commitDependeesIndex() {
        if (!this.readonly && this.dependeesIndex != null) {
            this.dependeesIndex.commit();
        }
    }

    private void rollbackDependeesIndex() {
        if (!this.readonly && this.dependeesIndex != null) {
            this.dependeesIndex.rollback();
        }
    }

    private void removeAllDependeesIndex() {
        if (!this.readonly) {
            this.dependeesIndex.removeAll();
        }
    }

    private void initDependeesIndex() {
        if (!this.readonly && this.dependeesIndex == null) {
            this.dependeesIndex = new LongLongIndexModifiablePairCollection(this.name, this.plugin.getDataDir().toPath(), this.plugin.getEntityIdSize());
        }
    }

    protected abstract void createIndex(boolean var1);

    @Override
    public final void recreateIndex(Options options) {
        try {
            this.remove(true);
            this.initialised.set(false);
            this.options = options;
            this.createIndex(false);
        }
        catch (Exception e) {
            if (e instanceof ConnectorException) {
                throw (RuntimeException)e;
            }
            throw new ConnectorServerException("Unable to create connector: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateOptions(Options newOptions) {
        this.options.updateOptions(newOptions, this.plugin.getAllOptions());
        this.applyUpdatedOptions();
    }

    protected abstract void applyUpdatedOptions();

    protected SyncDocument<T> newSyncDocument(int size, long id, @Nonnull Entities entities, Statements statements) {
        return new SyncDocument<T>(size, id, this.defaultDocumentContextId, this.newNativeDocument(), this.filtersUseGraph, this.typePropertyKeeper.hasPredicateTransform(), entities, statements, this.documentFilterExpr, new HashSet<Long>());
    }

    private String getValueForLog(Entities entities, long id) {
        if (id == Integer.MIN_VALUE) {
            return "$literal";
        }
        if (id == -2147483647L) {
            return "$any";
        }
        if (id == -2147483646L) {
            return "$untyped";
        }
        Value value = entities.get(id);
        return value != null ? value.toString() : "[unknown-id:" + id + "]";
    }

    private StatementIterator getUniqueSubjects(final Statements statements, final long pred) {
        return new StatementIterator(this){
            final StatementIterator sit;
            long prevSubject;
            {
                this.sit = statements.get(0L, pred, 0L);
            }

            public boolean next() {
                boolean next = this.sit.next();
                while (next && this.sit.subject == this.prevSubject) {
                    next = this.sit.next();
                }
                if (next) {
                    this.prevSubject = this.subject;
                    this.subject = this.sit.subject;
                }
                return next;
            }

            public void close() {
                this.sit.close();
            }
        };
    }

    protected void notifyIgnoreInvalidValue(String fieldName, String type, Value value) {
        this.logger.info("[{}] Ignored invalid value for field {} of type {}: {}", new Object[]{this.name, fieldName, type, value});
    }

    protected Literal asLiteral(Value value) throws InvalidFieldValueException {
        if (value instanceof Literal) {
            return (Literal)value;
        }
        throw new InvalidFieldValueException();
    }

    protected void setFieldValue(Property property, Map<String, Object> doc, String key, Object value) {
        if (property.getNativeType() != null && (property.getNativeType().equals("vector") || property.getNativeType().equals("semantic"))) {
            this.setVectorFieldValue(property, doc, key, value);
        } else if (property.isArray()) {
            if (property.isMultivalued()) {
                ArrayList<Object> values = (ArrayList<Object>)doc.get(key);
                if (values == null) {
                    values = new ArrayList<Object>(2);
                    doc.put(key, values);
                }
                values.add(value);
            } else {
                doc.put(key, Collections.singletonList(value));
            }
        } else if (property.isMultivalued()) {
            Object oldValue = doc.get(key);
            if (oldValue == null) {
                doc.put(key, value);
            } else if (oldValue instanceof List) {
                List values = (List)oldValue;
                values.add(value);
            } else {
                ArrayList<Object> replacedValue = new ArrayList<Object>(2);
                replacedValue.add(oldValue);
                replacedValue.add(value);
                doc.put(key, replacedValue);
            }
        } else {
            doc.put(key, value);
        }
    }

    private void setVectorFieldValue(Property property, Map<String, Object> doc, String key, Object value) {
        if (property.isArray() || property.isMultivalued()) {
            doc.merge(key, value, (a, b) -> String.valueOf(a) + " " + String.valueOf(b));
        } else {
            doc.put(key, value);
        }
    }
}

