/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import jakarta.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.LineStringPropertyType;
import net.opengis.gml.v_3_1_1.LineStringType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractJTSToGML311Converter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311CoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;
import org.locationtech.jts.geom.LineString;

public class JTSToGML311LineStringConverter
extends AbstractJTSToGML311Converter<LineStringType, LineStringPropertyType, LineString> {
    private final JTSToGML311CoordinateConverter coordinateConverter;

    public JTSToGML311LineStringConverter(ObjectFactoryInterface objectFactoryInterface, JTSToGML311SRSReferenceGroupConverterInterface jTSToGML311SRSReferenceGroupConverterInterface, JTSToGML311CoordinateConverter jTSToGML311CoordinateConverter) {
        super(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface);
        this.coordinateConverter = jTSToGML311CoordinateConverter;
    }

    @Override
    protected LineStringType doCreateGeometryType(LineString lineString) {
        LineStringType lineStringType = this.getObjectFactory().createLineStringType();
        for (DirectPositionType directPositionType : this.coordinateConverter.convertCoordinates(lineString.getCoordinates())) {
            JAXBElement<DirectPositionType> jAXBElement = this.getObjectFactory().createPos(directPositionType);
            lineStringType.getPosOrPointPropertyOrPointRep().add(jAXBElement);
        }
        return lineStringType;
    }

    @Override
    public LineStringPropertyType createPropertyType(LineString lineString) {
        LineStringPropertyType lineStringPropertyType = this.getObjectFactory().createLineStringPropertyType();
        lineStringPropertyType.setLineString((LineStringType)this.createGeometryType(lineString));
        return lineStringPropertyType;
    }

    @Override
    public JAXBElement<LineStringType> createElement(LineString lineString) {
        return this.getObjectFactory().createLineString((LineStringType)this.createGeometryType(lineString));
    }
}

