/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import jakarta.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.AbstractGeometryType;
import net.opengis.gml.v_3_1_1.AbstractRingPropertyType;
import net.opengis.gml.v_3_1_1.GeometryPropertyType;
import net.opengis.gml.v_3_1_1.LineStringPropertyType;
import net.opengis.gml.v_3_1_1.LineStringType;
import net.opengis.gml.v_3_1_1.LinearRingType;
import net.opengis.gml.v_3_1_1.MultiGeometryPropertyType;
import net.opengis.gml.v_3_1_1.MultiGeometryType;
import net.opengis.gml.v_3_1_1.MultiLineStringPropertyType;
import net.opengis.gml.v_3_1_1.MultiLineStringType;
import net.opengis.gml.v_3_1_1.MultiPointPropertyType;
import net.opengis.gml.v_3_1_1.MultiPointType;
import net.opengis.gml.v_3_1_1.MultiPolygonPropertyType;
import net.opengis.gml.v_3_1_1.MultiPolygonType;
import net.opengis.gml.v_3_1_1.PointPropertyType;
import net.opengis.gml.v_3_1_1.PointType;
import net.opengis.gml.v_3_1_1.PolygonPropertyType;
import net.opengis.gml.v_3_1_1.PolygonType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractJTSToGML311Converter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311Constants;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311ConverterInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311CoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311LineStringConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311LinearRingConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311MultiGeometryConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311MultiLineStringConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311MultiPointConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311MultiPolygonConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311PointConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311PolygonConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class JTSToGML311GeometryConverter
extends AbstractJTSToGML311Converter<AbstractGeometryType, GeometryPropertyType, Geometry> {
    private final JTSToGML311CoordinateConverter coordinateConverter;
    private final JTSToGML311ConverterInterface<PointType, PointPropertyType, Point> pointConverter;
    private final JTSToGML311ConverterInterface<LinearRingType, AbstractRingPropertyType, LinearRing> linearRingConverter;
    private final JTSToGML311ConverterInterface<LineStringType, LineStringPropertyType, LineString> lineStringConverter;
    private final JTSToGML311ConverterInterface<PolygonType, PolygonPropertyType, Polygon> polygonConverter;
    private final JTSToGML311ConverterInterface<MultiPointType, MultiPointPropertyType, MultiPoint> multiPointConverter;
    private final JTSToGML311ConverterInterface<MultiLineStringType, MultiLineStringPropertyType, MultiLineString> multiLineStringConverter;
    private final JTSToGML311ConverterInterface<MultiPolygonType, MultiPolygonPropertyType, MultiPolygon> multiPolygonConverter;
    private final JTSToGML311ConverterInterface<MultiGeometryType, MultiGeometryPropertyType, GeometryCollection> multiGeometryConverter;

    public JTSToGML311GeometryConverter() {
        this(JTSToGML311Constants.DEFAULT_OBJECT_FACTORY, JTSToGML311Constants.DEFAULT_SRS_REFERENCE_GROUP_CONVERTER);
    }

    public JTSToGML311GeometryConverter(ObjectFactoryInterface objectFactoryInterface, JTSToGML311SRSReferenceGroupConverterInterface jTSToGML311SRSReferenceGroupConverterInterface) {
        super(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface);
        this.coordinateConverter = new JTSToGML311CoordinateConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface);
        this.pointConverter = new JTSToGML311PointConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface, this.coordinateConverter);
        this.linearRingConverter = new JTSToGML311LinearRingConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface, this.coordinateConverter);
        this.lineStringConverter = new JTSToGML311LineStringConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface, this.coordinateConverter);
        this.polygonConverter = new JTSToGML311PolygonConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface, this.linearRingConverter);
        this.multiPointConverter = new JTSToGML311MultiPointConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface, this.pointConverter);
        this.multiLineStringConverter = new JTSToGML311MultiLineStringConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface, this.lineStringConverter);
        this.multiPolygonConverter = new JTSToGML311MultiPolygonConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface, this.polygonConverter);
        this.multiGeometryConverter = new JTSToGML311MultiGeometryConverter(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface, this);
    }

    @Override
    protected AbstractGeometryType doCreateGeometryType(Geometry geometry) {
        if (geometry instanceof Point) {
            return this.pointConverter.createGeometryType((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.lineStringConverter.createGeometryType((LineString)geometry);
        }
        if (geometry instanceof LinearRing) {
            return this.linearRingConverter.createGeometryType((LinearRing)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.polygonConverter.createGeometryType((Polygon)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.multiPointConverter.createGeometryType((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.multiLineStringConverter.createGeometryType((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.multiPolygonConverter.createGeometryType((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.multiGeometryConverter.createGeometryType((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public GeometryPropertyType createPropertyType(Geometry geometry) {
        GeometryPropertyType geometryPropertyType = this.getObjectFactory().createGeometryPropertyType();
        geometryPropertyType.setGeometry(this.createElement(geometry));
        return geometryPropertyType;
    }

    @Override
    public JAXBElement<? extends AbstractGeometryType> createElement(Geometry geometry) {
        if (geometry instanceof Point) {
            return this.pointConverter.createElement((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.lineStringConverter.createElement((LineString)geometry);
        }
        if (geometry instanceof LinearRing) {
            return this.linearRingConverter.createElement((LinearRing)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.polygonConverter.createElement((Polygon)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.multiPointConverter.createElement((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.multiLineStringConverter.createElement((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.multiPolygonConverter.createElement((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.multiGeometryConverter.createElement((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException();
    }
}

