/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data.steps;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.SparqlBuilderUtil;
import com.ontotext.graphql.compiler.querymodel.AskQuery;
import com.ontotext.graphql.compiler.querymodel.Base;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.Not;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.Prefix;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TempVar;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.querymodel.functions.Count;
import com.ontotext.graphql.compiler.querymodel.functions.SameTerm;
import com.ontotext.models.Constraint;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.rdf.LiteralValue;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.sparql.AskRequest;
import com.ontotext.sparql.BooleanResponse;
import com.ontotext.sparql.MapPropertyResultHandler;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.Rdf4jValueConverter;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.sparql.SparqlRequest;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.validator.data.ValidationTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.NotNull;

public class ValidationStepUtil {
    private static final String SO_TYPE = "soType";
    private static boolean disableQueriesLogging = true;

    private ValidationStepUtil() {
    }

    public static List<SparqlNode> getTypeConstraints(SomlSchema schema, ValidationTask task, Var subject) {
        return ValidationStepUtil.getTypeConstraints(schema, task.getObjectType(), subject, null);
    }

    public static List<SparqlNode> getTypeConstraints(SomlSchema schema, String type, Var subject, String typeAlias) {
        ConstraintGenerator constraintGenerator = new ConstraintGenerator(schema, OperationBuilderOptions.DEFAULT);
        Set<Constraint> targetConstraints = Collections.singleton(new Constraint(type));
        ArrayList sparqlNodes = new ArrayList();
        boolean isDefaultAlias = typeAlias == null;
        constraintGenerator.addBoTypeConstraint(targetConstraints, sparqlNodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(subject).boTypeAlias(isDefaultAlias ? SO_TYPE : typeAlias).build());
        return sparqlNodes.stream().flatMap(node -> node instanceof SparqlNodeSequence ? node.streamNodes() : Stream.of(node)).map(sparqlNode -> {
            if (sparqlNode instanceof Bind) {
                Bind bind = (Bind)sparqlNode;
                if (isDefaultAlias) {
                    return Empty.INSTANCE;
                }
                return new Bind(bind.getValue(), (Value)new Var(typeAlias));
            }
            return sparqlNode;
        }).filter(Empty.notEmpty()).collect(Collectors.toList());
    }

    public static List<SparqlNode> getAllOtherTypeConstraints(SomlSchema schema, String toSkip, Var subject, Var typename) {
        Shapes userDefinedShapes = schema.getObjects().getUserDefinedShapes();
        userDefinedShapes.remove((Object)toSkip);
        userDefinedShapes.remove((Object)"Object");
        userDefinedShapes.remove((Object)"Nameable");
        Collection subTypes = ((Collection)schema.getObjects().getIfPresent(toSkip).map(Shape::getConcreteSubTypes).orElse(List.of())).stream().map(Shape::getId).collect(Collectors.toSet());
        userDefinedShapes.keySet().removeAll(subTypes);
        Set<Constraint> constraints = ValidationStepUtil.toConstraints(userDefinedShapes);
        if (constraints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SparqlNode> sparqlNodes = new ArrayList<SparqlNode>();
        new ConstraintGenerator(schema, OperationBuilderOptions.DEFAULT).addBoTypeConstraint(constraints, sparqlNodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(subject).boTypeAlias(SO_TYPE).build());
        if (typename != null) {
            sparqlNodes.add((SparqlNode)new Bind((SparqlNode)new TempVar(subject, SO_TYPE), (Value)typename));
        }
        return sparqlNodes;
    }

    @NotNull
    private static Set<Constraint> toConstraints(Shapes userDefinedShapes) {
        return userDefinedShapes.values().stream().filter(shape -> !shape.isAbstract() && !shape.isUnion()).map(Shape::getId).map(Constraint::new).collect(Collectors.toSet());
    }

    public static List<SparqlNode> getAllTypeConstraints(SomlSchema schema, Var subject, Var typename) {
        Shapes userDefinedShapes = schema.getObjects().getUserDefinedShapes();
        userDefinedShapes.remove((Object)"Nameable");
        userDefinedShapes.remove((Object)"Object");
        Set<Constraint> constraints = ValidationStepUtil.toConstraints(userDefinedShapes);
        if (constraints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SparqlNode> sparqlNodes = new ArrayList<SparqlNode>();
        new ConstraintGenerator(schema, OperationBuilderOptions.DEFAULT).addBoTypeConstraint(constraints, sparqlNodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(subject).boTypeAlias(SO_TYPE).soTypeOptimizationThreshold(Integer.MAX_VALUE).build());
        if (typename != null) {
            sparqlNodes.add((SparqlNode)new Bind((SparqlNode)new TempVar(subject, SO_TYPE), (Value)typename));
        }
        return sparqlNodes;
    }

    public static Value getTargetPropertyPredicate(SomlSchema schema, ValidationTask task) {
        PropertyShape property = ValidationStepUtil.getTargetProperty(schema, task);
        return SparqlBuilderUtil.getPropertyPredicate((PropertyShape)property, null);
    }

    public static PropertyShape getTargetProperty(SomlSchema schema, ValidationTask task) {
        Shape shape = (Shape)schema.getObjects().get((Object)task.getObjectType());
        return (PropertyShape)shape.getProperty(task.getPropertyName()).orElseThrow(IllegalArgumentException::new);
    }

    public static String createAskQuery(SomlSchema schema, List<SparqlNode> sparqlNodes) {
        AskQuery askQuery = new AskQuery(sparqlNodes);
        schema.getSpecialPrefixes().getBaseIri().map(Base::new).ifPresent(arg_0 -> ((AskQuery)askQuery).setBase(arg_0));
        askQuery.getPrefixes().addAll(ValidationStepUtil.getPrefixes(schema, sparqlNodes));
        return askQuery.toSparql();
    }

    public static SelectQuery createSelectQuery(SomlSchema schema, List<SparqlNode> sparqlNodes) {
        SelectQuery query = new SelectQuery();
        schema.getSpecialPrefixes().getBaseIri().map(Base::new).ifPresent(arg_0 -> ((SelectQuery)query).setBase(arg_0));
        query.setPrefixes(ValidationStepUtil.getPrefixes(schema, sparqlNodes));
        query.setWhereBlock(new TriplePatternBlock(sparqlNodes));
        return query;
    }

    public static List<Prefix> getPrefixes(SomlSchema schema, List<SparqlNode> sparqlNodes) {
        Prefixes prefixes = schema.getPrefixes();
        return sparqlNodes.stream().flatMap(SparqlNode::getUsedPrefixes).distinct().map(prefix -> new Prefix(prefix, (String)prefixes.get(prefix))).collect(Collectors.toList());
    }

    public static BooleanResponse ask(DataEndpoint dataEndpoint, ValidationTask task, String question) {
        try (SparqlConnection connection = dataEndpoint.getConnection();){
            BooleanResponse booleanResponse = connection.executeAsk(ValidationStepUtil.setQueriesLogging(AskRequest.newSimpleQuery((String)task.getId(), (String)question)));
            return booleanResponse;
        }
    }

    public static void select(DataEndpoint dataEndpoint, ValidationTask task, String query, TupleQueryResultHandler handler) {
        try (SparqlConnection connection = dataEndpoint.getConnection();){
            connection.executeSelect(ValidationStepUtil.setQueriesLogging(QueryRequest.newSimpleQuery((String)task.getId(), (String)query)), handler);
        }
    }

    public static void select(DataEndpoint dataEndpoint, ValidationTask task, SelectQuery query, long limit, long offset, TupleQueryResultHandler handler) {
        ValidationStepUtil.select(dataEndpoint, task, query, limit, offset, handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void select(DataEndpoint dataEndpoint, ValidationTask task, SelectQuery query, long limit, long offset, TupleQueryResultHandler handler, boolean lateral) {
        if (limit > 0L) {
            query.setLimit(Long.valueOf(limit));
        }
        if (offset > 0L) {
            query.setOffset(Long.valueOf(offset));
        }
        Optional queryMode = SparqlEndpointRequestContext.getQueryMode();
        if (lateral) {
            SparqlEndpointRequestContext.setQueryMode((SparqlEndpoint.ExecutionMode)SparqlEndpoint.ExecutionMode.SUBQUERY);
        }
        try (SparqlConnection connection = dataEndpoint.getConnection();){
            connection.executeSelect(ValidationStepUtil.setQueriesLogging(QueryRequest.newSimpleQuery((String)task.getId(), (String)query.toSparql())), handler);
        }
        finally {
            if (lateral) {
                SparqlEndpointRequestContext.setQueryMode((SparqlEndpoint.ExecutionMode)queryMode.orElse(null));
            }
        }
    }

    private static <T, E extends SparqlRequest<T>> E setQueriesLogging(E request) {
        if (ValidationStepUtil.isQueryLoggingDisabled()) {
            request.disableRequestLogging();
        }
        return request;
    }

    public static void disableValidationQueryLogging() {
        disableQueriesLogging = true;
    }

    public static void enableValidationQueryLogging() {
        disableQueriesLogging = false;
    }

    static boolean isQueryLoggingDisabled() {
        return disableQueriesLogging;
    }

    public static List<SparqlNode> createIsMultiValueCheck(Value subject, Value predicate, Var valueVar) {
        Var value1 = new Var(valueVar, "_1");
        Var value2 = new Var(valueVar, "_2");
        ArrayList<SparqlNode> nodes = new ArrayList<SparqlNode>(3);
        nodes.add((SparqlNode)PatternNode.createPattern((Value)subject, (Value)predicate, (Value)value1));
        nodes.add((SparqlNode)PatternNode.createPattern((Value)subject, (Value)predicate, (Value)value2));
        nodes.add((SparqlNode)new Filter((SparqlNode)new Not((SparqlNode)new SameTerm((SparqlNode)value1, (SparqlNode)value2))));
        return nodes;
    }

    @NotNull
    public static Map<String, Long> executeCountAggregationQuery(SomlSchema schema, List<SparqlNode> sparqlNodes, Var aggregationVar, DataEndpoint dataEndpoint, ValidationTask validation) {
        SelectQuery query = ValidationStepUtil.createSelectQuery(schema, sparqlNodes);
        query.getGroupBy().add(aggregationVar);
        query.getProjectionSegment().add(aggregationVar);
        query.getProjectionSegment().add(new Count((SparqlNode)aggregationVar, new Var("count")));
        MapPropertyResultHandler handler = new MapPropertyResultHandler(aggregationVar.getName(), "count");
        ValidationStepUtil.select(dataEndpoint, validation, query.toSparql(), (TupleQueryResultHandler)handler);
        Shapes objects = schema.getObjects();
        Prefixes prefixes = schema.getPrefixes();
        return ValidationStepUtil.normalizeOccurrences(handler.getResults(), type -> {
            String converted = objects.resolveByType(type, Shape::getId);
            if (type.equals(converted)) {
                converted = prefixes.toModelShortIri(type);
            }
            return converted;
        });
    }

    @NotNull
    public static Function<Map.Entry<String, Long>, String> occurrenceToString() {
        String instance = ErrorMessages.get((String)"validations.instance");
        String instances = ErrorMessages.get((String)"validations.instances");
        String message = ErrorMessages.get((String)"validations.error-occurrence");
        return entry -> String.format(message, entry.getValue(), (Long)entry.getValue() == 1L ? instance : instances, entry.getKey());
    }

    static boolean addRangeMismatchMessage(Map<String, Long> distributionCount, ValidationTask validation, PropertyShape property) {
        if (distributionCount.isEmpty()) {
            return false;
        }
        Map.Entry<String, Long> first = distributionCount.entrySet().iterator().next();
        String[] split = ValidationStepUtil.occurrenceToString().apply(first).split("'", 2);
        String firstInstance = split[0];
        String firstInstanceType = "'" + split[1];
        List types = distributionCount.entrySet().stream().skip(1L).map(ValidationStepUtil.occurrenceToString()).collect(Collectors.toList());
        types.add(0, firstInstanceType);
        Object differentTypes = types.size() == 1 ? (String)types.get(0) : String.join((CharSequence)", ", types.subList(0, types.size() - 1)) + " " + ErrorMessages.get((String)"validations.and") + " " + (String)types.get(types.size() - 1);
        validation.addResultMessage("validations.range-mismatch", validation.getObjectType(), validation.getPropertyName(), property.getRange(), firstInstance, differentTypes);
        return true;
    }

    @NotNull
    public static Map<String, Long> normalizeOccurrences(Map<org.eclipse.rdf4j.model.Value, org.eclipse.rdf4j.model.Value> map, UnaryOperator<String> nameConverter) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> ValidationStepUtil.typeIriToName(nameConverter, entry), entry -> Rdf4jValueConverter.convertAsNumber((org.eclipse.rdf4j.model.Value)((org.eclipse.rdf4j.model.Value)entry.getValue())).longValue(), (v1, v2) -> v1, LinkedHashMap::new));
    }

    private static String typeIriToName(UnaryOperator<String> nameConverter, Map.Entry<org.eclipse.rdf4j.model.Value, org.eclipse.rdf4j.model.Value> entry) {
        String name = Rdf4jValueConverter.convertAsString((org.eclipse.rdf4j.model.Value)entry.getKey());
        if ("iri".equals(name)) {
            return "iri";
        }
        return (String)nameConverter.apply(name);
    }

    static Consumer<BindingSet> readBindings(Consumer<Object> response, String subject, String value, String type, String context) {
        LinkedHashMap resultCache = new LinkedHashMap();
        return bindingSet -> {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4, 0.9f);
            ValidationStepUtil.readBinding(value, bindingSet, result, val -> {
                Object serializable = Rdf4jValueConverter.convert((org.eclipse.rdf4j.model.Value)val);
                if (serializable instanceof LiteralValue) {
                    LiteralValue literalValue = (LiteralValue)serializable;
                    serializable = literalValue.asLiteral();
                }
                return serializable;
            });
            ValidationStepUtil.readBinding(type, bindingSet, result, Rdf4jValueConverter::convertAsString);
            ValidationStepUtil.readBinding(context, bindingSet, result, Rdf4jValueConverter::convertAsString);
            if (!result.isEmpty()) {
                resultCache.computeIfAbsent(Rdf4jValueConverter.convertAsString((org.eclipse.rdf4j.model.Value)bindingSet.getValue(subject)), id -> {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(3, 0.95f);
                    map.put("id", id);
                    LinkedList values = new LinkedList();
                    map.put("values", values);
                    response.accept(map);
                    return values;
                }).add(result);
            }
        };
    }

    private static void readBinding(String key, BindingSet bindings, Map<String, Object> result, Function<org.eclipse.rdf4j.model.Value, Object> valueConverter) {
        org.eclipse.rdf4j.model.Value value;
        if (key != null && (value = bindings.getValue(key)) != null) {
            result.put(key, valueConverter.apply(value));
        }
    }
}

