/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data.steps;

import com.ontotext.graphql.compiler.querymodel.Gt;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.querymodel.functions.Count;
import com.ontotext.graphql.compiler.querymodel.functions.GroupConcat;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.sparql.ConsumingTupleQueryResultHandler;
import com.ontotext.sparql.MapPropertyResultHandler;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.validator.data.DataRetrievalRequest;
import com.ontotext.validator.data.DataRetrievalResponse;
import com.ontotext.validator.data.DisplayableValidation;
import com.ontotext.validator.data.OffendingValidationDataRetrieval;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.steps.ValidationStepUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.NotNull;

public class ObjectTypeValidationStep
implements ValidationStep,
DisplayableValidation,
OffendingValidationDataRetrieval {
    public static final String NAME = "typeValidation";
    private static final Var SUBJECT = new Var("subject");
    private static final Var COUNT = new Var("count");
    private static final Var TYPE = new Var("type");
    private static final Var TYPES = new Var("types");

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(SomlSchema schema, Shape shape, PropertyShape propertyShape) {
        return schema != null && shape == null && propertyShape == null || schema == null && shape != null && propertyShape == null;
    }

    @Override
    public void validate(SomlSchema schema, ValidationTask validation, DataEndpoint dataEndpoint) {
        SelectQuery nestedQuery = this.generateSelect(schema, validation);
        nestedQuery.convertToSubSelect();
        ArrayList<SparqlNode> body = new ArrayList<SparqlNode>();
        body.add((SparqlNode)nestedQuery);
        SelectQuery query = ValidationStepUtil.createSelectQuery(schema, body);
        query.getProjectionSegment().add(TYPES);
        Var countVar = new Var(TYPES, COUNT.getName());
        query.getProjectionSegment().add(new Count((SparqlNode)TYPES, countVar));
        query.getGroupBy().add(TYPES);
        MapPropertyResultHandler handler = new MapPropertyResultHandler(TYPES.getName(), countVar.getName());
        ValidationStepUtil.select(dataEndpoint, validation, query.toSparql(), (TupleQueryResultHandler)handler);
        Map<String, Long> distributionCount = ValidationStepUtil.normalizeOccurrences(handler.getResults(), UnaryOperator.identity());
        if (!distributionCount.isEmpty()) {
            distributionCount.forEach((types, count) -> {
                if ((types = this.removeDuplicates(schema, (String)types)).indexOf(44) == -1) {
                    return;
                }
                if (count == 1L) {
                    validation.addResultMessage("validations.object-type-collisions-single", types);
                } else {
                    validation.addResultMessage("validations.object-type-collisions-multiple", count, types);
                }
            });
            if (validation.getResult() != null && !validation.getResult().isEmpty()) {
                validation.setTaskStatus(Task.TaskStatus.INFO);
            }
        }
    }

    private String removeDuplicates(SomlSchema schema, String typesString) {
        String[] types = typesString.split(", ");
        return Arrays.stream(types).distinct().sorted().map(arg_0 -> ((Prefixes)schema.getPrefixes()).toModelShortIri(arg_0)).collect(Collectors.joining(", "));
    }

    @Override
    public String getViewQuery(SomlSchema schema, ValidationTask validation) {
        SelectQuery selectQuery = this.generateSelect(schema, validation);
        selectQuery.setLimit(Long.valueOf(100L));
        return SparqlUtil.prettyPrint((String)selectQuery.toSparql());
    }

    @NotNull
    private SelectQuery generateSelect(SomlSchema schema, ValidationTask validation) {
        List<Object> body = new LinkedList();
        if (validation.getObjectType() != null) {
            body = ValidationStepUtil.getTypeConstraints(schema, validation, SUBJECT);
        }
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getAllTypeConstraints(schema, SUBJECT, TYPE);
        body.addAll(sparqlNodes);
        SelectQuery selectQuery = ValidationStepUtil.createSelectQuery(schema, body);
        selectQuery.getProjectionSegment().add(SUBJECT);
        selectQuery.getProjectionSegment().add(new Count((SparqlNode)TYPE, COUNT));
        selectQuery.getProjectionSegment().add(new GroupConcat((SparqlNode)TYPE, ", ", TYPES));
        selectQuery.getGroupBy().add(SUBJECT);
        selectQuery.setHaving((SparqlNode)new Gt(COUNT, (Value)new Literal((Object)1)));
        return selectQuery;
    }

    @Override
    public DataRetrievalResponse loadData(DataRetrievalRequest request) {
        SelectQuery selectQuery = this.generateSelect(request.getSchema(), request.getValidation());
        DataRetrievalResponse response = new DataRetrievalResponse();
        ConsumingTupleQueryResultHandler resultHandler = new ConsumingTupleQueryResultHandler(ValidationStepUtil.readBindings(response::addResultEntry, SUBJECT.getName(), COUNT.getName(), TYPE.getName(), TYPES.getName()));
        ValidationStepUtil.select(request.getDataEndpoint(), request.getValidation(), selectQuery, request.getLimit(), request.getOffset(), (TupleQueryResultHandler)resultHandler);
        return response;
    }
}

