/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.plugin.PluginsManager;
import com.ontotext.validator.data.DisplayableValidation;
import com.ontotext.validator.data.OffendingValidationDataRetrieval;
import com.ontotext.validator.data.ValidationStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ValidationSteps {
    private static Map<String, ValidationStep> validationStepMap;
    private static Set<String> queryableSteps;
    private static Set<String> dataRetrievalSteps;

    private ValidationSteps() {
    }

    public static void useInstalledSteps() {
        LinkedHashMap<String, ValidationStep> map = new LinkedHashMap<String, ValidationStep>();
        LinkedHashSet<String> queryable = new LinkedHashSet<String>();
        LinkedHashSet<String> dataSet = new LinkedHashSet<String>();
        List validationSteps = PluginsManager.loadPlugins(ValidationStep.class);
        for (ValidationStep step : validationSteps) {
            map.put(step.getName(), step);
            if (step instanceof DisplayableValidation) {
                queryable.add(step.getName());
            }
            if (!(step instanceof OffendingValidationDataRetrieval)) continue;
            dataSet.add(step.getName());
        }
        validationStepMap = Collections.unmodifiableMap(map);
        queryableSteps = Collections.unmodifiableSet(queryable);
        dataRetrievalSteps = Collections.unmodifiableSet(dataSet);
    }

    public static void useSteps(ValidationStep ... steps) {
        LinkedHashMap<String, ValidationStep> map = new LinkedHashMap<String, ValidationStep>();
        LinkedHashSet<String> queryable = new LinkedHashSet<String>();
        LinkedHashSet<String> dataSet = new LinkedHashSet<String>();
        for (ValidationStep step : steps) {
            if (step instanceof DisplayableValidation) {
                queryable.add(step.getName());
            }
            map.put(step.getName(), step);
            if (!(step instanceof OffendingValidationDataRetrieval)) continue;
            dataSet.add(step.getName());
        }
        validationStepMap = Collections.unmodifiableMap(map);
        queryableSteps = Collections.unmodifiableSet(queryable);
        dataRetrievalSteps = Collections.unmodifiableSet(dataSet);
    }

    public static void disableQueryBuilding() {
        queryableSteps = Collections.emptySet();
    }

    public static ValidationStep getStep(String name) {
        return validationStepMap.get(name);
    }

    public static boolean isQueryable(String name) {
        return queryableSteps.contains(name);
    }

    public static boolean isDataQueryable(String name) {
        return dataRetrievalSteps.contains(name);
    }

    public static Stream<ValidationStep> findMatchingSteps(SomlSchema schema, Shape shape, PropertyShape propertyShape) {
        return validationStepMap.values().stream().filter(validationStep -> validationStep.accept(schema, shape, propertyShape));
    }

    public static Collection<String> getAvailable() {
        return new ArrayList<String>(validationStepMap.keySet());
    }

    static {
        ValidationSteps.useInstalledSteps();
    }
}

