/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationSteps;
import com.ontotext.validator.data.ValidationTask;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class SomlSchemaValidationTaskGenerator {
    List<ValidationTask> prepareForValidation(SomlSchema schema, Set<String> properties) {
        Predicate<PropertyShape> propertiesFilter = SomlSchemaValidationTaskGenerator.createPropertiesFilter(properties);
        return Stream.concat(ValidationSteps.findMatchingSteps(schema, null, null).map(SomlSchemaValidationTaskGenerator.validationStepToValidationTask(null, null)), schema.getObjects().values().stream().filter(shape -> !shape.isSystem() && !shape.isAbstract() && !shape.isUnion()).flatMap(shape -> this.getShapePropertiesTasks(schema, (Shape)shape, propertiesFilter))).collect(Collectors.toList());
    }

    List<ValidationTask> prepareForValidation(SomlSchema schema, Set<String> types, Set<String> properties) {
        Predicate<PropertyShape> propertiesFilter = SomlSchemaValidationTaskGenerator.createPropertiesFilter(properties);
        return types.stream().flatMap(type -> {
            Shape shape = (Shape)schema.getObjects().get(type);
            if (shape == null) {
                throw new IllegalArgumentException("Unknown schema object type: " + type);
            }
            if (shape.isAbstract()) {
                return shape.getSubTypes().stream();
            }
            if (shape.isUnion()) {
                return shape.getConcreteSubTypes().stream();
            }
            return Stream.of(shape);
        }).flatMap(shape -> this.getShapePropertiesTasks(null, (Shape)shape, propertiesFilter)).collect(Collectors.toList());
    }

    @NotNull
    private Stream<ValidationTask> getShapePropertiesTasks(SomlSchema schema, Shape shape, Predicate<PropertyShape> propertiesFilter) {
        return Stream.concat(SomlSchemaValidationTaskGenerator.getShapeTasks(schema, shape), shape.getAllProperties().values().stream().filter(SomlSchemaValidationTaskGenerator.propertiesWithoutArguments()).filter(prop -> !prop.isCountProperty()).filter(propertiesFilter).flatMap(this.getPropertyTasks(shape)));
    }

    @NotNull
    private static Predicate<PropertyShape> createPropertiesFilter(Set<String> properties) {
        if (properties == null || properties.isEmpty()) {
            return prop -> true;
        }
        LinkedHashSet<String> noFilters = new LinkedHashSet<String>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String property : properties) {
            if (property.contains("*")) {
                patterns.add(Pattern.compile("^" + property.replace("*", "[\\w:-]*") + "$"));
                continue;
            }
            noFilters.add(property);
        }
        if (patterns.isEmpty()) {
            return SomlSchemaValidationTaskGenerator.getPropertyExactMatchFilter(noFilters);
        }
        if (noFilters.isEmpty()) {
            return SomlSchemaValidationTaskGenerator.getPropertyPatternFilter(patterns);
        }
        return SomlSchemaValidationTaskGenerator.getCombinedPropertyFilter(noFilters, patterns);
    }

    @NotNull
    private static Predicate<PropertyShape> getPropertyExactMatchFilter(Set<String> noFilters) {
        return propertyShape -> noFilters.contains(propertyShape.getName()) || noFilters.contains(propertyShape.asGraphQl());
    }

    @NotNull
    private static Predicate<PropertyShape> getPropertyPatternFilter(List<Pattern> patterns) {
        return propertyShape -> {
            String name = propertyShape.getName();
            String gqlName = propertyShape.asGraphQl();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(name).matches() && !pattern.matcher(gqlName).matches()) continue;
                return true;
            }
            return false;
        };
    }

    @NotNull
    private static Predicate<PropertyShape> getCombinedPropertyFilter(Set<String> noFilters, List<Pattern> patterns) {
        return propertyShape -> {
            String name = propertyShape.getName();
            String gqlName = propertyShape.asGraphQl();
            if (noFilters.contains(name) || noFilters.contains(gqlName)) {
                return true;
            }
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(name).matches() && !pattern.matcher(gqlName).matches()) continue;
                return true;
            }
            return false;
        };
    }

    @NotNull
    private static Predicate<PropertyShape> propertiesWithoutArguments() {
        return property -> !property.isSparqlTemplate() || property.getSparqlTemplate() != null && !property.getSparqlTemplate().hasArgs();
    }

    private static Stream<ValidationTask> getShapeTasks(SomlSchema schema, Shape shape) {
        return ValidationSteps.findMatchingSteps(schema, shape, null).map(SomlSchemaValidationTaskGenerator.validationStepToValidationTask(shape, null));
    }

    private Function<PropertyShape, Stream<ValidationTask>> getPropertyTasks(Shape shape) {
        return property -> ValidationSteps.findMatchingSteps(null, shape, property).map(SomlSchemaValidationTaskGenerator.validationStepToValidationTask(shape, property));
    }

    private static Function<ValidationStep, ValidationTask> validationStepToValidationTask(Shape shape, PropertyShape property) {
        return validationStep -> validationStep.createValidationTask(shape, property);
    }
}

