/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.http;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.proxy.AltBodyHttpServletRequest;
import com.ontotext.forest.core.proxy.SkipParametersHttpServletRequest;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.http.X509UsernameExtractor;
import com.ontotext.graphdb.security.TokenManager;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Component
public class ServletProxy {
    public static final String FORWARD_HOST = "X-Forwarded-Host";
    public static final String FORWARD_PROTO = "X-Forwarded-Proto";
    public static final Set<String> NON_TRANSFERABLE_REQUEST_HEADERS;
    public static final Set<String> NON_TRANSFERABLE_REQUEST_HEADERS_PROXY;
    public static final Set<String> NON_TRANSFERABLE_RESPONSE_HEADERS;
    private static final Logger LOGGER;
    private static final String CONTENT_TYPE = "content-type";
    private static final int TRANSACTIONS_OFFSET;
    private final MappingJackson2HttpMessageConverter springJacksonConverter;
    private final X509UsernameExtractor x509UsernameExtractor = new X509UsernameExtractor();
    private final boolean x509Enabled;

    @Autowired
    public ServletProxy(MappingJackson2HttpMessageConverter springJacksonConverter) {
        this.springJacksonConverter = springJacksonConverter;
        this.x509Enabled = StringUtils.containsAny((CharSequence)Config.getProperty((String)"graphdb.auth.methods"), (CharSequence)"x509");
    }

    public void proxyRequest(HttpServletRequest request, HttpServletResponse response, String uri, CloseableHttpClient httpClient) throws IOException {
        HttpUriRequest proxiedRequest = this.createCopyRequest(request, uri, NON_TRANSFERABLE_REQUEST_HEADERS);
        try (CloseableHttpResponse proxiedResponse = httpClient.execute(proxiedRequest);){
            ServletProxy.copyResponse((HttpResponse)proxiedResponse, response, true, (header, value) -> value);
        }
    }

    public void proxyRequestWithAuthentication(HttpServletRequest request, HttpServletResponse response, String uri, CloseableHttpClient httpClient, BinaryOperator<String> responseHeaderReWriter) throws IOException {
        HttpUriRequest proxiedRequest = this.createCopyRequest(request, uri, NON_TRANSFERABLE_REQUEST_HEADERS_PROXY, true);
        String authHeader = request.getHeader("Authorization");
        String acceptHeader = request.getHeader("Accept");
        if ((authHeader == null || "null".equals(authHeader)) && this.x509Enabled) {
            String x509Username = this.x509UsernameExtractor.getX509Username(request);
            if (x509Username != null) {
                TokenManager.getInstance().signRequestAsUser(proxiedRequest, x509Username);
            }
        } else if (authHeader != null && authHeader.startsWith("GDB-Signature ") && TokenManager.getInstance().verifyRequest(request, authHeader)) {
            TokenManager.getInstance().signRequestFull(proxiedRequest);
        }
        try (CloseableHttpResponse proxiedResponse = httpClient.execute(proxiedRequest);){
            ServletProxy.copyResponse((HttpResponse)proxiedResponse, response, false, responseHeaderReWriter, "text/event-stream".equalsIgnoreCase(acceptHeader));
        }
    }

    HttpUriRequest createCopyRequest(HttpServletRequest request, String uri, Set<String> forbiddenHeaders) throws IOException {
        return this.createCopyRequest(request, uri, forbiddenHeaders, false);
    }

    @VisibleForTesting
    HttpUriRequest createCopyRequest(HttpServletRequest request, String uri, Set<String> forbiddenHeaders, boolean isClusterProxy) throws IOException {
        String xForwardedFor;
        RequestBuilder rb = RequestBuilder.create((String)request.getMethod());
        rb.setUri(uri);
        Enumeration headerNames = request.getHeaderNames();
        String xForwardedHost = request.getHeader(FORWARD_HOST);
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (forbiddenHeaders.contains(headerName)) {
                if (!headerName.equalsIgnoreCase("Host") || xForwardedHost != null) continue;
                rb.addHeader(FORWARD_HOST, request.getHeader(headerName));
                continue;
            }
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                rb.addHeader(headerName, (String)headerValues.nextElement());
            }
        }
        if (rb.getFirstHeader(FORWARD_HOST) == null && !StringUtils.isEmpty((CharSequence)Config.getExternalHost())) {
            rb.addHeader(FORWARD_HOST, Config.getExternalHost());
            if (rb.getFirstHeader(FORWARD_PROTO) == null) {
                rb.addHeader(FORWARD_PROTO, request.getScheme());
            }
        }
        if (request.getHeader("X-GraphDB-Proxied-From") == null) {
            Object proxiedValue = isClusterProxy ? "cluster-proxy;" + String.valueOf(request.getRequestURL()) : request.getRequestURL().toString();
            rb.addHeader("X-GraphDB-Proxied-From", (String)proxiedValue);
        }
        if (StringUtils.isEmpty((CharSequence)(xForwardedFor = request.getHeader("X-Forwarded-For")))) {
            rb.addHeader("X-Forwarded-For", request.getRemoteAddr());
        }
        boolean isUriEncoded = this.isFormUrlEncoded(request);
        String contentType = request.getContentType();
        if (!isUriEncoded && contentType != null && contentType.startsWith("multipart/form-data")) {
            String queryString = request.getQueryString();
            if (queryString != null) {
                List list = URLEncodedUtils.parse((String)queryString, (Charset)StandardCharsets.UTF_8);
                for (NameValuePair param : list) {
                    rb.addParameter(param.getName(), param.getValue());
                }
            }
        } else if (!isUriEncoded) {
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                for (String value : (String[])entry.getValue()) {
                    rb.addParameter((String)entry.getKey(), value);
                }
            }
        }
        if (request instanceof AltBodyHttpServletRequest) {
            rb.removeHeaders(CONTENT_TYPE);
            rb.setEntity((HttpEntity)new StringEntity(this.springJacksonConverter.getObjectMapper().writeValueAsString(((AltBodyHttpServletRequest)request).getBodyObject()), ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)));
        } else {
            while (request instanceof SkipParametersHttpServletRequest) {
                request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                ((MultipartHttpServletRequest)request).getFileMap().forEach((name, file) -> {
                    multipartEntityBuilder.addPart(name, ServletProxy.multipartFileToContentBody(file));
                    rb.setEntity(multipartEntityBuilder.build());
                });
                rb.removeHeaders(CONTENT_TYPE);
            } else if (isUriEncoded) {
                rb.setEntity((HttpEntity)this.createUrlEncodedFormEntity(request));
            } else {
                rb.setEntity((HttpEntity)new InputStreamEntity((InputStream)request.getInputStream()));
            }
        }
        return rb.build();
    }

    private UrlEncodedFormEntity createUrlEncodedFormEntity(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedList<BasicNameValuePair> nameValuePairs = new LinkedList<BasicNameValuePair>();
        for (Map.Entry entry : parameterMap.entrySet()) {
            for (String paramValue : (String[])entry.getValue()) {
                nameValuePairs.add(new BasicNameValuePair((String)entry.getKey(), paramValue));
            }
        }
        Enumeration headerValues = request.getHeaders("Content-Type");
        Charset charset = StandardCharsets.UTF_8;
        while (headerValues.hasMoreElements()) {
            Charset parsed;
            String element = (String)headerValues.nextElement();
            if (!element.contains(ContentType.APPLICATION_FORM_URLENCODED.getMimeType()) || (parsed = ContentType.parse((String)element).getCharset()) == null) continue;
            charset = parsed;
        }
        return new UrlEncodedFormEntity(nameValuePairs, charset);
    }

    private boolean isFormUrlEncoded(HttpServletRequest request) {
        String method = request.getMethod();
        if (method.equals("POST") || method.equals("PUT") || method.equals("PATCH") || method.equals("DELETE")) {
            Enumeration headerValues = request.getHeaders("Content-Type");
            while (headerValues.hasMoreElements()) {
                if (!((String)headerValues.nextElement()).contains(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) continue;
                return true;
            }
        }
        return false;
    }

    private static ContentBody multipartFileToContentBody(final MultipartFile file) {
        String contentType = file.getContentType();
        if (contentType == null) {
            throw new IllegalArgumentException("Multipart file missing content type");
        }
        return new AbstractContentBody(ContentType.parse((String)contentType)){

            public String getFilename() {
                return file.getOriginalFilename();
            }

            public void writeTo(OutputStream outputStream) throws IOException {
                try (InputStream inputStream = file.getInputStream();){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            }

            public String getTransferEncoding() {
                return "binary";
            }

            public long getContentLength() {
                return file.getSize();
            }
        };
    }

    static void copyResponse(HttpResponse proxiedResponse, HttpServletResponse response, boolean hideAuthorizationFailure, BinaryOperator<String> responseHeaderReWriter) throws IOException {
        ServletProxy.copyResponse(proxiedResponse, response, hideAuthorizationFailure, responseHeaderReWriter, false);
    }

    @VisibleForTesting
    static void copyResponse(HttpResponse proxiedResponse, HttpServletResponse response, boolean hideAuthorizationFailure, BinaryOperator<String> responseHeaderReWriter, boolean isSse) throws IOException {
        int responseStatus = proxiedResponse.getStatusLine().getStatusCode();
        if (responseStatus == 401 && hideAuthorizationFailure) {
            responseStatus = 400;
        }
        response.setStatus(responseStatus);
        for (Header header : proxiedResponse.getAllHeaders()) {
            String newValue;
            String headerName = header.getName();
            if (NON_TRANSFERABLE_RESPONSE_HEADERS.contains(headerName) || (newValue = (String)responseHeaderReWriter.apply(headerName, header.getValue())) == null) continue;
            response.addHeader(header.getName(), newValue);
        }
        HttpEntity entity = proxiedResponse.getEntity();
        if (entity != null) {
            try (InputStream in = entity.getContent();
                 ServletOutputStream out = response.getOutputStream();){
                if (isSse) {
                    response.setContentType("text/event-stream");
                    response.setCharacterEncoding(StandardCharsets.UTF_8);
                    ServletProxy.handleSse(in, (OutputStream)out);
                } else {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
            catch (IOException ioException) {
                LOGGER.error("Failed operation. Stream was cancelled due to {}", (Object)ioException.getMessage());
                throw ioException;
            }
            finally {
                if (!isSse) {
                    response.flushBuffer();
                }
            }
        }
    }

    public BinaryOperator<String> transactionHeaderReWriter(HttpServletRequest request, Function<HttpServletRequest, String> externalAddressProvider) {
        String requestURI = request.getRequestURI();
        if (request.getMethod().equals("POST") && requestURI.startsWith("/repositories/") && requestURI.endsWith("/transactions")) {
            return (header, value) -> {
                if ("location".equalsIgnoreCase((String)header)) {
                    String externalAddress = (String)externalAddressProvider.apply(request);
                    if (externalAddress.endsWith("/")) {
                        externalAddress = externalAddress.substring(0, externalAddress.length() - 1);
                    }
                    return externalAddress + request.getContextPath() + requestURI + "/" + value;
                }
                return value;
            };
        }
        return (header, value) -> value;
    }

    @Nullable
    public String extractProxiedTransactionUri(HttpServletRequest request) {
        int index;
        String requestURI = request.getRequestURI();
        String method = request.getMethod();
        if (requestURI.startsWith("/repositories/") && (method.equals("PUT") || method.equals("POST") || method.equals("DELETE")) && (index = requestURI.indexOf("/transactions/http")) > 0) {
            String scheme;
            Object transactionUri = requestURI.substring(index + TRANSACTIONS_OFFSET);
            int colonIndex = ((String)transactionUri).indexOf(":/");
            if (colonIndex > 0 && (scheme = ((String)transactionUri).substring(0, colonIndex)).toLowerCase().startsWith("http") && !((String)transactionUri).substring(colonIndex + 1, colonIndex + 3).equals("//")) {
                transactionUri = scheme + ":/" + ((String)transactionUri).substring(colonIndex + 1);
            }
            return transactionUri;
        }
        return null;
    }

    private static void handleSse(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            out.flush();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ServletProxy.class);
        TRANSACTIONS_OFFSET = "/transactions/".length();
        Set<String> defaultForbiddenHeaders = Set.of("connection", "content-length", "date", "expect", "from", "host", "upgrade", "via", "warning", "transfer-encoding");
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(defaultForbiddenHeaders);
        NON_TRANSFERABLE_REQUEST_HEADERS_PROXY = Collections.unmodifiableSet(treeSet);
        treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(NON_TRANSFERABLE_REQUEST_HEADERS_PROXY);
        treeSet.addAll(Set.of("authorization", "X-GraphDB-Repository-Location"));
        NON_TRANSFERABLE_REQUEST_HEADERS = Collections.unmodifiableSet(treeSet);
        treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(defaultForbiddenHeaders);
        NON_TRANSFERABLE_RESPONSE_HEADERS = Collections.unmodifiableSet(treeSet);
    }
}

