/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy.state;

import com.ontotext.graphdb.cluster.observer.grpc.Node;
import com.ontotext.graphdb.cluster.observer.grpc.Status;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStatus {
    private static final Logger logger = LoggerFactory.getLogger(NodeStatus.class);
    private final Node node;
    private Status status;
    private final AtomicLong activeRequests = new AtomicLong();
    private final AtomicLong failureCount = new AtomicLong();
    private final AtomicLong lastFailure = new AtomicLong();

    public NodeStatus(Node node, Status status) {
        this.node = node;
        this.status = status;
    }

    public NodeStatus(Map<String, Object> map) {
        this.setStatus(Status.valueOf((String)Objects.toString(map.get("nodeState"), Status.NO_CONNECTION.name())));
        this.node = Node.newBuilder().setRpcAddress(Objects.toString(map.get("address"))).setHttpAddress(Objects.toString(map.get("endpoint"))).build();
    }

    public Node getNode() {
        return this.node;
    }

    public Status getStatus() {
        return this.status;
    }

    public NodeStatus setStatus(Status status) {
        if (status != Status.NO_CONNECTION) {
            this.failureCount.set(0L);
            this.lastFailure.set(0L);
        } else {
            this.lastFailure.set(System.currentTimeMillis());
        }
        this.status = status;
        return this;
    }

    public boolean isLeader() {
        return this.isActive() && this.status == Status.LEADER;
    }

    public boolean isFollower() {
        return this.isActive() && this.status == Status.FOLLOWER;
    }

    public boolean notInCluster() {
        return this.getStatus() == Status.NO_CLUSTER;
    }

    public boolean isDisconnected() {
        return this.getStatus() == Status.NO_CONNECTION;
    }

    public String getRpcAddress() {
        return this.node.getRpcAddress();
    }

    public URI getHttpAddressUri() {
        return URI.create(this.node.getHttpAddress());
    }

    public String getHttpAddress() {
        return this.node.getHttpAddress();
    }

    public Stream<String> getAddresses() {
        return Stream.of(this.node.getHttpAddress(), this.node.getRpcAddress()).filter(StringUtils::isNotBlank);
    }

    public boolean isValid() {
        return this.status != null && this.node != null && !"null".equals(this.node.getRpcAddress()) && !"null".equals(this.node.getHttpAddress()) && StringUtils.isNotBlank((CharSequence)this.node.getHttpAddress()) && StringUtils.isNotBlank((CharSequence)this.node.getRpcAddress());
    }

    public boolean setAccessible() {
        if (this.status == Status.NO_CONNECTION) {
            this.status = Status.FOLLOWER;
            this.lastFailure.set(0L);
            this.failureCount.set(0L);
            return true;
        }
        return false;
    }

    public boolean markAsNotAccessible() {
        if (this.status != Status.NO_CONNECTION) {
            this.status = Status.NO_CONNECTION;
            this.failureCount.incrementAndGet();
            this.lastFailure.set(System.currentTimeMillis());
            return true;
        }
        this.lastFailure.set(System.currentTimeMillis());
        return false;
    }

    public void incrementQueryCount() {
        this.activeRequests.incrementAndGet();
    }

    public void decrementQueryCount() {
        this.activeRequests.decrementAndGet();
    }

    public long getActiveQueries() {
        return this.activeRequests.get();
    }

    public boolean isActive() {
        boolean noConnection;
        boolean bl = noConnection = this.status == Status.NO_CONNECTION;
        if (noConnection) {
            if (System.currentTimeMillis() - this.lastFailure.get() > TimeUnit.MINUTES.toMillis(1L)) {
                logger.info("Setting node {} status to NO_CLUSTER after waiting for more than 1 minute", (Object)this.getRpcAddress());
                this.lastFailure.set(0L);
                this.status = Status.NO_CLUSTER;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "NodeStatus{node=" + String.valueOf(this.node) + ", status=" + String.valueOf(this.status) + ", activeRequests=" + String.valueOf(this.activeRequests) + ", failureCount=" + String.valueOf(this.failureCount) + ", lastFailure=" + String.valueOf(this.lastFailure) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NodeStatus)) {
            return false;
        }
        NodeStatus that = (NodeStatus)obj;
        return this.node.equals((Object)that.node);
    }

    public int hashCode() {
        return Objects.hash(this.node);
    }
}

