/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy.state;

import com.ontotext.graphdb.cluster.observer.grpc.Node;
import com.ontotext.graphdb.cluster.observer.grpc.Status;
import com.ontotext.graphdb.proxy.ClusterUpdateCallback;
import com.ontotext.graphdb.proxy.state.ClusterStateHolder;
import com.ontotext.graphdb.proxy.state.NodeStatus;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ClusterAddressResolver
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClusterStateHolder clusterInfoResolver;
    private final HttpAddressHolder httpAddressHolder;

    public ClusterAddressResolver(ClusterStateHolder clusterInfoResolver) {
        this.clusterInfoResolver = clusterInfoResolver;
        this.validateInitialAddresses(clusterInfoResolver.getInitialHosts());
        Deque httpHosts = clusterInfoResolver.getInitialHosts().stream().map(address -> new NodeStatus(this.createNodeFromStringAddress((String)address), Status.NO_CLUSTER)).collect(Collectors.toCollection(LinkedList::new));
        LOGGER.info("Initial hosts = {}", (Object)httpHosts);
        this.httpAddressHolder = new HttpAddressHolder(httpHosts);
        clusterInfoResolver.notifyOnClusterChange(this.httpAddressHolder);
    }

    public List<String> getInitialHosts() {
        return this.clusterInfoResolver.getInitialHosts();
    }

    public Stream<NodeStatus> getDynamicState() {
        return this.clusterInfoResolver.getCurrentClusterState();
    }

    public Set<String> getClusterAddresses() {
        return this.clusterInfoResolver.getClusterAddresses();
    }

    public int getDynamicStateSize() {
        return this.clusterInfoResolver.getClusterSize();
    }

    public ClusterStateHolder getClusterStateHolder() {
        return this.clusterInfoResolver;
    }

    public NodeStatus resolveRandomNode() {
        return this.clusterInfoResolver.getClusterState().filter(NodeStatus::isActive).min(Comparator.comparingLong(NodeStatus::getActiveQueries)).orElseGet(this.httpAddressHolder::getAndRotateHostAddresses);
    }

    public NodeStatus resolveFollowerNode() {
        return this.clusterInfoResolver.getClusterState().filter(NodeStatus::isFollower).min(Comparator.comparingLong(NodeStatus::getActiveQueries)).orElseGet(this::resolveRandomNode);
    }

    public NodeStatus resolveLeaderNode() {
        return this.clusterInfoResolver.getClusterState().filter(NodeStatus::isLeader).findFirst().orElseGet(this::resolveRandomNode);
    }

    public NodeStatus resolveLeaderNodeOrElseThrow() {
        return this.clusterInfoResolver.getClusterState().filter(NodeStatus::isLeader).findFirst().or(() -> this.clusterInfoResolver.refreshLeader()).orElseThrow(() -> new IllegalStateException("Currently there is no leader to process this request."));
    }

    public void setAccessible(NodeStatus nodeStatus) {
        if (nodeStatus.setAccessible()) {
            this.clusterInfoResolver.setAccessible(nodeStatus);
        }
    }

    public void markAsNotAccessible(NodeStatus nodeStatus) {
        if (nodeStatus.markAsNotAccessible()) {
            this.clusterInfoResolver.setNotAccessible(nodeStatus);
        }
    }

    @Override
    public void close() {
        this.clusterInfoResolver.close();
    }

    public boolean isValidAddressFromCluster(String serverAddress) {
        if (this.clusterInfoResolver.getCurrentClusterState().map(NodeStatus::getHttpAddress).anyMatch(serverAddress::startsWith)) {
            return true;
        }
        return this.httpAddressHolder.validateHost(serverAddress);
    }

    @NotNull
    private Node createNodeFromStringAddress(String address) {
        if (address.startsWith("http")) {
            return Node.newBuilder().setHttpAddress(address).build();
        }
        return Node.newBuilder().setRpcAddress(address).build();
    }

    private void validateInitialAddresses(List<String> providedHostAddress) {
        ArrayList<String> invalidAddresses = new ArrayList<String>();
        for (String hostAddress : providedHostAddress) {
            if (hostAddress.contains("/")) {
                try {
                    new URL(hostAddress);
                }
                catch (MalformedURLException ignored) {
                    invalidAddresses.add(hostAddress);
                }
                continue;
            }
            if (this.isValidGrpcAddress(hostAddress)) continue;
            invalidAddresses.add(hostAddress);
        }
        if (!invalidAddresses.isEmpty()) {
            boolean isPlural = invalidAddresses.size() > 1;
            throw new IllegalArgumentException(String.format("The provided address%s \"%s\" %s not valid", isPlural ? "es" : "", String.join((CharSequence)"\", \"", invalidAddresses), isPlural ? "are" : "is"));
        }
    }

    private boolean isValidGrpcAddress(String hostAddress) {
        try {
            String[] parts = hostAddress.split(":");
            String host = parts[0];
            int port = Integer.parseInt(parts[1]);
            ManagedChannel channel = ManagedChannelBuilder.forAddress((String)host, (int)port).build();
            channel.shutdownNow();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class HttpAddressHolder
    implements ClusterUpdateCallback {
        private final Deque<NodeStatus> httpHosts;

        HttpAddressHolder(Deque<NodeStatus> httpHosts) {
            this.httpHosts = httpHosts;
        }

        @Override
        public synchronized void nodeUpdated(NodeStatus node) {
            boolean nodeRemoved = this.removeNode(node.getNode());
            if (!node.notInCluster()) {
                this.httpHosts.add(new NodeStatus(node.getNode(), Status.NO_CLUSTER));
                if (!nodeRemoved) {
                    this.printCurrentAddresses();
                }
            } else if (nodeRemoved) {
                this.printCurrentAddresses();
            }
        }

        @Override
        public synchronized void nodeRemoved(Node node) {
            if (this.removeNode(node)) {
                this.printCurrentAddresses();
            }
        }

        private boolean removeNode(Node node) {
            return this.httpHosts.removeIf(otherNode -> otherNode.getNode().getHttpAddress().equals(node.getHttpAddress()));
        }

        private void printCurrentAddresses() {
            String currentHosts = this.httpHosts.stream().map(NodeStatus::getHttpAddress).filter(StringUtils::hasText).collect(Collectors.joining(", "));
            LOGGER.info("Cluster configuration changed. Will proxy requests to: {}", (Object)currentHosts);
        }

        @NotNull
        private synchronized NodeStatus getAndRotateHostAddresses() {
            if (this.httpHosts.isEmpty()) {
                throw new IllegalStateException("Unable to find a host from the initial configuration");
            }
            if (this.httpHosts.size() == 1) {
                return this.httpHosts.getFirst();
            }
            Optional<NodeStatus> firstActive = this.httpHosts.stream().filter(NodeStatus::isActive).findFirst();
            if (firstActive.isPresent()) {
                return firstActive.get();
            }
            NodeStatus topAddress = this.httpHosts.poll();
            assert (topAddress != null);
            this.httpHosts.offerLast(topAddress);
            return topAddress;
        }

        synchronized boolean validateHost(String serverAddress) {
            return this.httpHosts.stream().map(NodeStatus::getHttpAddress).anyMatch(nodeHttpAddress -> StringUtils.hasText((String)nodeHttpAddress) && serverAddress.startsWith((String)nodeHttpAddress));
        }
    }
}

