/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy.grpc;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.security.AuthenticatorInterceptor;
import com.ontotext.graphdb.raft.security.SSLInterceptor;
import com.ontotext.graphdb.raft.security.SecurityConfig;
import com.ontotext.graphdb.raft.security.SecurityUtil;
import io.grpc.BindableService;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.util.MutableHandlerRegistry;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class RpcServer {
    protected Server server;
    protected ServerBuilder<?> serverBuilder;
    private MutableHandlerRegistry serviceRegistry = new MutableHandlerRegistry();
    private List<Runnable> onShutdown = new CopyOnWriteArrayList<Runnable>();

    public RpcServer(InetSocketAddress bindAddress) {
        this.serverBuilder = this.createServer(bindAddress);
    }

    public synchronized void start() throws IOException {
        if (this.server != null) {
            return;
        }
        this.server = this.serverBuilder.build();
        this.server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.onShutdown.forEach(Runnable::run);
            }
            catch (RuntimeException re) {
                re.printStackTrace(System.err);
            }
            finally {
                try {
                    this.stop();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    e.printStackTrace(System.err);
                }
            }
        }));
    }

    public void stop() throws InterruptedException {
        if (this.server != null && !this.server.isTerminated()) {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
            this.server = null;
        }
    }

    public void addService(BindableService bindableService) {
        if (this.server != null) {
            this.serviceRegistry.addService(bindableService);
        } else {
            this.serverBuilder.addService(bindableService);
        }
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void addOnShutdownListener(Runnable runnable) {
        this.onShutdown.add(runnable);
    }

    protected ServerBuilder<?> createServer(InetSocketAddress bindAddress) {
        return this.createServerBuilder(bindAddress);
    }

    private ServerBuilder<?> createServerBuilder(InetSocketAddress bindAddress) {
        ServerCredentials serverCredentials = SecurityUtil.createServerCredentials((SecurityConfig)SecurityConfig.INSTANCE);
        Supplier<String> getRPCAddress = () -> {
            Object rpcAddress = Config.getRPCAddress();
            if (((String)rpcAddress).endsWith(":0")) {
                rpcAddress = ((String)rpcAddress).substring(0, ((String)rpcAddress).length() - 1) + this.getPort();
            }
            return rpcAddress;
        };
        return ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)bindAddress, (ServerCredentials)serverCredentials).intercept((ServerInterceptor)new AuthenticatorInterceptor(getRPCAddress))).intercept((ServerInterceptor)new SSLInterceptor())).fallbackHandlerRegistry((HandlerRegistry)this.serviceRegistry);
    }
}

