/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy.grpc;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphdb.cluster.observer.grpc.Node;
import com.ontotext.graphdb.cluster.observer.grpc.ObserverRegistration;
import com.ontotext.graphdb.cluster.observer.grpc.PingRequest;
import com.ontotext.graphdb.cluster.observer.grpc.PingResponse;
import com.ontotext.graphdb.cluster.observer.grpc.PingServiceGrpc;
import com.ontotext.graphdb.cluster.observer.grpc.RaftObserverServiceGrpc;
import com.ontotext.graphdb.cluster.observer.grpc.RegistrationAcknowledgment;
import com.ontotext.graphdb.grpc.RpcPingService;
import com.ontotext.graphdb.proxy.ClusterUpdateCallback;
import com.ontotext.graphdb.proxy.grpc.ClusterListener;
import com.ontotext.graphdb.proxy.grpc.RpcServer;
import com.ontotext.graphdb.proxy.state.ClusterStateHolder;
import com.ontotext.graphdb.proxy.state.NodeStatus;
import com.ontotext.graphdb.raft.security.RequestSignerInterceptor;
import com.ontotext.graphdb.raft.security.SecurityConfig;
import com.ontotext.graphdb.raft.security.SecurityUtil;
import common.GraphDBMDCExecutorBuilder;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClusterNodeResolver
implements Closeable,
ClusterUpdateCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int REGISTRATION_DELAY_S = 6;
    private final RpcServer rpcServer;
    private final ScheduledExecutorService executorService;
    private String currentAddress;
    private final ClusterUpdateCallback clusterUpdateCallback;
    private final ClusterStateHolder clusterStateHolder;
    private volatile boolean registered = false;
    private volatile boolean registeredWhenInSync = false;
    private AtomicBoolean registrationServiceRunning = new AtomicBoolean();
    private AtomicBoolean activeRegistration = new AtomicBoolean();
    private ScheduledFuture<?> registrationRetryFuture;
    private Set<String> rpcAddresses = ConcurrentHashMap.newKeySet();

    public RpcClusterNodeResolver(InetSocketAddress rpcBindAddress, String currentAddress, ClusterUpdateCallback clusterUpdateCallback, ClusterStateHolder clusterStateHolder) throws IOException {
        this.currentAddress = currentAddress;
        this.clusterUpdateCallback = clusterUpdateCallback;
        this.clusterStateHolder = clusterStateHolder;
        this.executorService = this.createExecutorService();
        ClusterListener clusterListener = new ClusterListener(this);
        this.rpcServer = this.createAndStartRpcServer(rpcBindAddress, (BindableService)clusterListener);
        this.rpcServer.addOnShutdownListener(this::unregister);
        if (rpcBindAddress.getPort() == 0) {
            int port = this.rpcServer.getPort();
            if (currentAddress.endsWith(":0")) {
                this.currentAddress = currentAddress.substring(0, currentAddress.length() - 1) + port;
            }
        }
    }

    public String getRpcAddress() {
        return this.currentAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister() {
        if (!this.registered) {
            return;
        }
        for (String rpcAddress : this.rpcAddresses) {
            LOGGER.info("Trying to unregister {}", (Object)rpcAddress);
            ManagedChannel channel = null;
            try {
                channel = RpcClusterNodeResolver.createChannelTo(rpcAddress).executor((Executor)this.executorService).build();
                RaftObserverServiceGrpc.RaftObserverServiceBlockingStub stub = RaftObserverServiceGrpc.newBlockingStub((Channel)channel);
                RegistrationAcknowledgment acknowledgment = ((RaftObserverServiceGrpc.RaftObserverServiceBlockingStub)stub.withDeadlineAfter(2L, TimeUnit.SECONDS)).unregister(this.createRegistration());
                if (!acknowledgment.getSuccess()) continue;
                LOGGER.info("{} successfully unregistered {}", (Object)rpcAddress, (Object)this.currentAddress);
                break;
            }
            catch (RuntimeException re) {
                LOGGER.debug("Failed to unregister observer", (Throwable)re);
            }
            finally {
                if (channel == null) continue;
                channel.shutdown();
            }
        }
    }

    protected RpcServer createAndStartRpcServer(InetSocketAddress rpcAddress, BindableService bindableService) throws IOException {
        RpcServer server = new RpcServer(rpcAddress);
        server.addService(bindableService);
        server.addService((BindableService)new RpcPingService(RpcClusterNodeResolver::createChannelTo));
        server.start();
        return server;
    }

    protected ScheduledExecutorService createExecutorService() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, new ThreadFactoryBuilder().setDaemon(true).setPriority(4).setNameFormat("raft-observer-client-%d").build());
        executor.setKeepAliveTime(10L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        return GraphDBMDCExecutorBuilder.build((ScheduledExecutorService)executor);
    }

    public void registerRpcListener(List<String> addresses) {
        List<String> rpcSupportedAddresses = addresses.stream().filter(RpcClusterNodeResolver.isRpcAddress()).collect(Collectors.toList());
        this.rpcAddresses.addAll(rpcSupportedAddresses);
        this.registerListener(rpcSupportedAddresses, this.clusterStateHolder.getCurrentClusterState().noneMatch(NodeStatus::isLeader));
    }

    public void setNoCluster() {
        this.registered = false;
        this.cancelRunningRegistration();
        this.scheduleRegistration(new ArrayList<String>(this.rpcAddresses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(Collection<String> rpcAddresses, boolean forceRegistration) {
        if (rpcAddresses.isEmpty()) {
            LOGGER.info("No RPC addresses to register");
            return;
        }
        if (!forceRegistration) {
            if (this.registered && this.registeredWhenInSync) {
                LOGGER.info("Already made a successful registration, nothing to register");
                return;
            }
            if (this.registrationServiceRunning.get()) {
                LOGGER.info("Registration service already running");
                return;
            }
        }
        if (!this.activeRegistration.compareAndSet(false, true)) {
            LOGGER.info("There is an active registration at the moment");
            return;
        }
        try {
            LOGGER.info("Pinging nodes {}", rpcAddresses);
            Map<String, ListenableFuture<PingResponse>> futureMap = this.pingNodes(rpcAddresses);
            List accessibleAddresses = this.callWhenAllFuturesAreDone(futureMap.values(), () -> this.readPingResponse(futureMap), error -> Collections.emptyList());
            if (accessibleAddresses.isEmpty() && this.scheduleRegistration(rpcAddresses)) {
                return;
            }
            for (String rpcAddress : accessibleAddresses) {
                if (!this.tryRegister(rpcAddress, rpcAddresses)) continue;
                LOGGER.info("Registration was successful on node {}", (Object)rpcAddress);
                break;
            }
            if (!this.registered || !this.registeredWhenInSync) {
                this.scheduleRegistration(rpcAddresses);
            }
        }
        catch (Exception e) {
            LOGGER.info("Could not register nodes due to: {}", (Object)e.getMessage());
            LOGGER.debug("Could not register nodes", (Throwable)e);
            this.scheduleRegistration(rpcAddresses);
        }
        finally {
            this.activeRegistration.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryRegister(String rpcAddress, Collection<String> rpcAddresses) {
        ManagedChannel channel = null;
        try {
            channel = RpcClusterNodeResolver.createChannelTo(rpcAddress).executor((Executor)this.executorService).build();
            RaftObserverServiceGrpc.RaftObserverServiceBlockingStub stub = (RaftObserverServiceGrpc.RaftObserverServiceBlockingStub)RaftObserverServiceGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(3L, TimeUnit.SECONDS);
            RegistrationAcknowledgment acknowledgment = stub.registerObserver(this.createRegistration());
            if (acknowledgment.getSuccess()) {
                this.registered = true;
                this.registeredWhenInSync = true;
                LOGGER.info("Successfully registered to receive cluster updates");
                this.cancelRunningRegistration();
                boolean bl = true;
                return bl;
            }
            LOGGER.warn("Observer registration failed with: {}", (Object)acknowledgment.getMessage());
            this.scheduleRegistration(rpcAddresses);
        }
        catch (StatusRuntimeException re) {
            if (re.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                LOGGER.warn("No connection to {}", (Object)rpcAddress);
            } else {
                LOGGER.warn("Failed observer registration to {} : {} ({})", new Object[]{rpcAddress, re.getStatus().getCode(), re.getStatus().getDescription()});
            }
            this.scheduleRegistration(rpcAddresses);
        }
        catch (Exception e) {
            LOGGER.warn("Failed observer registration: ", (Throwable)e);
            this.scheduleRegistration(rpcAddresses);
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
        return false;
    }

    public Map<String, ListenableFuture<PingResponse>> pingNodes(Collection<String> nodes) {
        LinkedHashMap<String, ListenableFuture<PingResponse>> futures = new LinkedHashMap<String, ListenableFuture<PingResponse>>(nodes.size());
        for (String clientAddress : nodes) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Contacting {}", (Object)clientAddress);
            }
            ManagedChannel channel = RpcClusterNodeResolver.createChannelTo(clientAddress).executor((Executor)this.executorService).build();
            PingServiceGrpc.PingServiceFutureStub stub = PingServiceGrpc.newFutureStub((Channel)channel);
            ListenableFuture future = ((PingServiceGrpc.PingServiceFutureStub)stub.withDeadlineAfter(2L, TimeUnit.SECONDS)).ping(PingRequest.newBuilder().setAddress(this.currentAddress).build());
            future.addListener(() -> ((ManagedChannel)channel).shutdown(), (Executor)this.executorService);
            futures.put(clientAddress, (ListenableFuture<PingResponse>)future);
        }
        return futures;
    }

    private List<String> readPingResponse(Map<String, ListenableFuture<PingResponse>> futureMap) {
        ArrayList<String> validAddresses = new ArrayList<String>();
        futureMap.forEach((address, future) -> {
            try {
                PingResponse response = (PingResponse)Futures.getDone((Future)future);
                if (response.getSuccess()) {
                    validAddresses.add((String)address);
                } else {
                    LOGGER.warn("Detected problem when contacting {}: {}", address, (Object)response.getMessage());
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof StatusRuntimeException && ((StatusRuntimeException)e.getCause()).getStatus() == Status.DEADLINE_EXCEEDED) {
                    LOGGER.warn("No connection to {}", address);
                } else {
                    LOGGER.warn("Could not ping {} due to ", address, (Object)e.getCause());
                }
                throw new RuntimeException(e.getCause());
            }
        });
        return validAddresses;
    }

    public <E, T> E callWhenAllFuturesAreDone(Collection<ListenableFuture<T>> futures, Callable<E> onComplete, Function<Throwable, E> onError) {
        Throwable error = null;
        try {
            return (E)Futures.whenAllComplete(futures).call(onComplete, (Executor)this.executorService).get();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for peer status");
            Thread.currentThread().interrupt();
            error = e;
        }
        catch (ExecutionException ee) {
            LOGGER.warn("Fail to process collected peer response", (Throwable)ee);
            error = ee.getCause();
        }
        return onError.apply(error);
    }

    private synchronized void cancelRunningRegistration() {
        if (this.registrationServiceRunning.compareAndSet(true, false)) {
            LOGGER.info("Stopping async registration");
            this.registrationRetryFuture.cancel(true);
            this.registrationRetryFuture = null;
        }
    }

    private synchronized boolean scheduleRegistration(Collection<String> rpcSupportedAddresses) {
        if (!(!this.registrationServiceRunning.compareAndSet(false, true) || this.registered && this.registeredWhenInSync)) {
            LOGGER.info("Going to retry registration to {}", rpcSupportedAddresses);
            this.registrationRetryFuture = this.executorService.scheduleAtFixedRate(() -> this.registerListener(rpcSupportedAddresses, true), 6L, 6L, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    private static Predicate<String> isRpcAddress() {
        return address -> StringUtils.isNotBlank((CharSequence)address) && !address.toLowerCase().startsWith("http");
    }

    @NotNull
    private ObserverRegistration createRegistration() {
        return ObserverRegistration.newBuilder().setRpcAddress(this.currentAddress).addFeatures(ObserverRegistration.Features.STATE_UPDATES).addFeatures(ObserverRegistration.Features.NODE_CHANGES).build();
    }

    public static ManagedChannelBuilder<?> createChannelTo(String clientAddress) {
        ChannelCredentials channelCredentials = SecurityUtil.createChannelCredentials((SecurityConfig)SecurityConfig.INSTANCE);
        return Grpc.newChannelBuilder((String)clientAddress, (ChannelCredentials)channelCredentials).intercept(new ClientInterceptor[]{new RequestSignerInterceptor(clientAddress)});
    }

    public void recheckNodeState(NodeStatus nodeStatus) {
        if (StringUtils.isNotBlank((CharSequence)nodeStatus.getRpcAddress())) {
            this.rpcAddresses.add(nodeStatus.getRpcAddress());
            this.setNoCluster();
        }
    }

    @Override
    public void close() {
        try {
            this.rpcServer.stop();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.cancelRunningRegistration();
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void nodeUpdated(NodeStatus nodeStatus) {
        try {
            this.clusterUpdateCallback.nodeUpdated(nodeStatus);
        }
        finally {
            if (!nodeStatus.notInCluster() && StringUtils.isNotBlank((CharSequence)nodeStatus.getRpcAddress())) {
                this.rpcAddresses.add(nodeStatus.getRpcAddress());
            }
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        this.rpcAddresses.remove(node.getRpcAddress());
        this.clusterUpdateCallback.nodeRemoved(node);
    }

    public void ensureRegistered(Supplier<List<String>> rpcAddressProvider) {
        if (!this.registered) {
            if (this.rpcAddresses.isEmpty()) {
                rpcAddressProvider.get().stream().filter(RpcClusterNodeResolver.isRpcAddress()).forEach(this.rpcAddresses::add);
            }
            if (!this.rpcAddresses.isEmpty()) {
                this.scheduleRegistration(this.rpcAddresses);
            }
        } else if (!this.registeredWhenInSync) {
            if (this.rpcAddresses.isEmpty()) {
                rpcAddressProvider.get().stream().filter(RpcClusterNodeResolver.isRpcAddress()).forEach(this.rpcAddresses::add);
            }
            if (!this.rpcAddresses.isEmpty()) {
                this.scheduleRegistration(this.rpcAddresses);
            }
        }
    }

    public void retryRegisterAddresses(Collection<String> addresses) {
        this.registeredWhenInSync = false;
        this.scheduleRegistration(addresses);
    }
}

