/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy.grpc;

import com.google.protobuf.FieldMask;
import com.ontotext.graphdb.cluster.observer.grpc.ClusterListenerGrpc;
import com.ontotext.graphdb.cluster.observer.grpc.ClusterUpdate;
import com.ontotext.graphdb.cluster.observer.grpc.ClusterUpdateAcknowledgment;
import com.ontotext.graphdb.cluster.observer.grpc.Node;
import com.ontotext.graphdb.cluster.observer.grpc.NodeUpdate;
import com.ontotext.graphdb.cluster.observer.grpc.NullableNode;
import com.ontotext.graphdb.cluster.observer.grpc.Status;
import com.ontotext.graphdb.cluster.observer.grpc.StatusUpdate;
import com.ontotext.graphdb.proxy.ClusterUpdateCallback;
import com.ontotext.graphdb.proxy.state.NodeStatus;
import io.grpc.stub.StreamObserver;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterListener
extends ClusterListenerGrpc.ClusterListenerImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClusterUpdateCallback clusterUpdateCallback;

    public ClusterListener(ClusterUpdateCallback clusterUpdateCallback) {
        this.clusterUpdateCallback = clusterUpdateCallback;
    }

    public void onClusterUpdate(ClusterUpdate update, StreamObserver<ClusterUpdateAcknowledgment> responseObserver) {
        FieldMask fieldMask = update.getFieldMask();
        block6: for (String maskPath : fieldMask.getPathsList()) {
            switch (ClusterChangesKeys.parse(maskPath).ordinal()) {
                case 2: {
                    StatusUpdate statusUpdate = update.getStatusUpdate();
                    this.setStatus(statusUpdate.getNode(), statusUpdate.getStatus());
                    ClusterListener.sendAcknowledgment(update, true, responseObserver);
                    continue block6;
                }
                case 4: {
                    this.setNodeUpdate(update.getNodeUpdate());
                    ClusterListener.sendAcknowledgment(update, true, responseObserver);
                    continue block6;
                }
                case 3: {
                    this.updateLeader(update.getLeaderNode());
                    ClusterListener.sendAcknowledgment(update, true, responseObserver);
                    continue block6;
                }
                case 1: {
                    ClusterListener.sendAcknowledgment(update, true, responseObserver);
                    continue block6;
                }
            }
            ClusterListener.sendAcknowledgment(update, false, responseObserver);
            LOGGER.warn("Unimplemented cluster change for: {}", (Object)maskPath);
        }
    }

    private void updateLeader(NullableNode leaderNode) {
        if (leaderNode.getKindCase() == NullableNode.KindCase.NODE) {
            this.setStatus(leaderNode.getNode(), Status.LEADER);
        }
    }

    private static void sendAcknowledgment(ClusterUpdate value, boolean isSuccess, StreamObserver<ClusterUpdateAcknowledgment> responseObserver) {
        responseObserver.onNext((Object)ClusterUpdateAcknowledgment.newBuilder().setIndex(value.getIndex()).setSuccess(isSuccess).build());
        responseObserver.onCompleted();
    }

    private void setNodeUpdate(NodeUpdate nodeUpdate) {
        switch (nodeUpdate.getOperation()) {
            case ADD: {
                this.setStatus(nodeUpdate.getNode(), Status.FOLLOWER);
                break;
            }
            case REMOVE: {
                LOGGER.info("The node '{}' has been removed from the cluster", (Object)nodeUpdate.getNode().getHttpAddress());
                this.clusterUpdateCallback.nodeRemoved(nodeUpdate.getNode());
                break;
            }
        }
    }

    private void setStatus(Node node, Status status) {
        LOGGER.info("The node '{}' is now with a status: {}", (Object)node.getHttpAddress(), (Object)status);
        this.clusterUpdateCallback.nodeUpdated(new NodeStatus(node, status));
    }

    private static enum ClusterChangesKeys {
        UNDEFINED("", -1),
        TERM_UPDATE("termUpdate", 2),
        STATUS_UPDATE("statusUpdate", 3),
        LEADER_UPDATE("leaderNode", 4),
        NODE_UPDATE("nodeUpdate", 5);

        private final String key;

        private ClusterChangesKeys(String key, int index) {
            this.key = key;
        }

        public static ClusterChangesKeys parse(String key) {
            for (ClusterChangesKeys value : ClusterChangesKeys.values()) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            return UNDEFINED;
        }
    }
}

