/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.proxy.ClusterProxyBean;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HttpServletBean;

public class ClusterProxyServlet
extends HttpServletBean {
    private static final ClusterProxyBean PROXY_BEAN = ClusterProxyBean.getInstance();

    protected void initServletBean() throws ServletException {
        PROXY_BEAN.setLogger(this.logger);
        PROXY_BEAN.init();
    }

    public void destroy() {
        PROXY_BEAN.shutdown();
    }

    @VisibleForTesting
    void setHosts(String hosts) {
        PROXY_BEAN.setHosts(hosts);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) {
        String method = req.getMethod();
        boolean requireLeader = !"HEAD".equals(method) && !"TRACE".equals(method);
        this.handleRequest(req, resp, requireLeader);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response, boolean requireLeader) {
        PROXY_BEAN.handleRequest(request, response, requireLeader);
    }
}

