/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.rdfrank;

import com.ontotext.trree.plugin.rdfrank.Configuration;
import com.ontotext.trree.plugin.rdfrank.FileRankReader;
import com.ontotext.trree.plugin.rdfrank.FileRankWriter;
import com.ontotext.trree.plugin.rdfrank.FilteredGraphReader;
import com.ontotext.trree.plugin.rdfrank.GraphReader;
import com.ontotext.trree.plugin.rdfrank.OwlimGraphReader;
import com.ontotext.trree.plugin.rdfrank.RDFRank;
import com.ontotext.trree.plugin.rdfrank.RankComputer;
import com.ontotext.trree.plugin.rdfrank.RankUtils;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.RDFRankProvider;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import com.ontotext.trree.sdk.ThreadsafePluginConnecton;
import com.ontotext.trree.sdk.UpdateInterpreter;
import com.ontotext.trree.sdk.Utils;
import com.ontotext.trree.util.BigFloatArray;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class RDFRankPlugin
extends PluginBase
implements PatternInterpreter,
UpdateInterpreter,
RDFRankProvider {
    private static final String STORAGE_FILE = "storage";
    private static final String STATE_FILE = "state";
    private static final String TEMP_SUFFIX = ".temp";
    private static final float DEFAULT_EPSILON = 0.01f;
    private static final int DEFAULT_MAX_ITERATIONS = 20;
    private static final IRI RANK_TYPE = SimpleValueFactory.getInstance().createIRI("http://www.w3.org/2001/XMLSchema#float");
    private static Map<IRI, Long> specialGraphsMapping = new HashMap<IRI, Long>(1);
    private ExecutorService executor;
    private FileRankReader rankReader = null;
    private long hasRDFRankID;
    private long hasRDFRankID_3;
    private long hasRDFRankID_4;
    private long hasRDFRankID_5;
    private long setParamID;
    private long maxIterationsID;
    private long epsilonID;
    private long computeID;
    private long computeIncrementalID;
    private long computeAsyncID;
    private long computeIncrementalAsyncID;
    private long exportID;
    private long statusID;
    private long presentID;
    private long interruptID;
    private long includedPredicates;
    private long includedGraphs;
    private long excludedPredicates;
    private long excludedGraphs;
    private long includeExplicit;
    private long includeImplicit;
    private long filtering;
    private long contextId = 0L;
    private int maxIterations = 20;
    private float epsilon = 0.01f;
    private RankComputer computer = null;
    private boolean computationInProgress;
    private boolean interrupt = false;
    private Configuration configuration;
    private Throwable error = null;

    public String getName() {
        return "rdfrank";
    }

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        this.initializeStandAlone();
        Entities entities = pluginConnection.getEntities();
        this.hasRDFRankID = entities.put((Value)RDFRank.HAS_RDF_RANK, Entities.Scope.SYSTEM);
        this.hasRDFRankID_3 = entities.put((Value)RDFRank.HAS_RDF_RANK_3, Entities.Scope.SYSTEM);
        this.hasRDFRankID_4 = entities.put((Value)RDFRank.HAS_RDF_RANK_4, Entities.Scope.SYSTEM);
        this.hasRDFRankID_5 = entities.put((Value)RDFRank.HAS_RDF_RANK_5, Entities.Scope.SYSTEM);
        this.setParamID = entities.put((Value)RDFRank.SET_PARAM, Entities.Scope.SYSTEM);
        this.maxIterationsID = entities.put((Value)RDFRank.MAX_ITERATIONS, Entities.Scope.SYSTEM);
        this.epsilonID = entities.put((Value)RDFRank.EPSILON, Entities.Scope.SYSTEM);
        this.computeID = entities.put((Value)RDFRank.COMPUTE, Entities.Scope.SYSTEM);
        this.computeIncrementalID = entities.put((Value)RDFRank.COMPUTE_INCREMENTAL, Entities.Scope.SYSTEM);
        this.computeAsyncID = entities.put((Value)RDFRank.COMPUTE_ASYNC, Entities.Scope.SYSTEM);
        this.computeIncrementalAsyncID = entities.put((Value)RDFRank.COMPUTE_ASYNC_INCREMENTAL, Entities.Scope.SYSTEM);
        this.exportID = entities.put((Value)RDFRank.EXPORT, Entities.Scope.SYSTEM);
        this.statusID = entities.put((Value)RDFRank.STATUS, Entities.Scope.SYSTEM);
        this.presentID = entities.put((Value)RDFRank.PRESENT, Entities.Scope.SYSTEM);
        this.interruptID = entities.put((Value)RDFRank.INTERRUPT, Entities.Scope.SYSTEM);
        this.filtering = entities.put((Value)RDFRank.FILTERING, Entities.Scope.SYSTEM);
        this.includedPredicates = entities.put((Value)RDFRank.INCLUDED_PREDICATES, Entities.Scope.SYSTEM);
        this.includedGraphs = entities.put((Value)RDFRank.INCLUDED_GRAPHS, Entities.Scope.SYSTEM);
        this.excludedPredicates = entities.put((Value)RDFRank.EXCLUDED_PREDICATES, Entities.Scope.SYSTEM);
        this.excludedGraphs = entities.put((Value)RDFRank.EXCLUDED_GRAPHS, Entities.Scope.SYSTEM);
        this.includeExplicit = entities.put((Value)RDFRank.INCLUDE_EXPLICIT, Entities.Scope.SYSTEM);
        this.includeImplicit = entities.put((Value)RDFRank.INCLUDE_IMPLICIT, Entities.Scope.SYSTEM);
        this.contextId = entities.put((Value)RDFRank.CONTEXT, Entities.Scope.SYSTEM);
    }

    private void initializeStandAlone() {
        this.executor = Executors.newSingleThreadExecutor();
        this.rankReader = new FileRankReader(this.getStorageFile());
        this.getDataDir().mkdirs();
        this.configuration = new Configuration(this.getStateFile());
        this.configuration.initialize();
    }

    public void shutdown(ShutdownReason shutdownReason) {
        this.executor.shutdown();
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        boolean result = this.interpretOperations(subject, predicate, object, pluginConnection);
        if (result) {
            return StatementIterator.TRUE();
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.hasRDFRankID, this.hasRDFRankID_3, this.hasRDFRankID_4, this.hasRDFRankID_5})) {
            return this.interpretHasRDFRank(subject, predicate, pluginConnection.getEntities());
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.exportID})) {
            try {
                this.exportRank(Utils.getString((Entities)pluginConnection.getEntities(), (long)object), pluginConnection.getEntities());
            }
            catch (IOException e) {
                this.getLogger().error("Export failed: " + e.getMessage());
                return StatementIterator.FALSE();
            }
            return StatementIterator.TRUE();
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.statusID})) {
            Status status = this.getStatus(pluginConnection.getEntities());
            String statusString = status.toString();
            if (status == Status.ERROR) {
                assert (this.error != null);
                statusString = statusString + " " + this.error.getMessage();
            }
            long statusRequestEntity = pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createLiteral(statusString), Entities.Scope.REQUEST);
            return StatementIterator.create((long)subject, (long)predicate, (long)statusRequestEntity, (long)context);
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.presentID})) {
            return StatementIterator.TRUE();
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.filtering})) {
            return this.configuration.getFilteringEnabled() ? StatementIterator.TRUE() : StatementIterator.FALSE();
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.includeExplicit})) {
            return this.configuration.getIncludeExplicit() ? StatementIterator.TRUE() : StatementIterator.FALSE();
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.includeImplicit})) {
            return this.configuration.getIncludeImplicit() ? StatementIterator.TRUE() : StatementIterator.FALSE();
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.includedPredicates, this.includedGraphs, this.excludedPredicates, this.excludedGraphs})) {
            return this.getFilterList(predicate, pluginConnection.getEntities());
        }
        return null;
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.setParamID, this.computeID, this.computeIncrementalID, this.computeAsyncID, this.computeIncrementalAsyncID, this.interruptID, this.includedPredicates, this.includedGraphs, this.excludedPredicates, this.excludedGraphs, this.includeExplicit, this.includeImplicit};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        this.interpretOperations(subject, predicate, object, pluginConnection);
        return true;
    }

    private boolean interpretOperations(long subject, long predicate, long object, PluginConnection pluginConnection) {
        if (Utils.match((long)predicate, (long[])new long[]{this.setParamID})) {
            if (Utils.match((long)subject, (long[])new long[]{this.maxIterationsID})) {
                this.setMaxIterations(Utils.getInteger((Entities)pluginConnection.getEntities(), (long)object));
                return true;
            }
            if (Utils.match((long)subject, (long[])new long[]{this.epsilonID})) {
                this.setEpsilon(Utils.getFloat((Entities)pluginConnection.getEntities(), (long)object).floatValue());
                return true;
            }
            if (Utils.match((long)subject, (long[])new long[]{this.filtering})) {
                this.configuration.setFilteringEnabled(Utils.getBoolean((Entities)pluginConnection.getEntities(), (long)object));
                this.configuration.save();
                return true;
            }
            if (Utils.match((long)subject, (long[])new long[]{this.includeExplicit})) {
                this.configuration.setIncludeExplicit(Utils.getBoolean((Entities)pluginConnection.getEntities(), (long)object));
                this.configuration.save();
                return true;
            }
            if (Utils.match((long)subject, (long[])new long[]{this.includeImplicit})) {
                this.configuration.setIncludeImplicit(Utils.getBoolean((Entities)pluginConnection.getEntities(), (long)object));
                this.configuration.save();
                return true;
            }
            return false;
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.computeID})) {
            this.recomputeRankSync(pluginConnection);
            return true;
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.computeIncrementalID})) {
            this.recomputeIncrementalRankSync(pluginConnection);
            return true;
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.computeAsyncID})) {
            if (pluginConnection.isInCluster()) {
                this.getLogger().warn("Asynchronous computation is not allowed in cluster mode. Computing RDF rank synchronously");
                this.recomputeRankSync(pluginConnection);
                return true;
            }
            this.recomputeRankAsync(pluginConnection);
            return true;
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.computeIncrementalAsyncID})) {
            if (pluginConnection.isInCluster()) {
                this.getLogger().warn("Asynchronous incremental computation is not allowed in cluster mode. Computing RDF rank synchronously");
                this.recomputeIncrementalRankSync(pluginConnection);
                return true;
            }
            this.recomputeIncrementalRankAsync(pluginConnection);
            return true;
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.interruptID})) {
            this.computationInterrupt(pluginConnection.getEntities());
            return true;
        }
        if (Utils.match((long)predicate, (long[])new long[]{this.includedPredicates, this.includedGraphs, this.excludedPredicates, this.excludedGraphs})) {
            if (object == 0L) {
                return false;
            }
            String operation = pluginConnection.getEntities().get(object).stringValue();
            if ("add".equals(operation)) {
                this.addToFilterList(subject, predicate, pluginConnection.getEntities());
                return true;
            }
            if ("remove".equals(operation)) {
                this.removeFromFilterList(subject, predicate, pluginConnection.getEntities());
                return true;
            }
            return false;
        }
        return false;
    }

    private StatementIterator interpretHasRDFRank(long subjectPattern, final long predicatePattern, final Entities entities) {
        final long minId = subjectPattern == 0L ? 1L : subjectPattern;
        final long maxId = subjectPattern == 0L ? entities.size() : subjectPattern;
        return new StatementIterator(){
            int digits = 5;
            {
                this.subject = minId - 1L;
                this.predicate = predicatePattern;
                if (predicatePattern == RDFRankPlugin.this.hasRDFRankID_3) {
                    this.digits = 3;
                } else if (predicatePattern == RDFRankPlugin.this.hasRDFRankID_4) {
                    this.digits = 4;
                }
            }

            public boolean next() {
                for (long id = this.subject + 1L; id <= maxId; ++id) {
                    Entities.Type entityType = entities.getType(id);
                    if (entityType != Entities.Type.URI && entityType != Entities.Type.BNODE && entityType != Entities.Type.TRIPLE) continue;
                    this.subject = id;
                    String rankString = RDFRankPlugin.this.getFormattedRank(this.subject, this.digits);
                    Literal rankLiteral = SimpleValueFactory.getInstance().createLiteral(rankString, RANK_TYPE);
                    this.object = entities.put((Value)rankLiteral, Entities.Scope.REQUEST);
                    return true;
                }
                return false;
            }

            public void close() {
                this.subject = maxId;
            }
        };
    }

    public double getRank(long id) {
        return this.rankReader.read(id);
    }

    public double getNormalizedRank(long id) {
        double number = this.getRank(id);
        double[] thresholds = this.getThresholds();
        double rank = 0.0;
        int index = RankUtils.findThresholdIndex(number, thresholds);
        if (index >= 0) {
            double min = thresholds[index];
            double max = thresholds[index + 1];
            rank = min == max ? 1.0 : ((number - min) / (max - min) + (double)(index / 2)) * (2.0 / (double)thresholds.length);
        }
        return rank;
    }

    private String getFormattedRank(long id) {
        return this.getFormattedRank(id, 2);
    }

    private String getFormattedRank(long id, int digits) {
        return RankUtils.formatWithDigits(this.getNormalizedRank(id), digits);
    }

    private double[] getThresholds() {
        return this.rankReader.getThresholds();
    }

    private int getMaxIterations() {
        return this.maxIterations;
    }

    private void setMaxIterations(int value) {
        this.maxIterations = value;
    }

    private float getEpsilon() {
        return this.epsilon;
    }

    private void setEpsilon(float value) {
        this.epsilon = value;
    }

    private synchronized void recomputeRankSync(PluginConnection pluginConnection) {
        if (this.computationInProgress) {
            this.getLogger().info("Computing RDFRank already in progress");
        }
        this.startComputation();
        try {
            this.recomputeRank(pluginConnection.getStatements(), pluginConnection.getEntities());
        }
        finally {
            this.computationInProgress = false;
        }
    }

    private synchronized void recomputeIncrementalRankSync(PluginConnection pluginConnection) {
        if (this.computationInProgress) {
            this.getLogger().info("Computing RDFRank already in progress");
        }
        this.startComputation();
        try {
            this.recomputeIncrementalRank(pluginConnection.getStatements(), pluginConnection.getEntities());
        }
        catch (IOException t) {
            this.fail(t.getMessage());
        }
        finally {
            this.computationInProgress = false;
        }
    }

    private synchronized void recomputeRankAsync(PluginConnection pluginConnection) {
        if (this.computationInProgress) {
            this.getLogger().info("Computing RDFRank already in progress");
            return;
        }
        ThreadsafePluginConnecton threadsafePluginConnecton = pluginConnection.getThreadsafeConnection();
        Statements threadSafeStatements = threadsafePluginConnecton.getStatements();
        Entities threadSafeEntities = threadsafePluginConnecton.getEntities();
        this.executor.submit(() -> {
            this.startComputation();
            try {
                this.recomputeRank(threadSafeStatements, threadSafeEntities);
            }
            catch (Throwable t) {
                this.error = t;
                this.fail(t.getMessage());
            }
            finally {
                threadsafePluginConnecton.close();
                this.computationInProgress = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeRank(Statements statements, Entities entities) {
        BigFloatArray ranks;
        this.getLogger().info("Computing RDF rank with epsilon={} max-iterations={}", (Object)Float.valueOf(this.epsilon), (Object)this.maxIterations);
        this.getDataDir().mkdirs();
        try (GraphReader reader = this.getGraphReader(statements, entities);){
            this.computer = new RankComputer();
            this.computer.setMaxIterations(this.getMaxIterations());
            this.computer.setEpsilon(this.getEpsilon());
            this.computer.setDataDir(this.getDataDir());
            this.computer.setEntityBitSize(entities.getEntityIdSize());
            ranks = this.computer.compute(reader);
        }
        if (this.interrupt || ranks == null) {
            this.computer = null;
            return;
        }
        this.persistMinMaxRankProperties();
        this.computer = null;
        long nextFingerprint = 0L;
        for (long id = 0L; id < ranks.length(); ++id) {
            nextFingerprint ^= Double.doubleToLongBits((float)id * (ranks.get(id) + 1.0f));
        }
        this.setFingerprint(nextFingerprint);
        FileRankWriter writer = new FileRankWriter(this.getTempStorageFile());
        writer.write(ranks);
        File actualFile = new File(this.getStorageFile());
        File tempFile = new File(this.getTempStorageFile());
        actualFile.delete();
        tempFile.renameTo(actualFile);
        FileRankReader fileRankReader = this.rankReader;
        synchronized (fileRankReader) {
            this.rankReader.reload();
        }
        this.configuration.setComputedConfigCash(this.configuration.hashCode());
    }

    private void fail(String message) {
        this.getLogger().error(message);
        throw new PluginException(message);
    }

    private synchronized void recomputeIncrementalRankAsync(PluginConnection pluginConnection) {
        if (this.computationInProgress) {
            this.getLogger().info("Computing RDFRank already in progress");
            return;
        }
        ThreadsafePluginConnecton threadsafePluginConnecton = pluginConnection.getThreadsafeConnection();
        Statements threadSafeStatements = threadsafePluginConnecton.getStatements();
        Entities threadSafeEntities = threadsafePluginConnecton.getEntities();
        this.executor.submit(() -> {
            this.startComputation();
            try {
                this.recomputeIncrementalRank(threadSafeStatements, threadSafeEntities);
            }
            catch (Throwable t) {
                this.error = t;
                this.fail(t.getMessage());
            }
            finally {
                threadsafePluginConnecton.close();
                this.computationInProgress = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeIncrementalRank(Statements statements, Entities entities) throws IOException {
        long nextFingerprint;
        block43: {
            double maxOldRank;
            double minOldRank;
            long endId;
            long begId;
            this.getLogger().info("Incrementally computing RDF rank");
            if (!new File(this.getStorageFile()).exists()) {
                this.fail("Can't incrementally compute rank if (proper) rank has not been computed for an (earlier) version of the repository");
            }
            if ((begId = this.rankReader.size()) >= (endId = entities.size() + 1L) || endId <= this.lastRankedId() + 1L) {
                this.getLogger().info("Nothing to be recomputed");
                return;
            }
            if (endId - begId > 100000000L) {
                this.fail("Incremental rank recomputation invoked on more than 100M new nodes");
            }
            int size = (int)(endId - begId);
            int[] nInboundLinks = new int[size];
            int[] nStableInboundLinks = new int[size];
            char[] stableInboundRank = new char[size];
            int maxLinks = 0;
            int maxStableLinks = 0;
            try {
                minOldRank = this.configuration.getMinRank();
                maxOldRank = this.configuration.getMaxRank();
            }
            catch (NullPointerException e) {
                throw new PluginException("No data for the existing rank boundaries can be found. Please perform a full computation.", (Throwable)e);
            }
            this.getLogger().info("Begin parsing of {} entities", (Object)(endId - begId));
            for (long id = begId; id < endId; ++id) {
                double norm;
                if (this.interrupt) {
                    return;
                }
                long nLinks = 0L;
                long nStableLinks = 0L;
                double stableRank = 0.0;
                try (GraphReader gr = this.getGraphReader(statements, entities, id);){
                    gr.reset();
                    while (gr.next()) {
                        ++nLinks;
                        if (gr.from >= begId) continue;
                        ++nStableLinks;
                        double subjRank = this.getRank(gr.from);
                        stableRank += subjRank;
                    }
                }
                if ((long)maxLinks < nLinks) {
                    maxLinks = (int)nLinks;
                }
                if ((long)maxStableLinks < nStableLinks) {
                    maxStableLinks = (int)nStableLinks;
                }
                if (nLinks > Integer.MAX_VALUE) {
                    this.fail("Incremental rank recomputation invoked on too densely-connected set of new nodes");
                }
                int idx = (int)(id - begId);
                nInboundLinks[idx] = (int)nLinks;
                nStableInboundLinks[idx] = (int)nStableLinks;
                double d = norm = nStableLinks != 0L ? stableRank / (double)nStableLinks : 0.0;
                assert (0.0 <= norm && norm <= 1.0) : norm;
                if (norm < 0.0) {
                    norm = 0.0;
                } else if (norm > 1.0) {
                    norm = 1.0;
                }
                stableInboundRank[idx] = (char)(norm * 65535.0);
            }
            if (maxLinks == 0) {
                this.persistLastRankedID(endId - 1L);
                return;
            }
            double minNewRank = 1.0;
            double maxNewRank = 0.0;
            this.getLogger().info("Begin rank computation");
            for (long id = begId; id < endId; ++id) {
                double c;
                int idx = (int)(id - begId);
                double simpleRank = (double)nInboundLinks[idx] / (double)maxLinks;
                double d = c = nInboundLinks[idx] != 0 ? (double)nStableInboundLinks[idx] / (double)nInboundLinks[idx] : 0.0;
                assert (0.0 <= c && c <= 1.0) : c;
                double stableRank = (double)stableInboundRank[idx] / 65535.0;
                double finalRank = c * stableRank + (1.0 - c) * simpleRank;
                assert (0.0 <= finalRank && finalRank <= 1.0) : finalRank;
                if (finalRank < 0.0) {
                    minNewRank = 0.0;
                    finalRank = 0.0;
                } else if (finalRank > 1.0) {
                    maxNewRank = 1.0;
                    finalRank = 1.0;
                }
                if (finalRank < minNewRank) {
                    minNewRank = finalRank;
                }
                if (finalRank > maxNewRank) {
                    maxNewRank = finalRank;
                }
                stableInboundRank[idx] = (char)(finalRank * 65535.0);
                if (!this.interrupt) continue;
                return;
            }
            this.getLogger().info("Begin rank normalization");
            double minAdjRank = minNewRank < minOldRank ? minOldRank : 0.5 * (minNewRank + minOldRank);
            double maxAdjRank = maxNewRank > maxOldRank ? maxOldRank : 0.5 * (maxNewRank + maxOldRank);
            RandomAccessFile raf = new RandomAccessFile(this.getStorageFile(), "rw");
            nextFingerprint = this.getFingerprint();
            try {
                this.setFilePointerToFileEnd(raf);
                if (maxNewRank - minNewRank > 1.0E-4) {
                    double q = (maxAdjRank - minAdjRank) / (maxNewRank - minNewRank);
                    double r = minAdjRank - minNewRank * q;
                    for (long id = begId; id < endId; ++id) {
                        int idx = (int)(id - begId);
                        double finalRank = (double)stableInboundRank[idx] / 65535.0;
                        assert (minNewRank <= finalRank && finalRank <= maxNewRank);
                        double adjRank = finalRank * q + r;
                        assert (minOldRank <= adjRank && adjRank <= maxOldRank);
                        raf.writeInt((int)id);
                        raf.writeDouble(adjRank);
                        nextFingerprint ^= Double.doubleToLongBits((double)id * (adjRank + 1.0));
                        if (!this.interrupt) continue;
                        break block43;
                    }
                    break block43;
                }
                for (long id = begId; id < endId; ++id) {
                    assert (minOldRank <= maxAdjRank);
                    raf.writeInt((int)id);
                    raf.writeDouble(maxAdjRank);
                    nextFingerprint ^= Double.doubleToLongBits((double)id * (maxAdjRank + 1.0));
                    if (!this.interrupt) continue;
                    break;
                }
            }
            finally {
                raf.close();
            }
        }
        this.setFingerprint(nextFingerprint);
        FileRankReader fileRankReader = this.rankReader;
        synchronized (fileRankReader) {
            this.rankReader.reload();
        }
        this.getLogger().info("Incremental rank computed");
    }

    private void setFilePointerToFileEnd(RandomAccessFile raf) throws IOException {
        raf.seek(raf.length());
    }

    private void exportRank(String path, Entities entities) throws IOException {
        try (BufferedWriter exportWriter = new BufferedWriter(new FileWriter(path));){
            int id = 1;
            while ((long)id < entities.size()) {
                if (entities.getType((long)id) == Entities.Type.URI) {
                    String formattedRank = this.getFormattedRank(id);
                    exportWriter.write(entities.get((long)id) + " " + formattedRank + "\n");
                }
                ++id;
            }
        }
    }

    private String getStorageFile() {
        return this.getDataDir() + File.separator + STORAGE_FILE;
    }

    private String getTempStorageFile() {
        return this.getStorageFile() + TEMP_SUFFIX;
    }

    private String getStateFile() {
        return this.getDataDir() + File.separator + STATE_FILE;
    }

    public long getContextId() {
        return this.contextId;
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (Utils.match((long)predicate, (long[])new long[]{this.hasRDFRankID, this.hasRDFRankID_3, this.hasRDFRankID_4, this.hasRDFRankID_5})) {
            return subject == 0L ? (double)pluginConnection.getEntities().size() : 1.0;
        }
        return 1.0;
    }

    private void startComputation() {
        this.computationInProgress = true;
        this.error = null;
        this.interrupt = false;
    }

    private void computationInterrupt(Entities entities) {
        if (this.getStatus(entities) != Status.COMPUTING) {
            return;
        }
        this.interrupt = true;
        if (this.computer != null) {
            this.computer.interrupt();
        }
    }

    private GraphReader getGraphReader(Statements statements, Entities entities) {
        return this.getGraphReader(statements, entities, 0L);
    }

    private GraphReader getGraphReader(Statements statements, Entities entities, long object) {
        if (!this.configuration.getFilteringEnabled()) {
            return new OwlimGraphReader(statements, entities, object);
        }
        Collection<Value> c1 = this.configuration.getIncludedPredicates();
        Collection<Value> c2 = this.configuration.getIncludedGraphs();
        Collection<Value> c3 = this.configuration.getExcludedPredicates();
        Collection<Value> c4 = this.configuration.getExcludedGraphs();
        boolean includeExplicit = this.configuration.getIncludeExplicit();
        boolean includeImplicit = this.configuration.getIncludeImplicit();
        return new FilteredGraphReader(statements, entities, this.createPredicatesList(c1, entities), this.createGraphList(c2, entities), this.createPredicatesList(c3, entities), this.createGraphList(c4, entities), includeExplicit, includeImplicit, object);
    }

    private StatementIterator getFilterList(long predicate, Entities entities) {
        Configuration.RDFRankProperty property = this.getRDFListPropertyFromId(predicate);
        List items = this.configuration.getValueCollection(property).stream().map(value -> entities.put(value, Entities.Scope.REQUEST)).collect(Collectors.toList());
        long[][] resultsTriples = new long[items.size()][];
        for (int i = 0; i < items.size(); ++i) {
            resultsTriples[i] = new long[]{(Long)items.get(i), predicate, entities.put((Value)SimpleValueFactory.getInstance().createLiteral("true"), Entities.Scope.SYSTEM), 0L};
        }
        return StatementIterator.create((long[][])resultsTriples);
    }

    private void addToFilterList(long valueId, long listId, Entities entities) {
        Value value;
        Configuration.RDFRankProperty property = this.getRDFListPropertyFromId(listId);
        Collection<Value> collection = this.configuration.getValueCollection(property);
        if (collection.contains(value = entities.get(valueId))) {
            this.getLogger().info("Value {} already present in the list {}", (Object)value.stringValue(), (Object)property.toString());
            return;
        }
        collection.add(value);
        this.configuration.setValueCollection(property, collection);
        this.configuration.save();
    }

    private void removeFromFilterList(long valueId, long listId, Entities entities) {
        Configuration.RDFRankProperty property = this.getRDFListPropertyFromId(listId);
        Collection<Value> collection = this.configuration.getValueCollection(property);
        if (!collection.remove(entities.get(valueId))) {
            throw new PluginException("Tried to remove Value which is not in the list: " + entities.get(valueId) + ", " + (Object)((Object)property));
        }
        this.configuration.setValueCollection(property, collection);
        this.configuration.save();
    }

    private Set<Long> createPredicatesList(Collection<Value> collection, Entities entities) {
        return collection.stream().map(value -> entities.put(value, Entities.Scope.REQUEST)).collect(Collectors.toSet());
    }

    private Set<Long> createGraphList(Collection<Value> collection, Entities entities) {
        HashSet<Long> result = new HashSet<Long>(collection.size());
        for (Value value : collection) {
            result.add(specialGraphsMapping.containsKey(value) ? specialGraphsMapping.get(value).longValue() : entities.put(value, Entities.Scope.REQUEST));
        }
        return result;
    }

    private Configuration.RDFRankProperty getRDFListPropertyFromId(long id) {
        Configuration.RDFRankProperty property = null;
        if (Utils.match((long)id, (long[])new long[]{this.includedPredicates})) {
            property = Configuration.RDFRankProperty.INCLUDED_PREDICATES_PROPERTY;
        } else if (Utils.match((long)id, (long[])new long[]{this.includedGraphs})) {
            property = Configuration.RDFRankProperty.INCLUDED_GRAPHS_PROPERTY;
        } else if (Utils.match((long)id, (long[])new long[]{this.excludedPredicates})) {
            property = Configuration.RDFRankProperty.EXCLUDED_PREDICATES_PROPERTY;
        } else if (Utils.match((long)id, (long[])new long[]{this.excludedGraphs})) {
            property = Configuration.RDFRankProperty.EXCLUDED_GRAPHS_PROPERTY;
        }
        return property;
    }

    private void persistMinMaxRankProperties() {
        this.configuration.setMinRank(this.computer.getMinRank());
        this.configuration.setMaxRank(this.computer.getMaxRank());
        this.configuration.save();
    }

    private void persistLastRankedID(long id) {
        this.configuration.setLastRankedId(id);
        this.configuration.save();
    }

    private Long lastRankedId() {
        return this.configuration.getLastRankedId();
    }

    private Status getStatus(Entities entities) {
        if (this.computationInProgress) {
            return Status.COMPUTING;
        }
        if (this.error != null) {
            return Status.ERROR;
        }
        if (this.interrupt) {
            return Status.CANCELED;
        }
        if (this.rankReader.size() == 0L) {
            return Status.EMPTY;
        }
        if (this.configurationOutdated()) {
            return Status.CONFIG_CHANGED;
        }
        if (this.rankReader.size() < entities.size() + 1L && this.lastRankedId() < entities.size()) {
            return Status.OUTDATED;
        }
        return Status.COMPUTED;
    }

    private boolean configurationOutdated() {
        if (!this.configuration.getFilteringEnabled() && (this.configuration.getLastConfigCash() & 1) == 0) {
            return false;
        }
        return this.configuration.hashCode() != this.configuration.getLastConfigCash();
    }

    static {
        specialGraphsMapping.put(SimpleValueFactory.getInstance().createIRI("http://www.openrdf.org/schema/sesame#nil"), -3L);
    }

    public static enum Status {
        CANCELED,
        COMPUTED,
        COMPUTING,
        EMPTY,
        ERROR,
        OUTDATED,
        CONFIG_CHANGED;

    }
}

