/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.geo;

public class Polygon {
    private float[] pointsLat;
    private float[] pointsLon;
    private int sz = 0;
    private boolean bReady = false;
    private float minlat = 0.0f;
    private float maxlat = 0.0f;
    private float minlon = 0.0f;
    private float maxlon = 0.0f;

    public Polygon(int numpoints) {
        this.pointsLat = new float[numpoints + 1];
        this.pointsLon = new float[numpoints + 1];
    }

    public void add(float lat, float lon) {
        if (this.bReady) {
            throw new RuntimeException("no more point should be added");
        }
        if (this.sz == 0) {
            this.minlat = this.maxlat = lat;
            this.pointsLat[this.sz] = this.maxlat;
            this.minlon = this.maxlon = lon;
            this.pointsLon[this.sz] = this.maxlon;
        } else {
            this.pointsLat[this.sz] = lat;
            this.pointsLon[this.sz] = lon;
            if (this.minlat > lat) {
                this.minlat = lat;
            }
            if (this.maxlat < lat) {
                this.maxlat = lat;
            }
            if (this.minlon > lon) {
                this.minlon = lon;
            }
            if (this.maxlon < lon) {
                this.maxlon = lon;
            }
        }
        ++this.sz;
        if (this.sz == this.pointsLat.length - 1) {
            if (this.pointsLat[0] != lat && this.pointsLon[0] != lon) {
                this.pointsLat[this.sz] = this.pointsLat[0];
                this.pointsLon[this.sz] = this.pointsLon[0];
                ++this.sz;
            }
            this.bReady = true;
        }
    }

    public boolean contains(float lat, float lon) {
        if (lat < this.minlat || lat > this.maxlat || lon < this.minlon || lon > this.maxlon) {
            return false;
        }
        int crossings = 0;
        for (int i = 0; i < this.sz - 1; ++i) {
            boolean cond3;
            double slope = (this.pointsLat[i + 1] - this.pointsLat[i]) / (this.pointsLon[i + 1] - this.pointsLon[i]);
            boolean cond1 = this.pointsLon[i] <= lon && lon < this.pointsLon[i + 1];
            boolean cond2 = this.pointsLon[i + 1] <= lon && lon < this.pointsLon[i];
            boolean bl = cond3 = (double)lat < slope * (double)(lon - this.pointsLon[i]) + (double)this.pointsLat[i];
            if (!cond1 && !cond2 || !cond3) continue;
            ++crossings;
        }
        return crossings % 2 != 0;
    }

    public float getMinLat() {
        return this.minlat;
    }

    public float getMaxLat() {
        return this.maxlat;
    }

    public float getMinLong() {
        return this.minlon;
    }

    public float getMaxLong() {
        return this.maxlon;
    }

    public boolean isReady() {
        return this.bReady;
    }
}

