/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.rtree.Node;
import com.infomatiq.jsi.rtree.RTree;
import com.ontotext.trree.plugin.geo.Utils;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TLongProcedure;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;

public class RTreeWithCoords
extends RTree {
    static final int fileMarker = -1160725808;
    private boolean isInViewMode = false;
    private int size = 0;
    private long rootNodeId = 0L;
    private LongObjectHashMap<Node> nodeMap = new LongObjectHashMap();

    public void intersects(Rectangle r, TLongObjectProcedure<Rectangle> v) {
        Node rootNode = this.getNode(this.getRootNodeId());
        this.intersects(r, v, rootNode);
    }

    private boolean intersects(Rectangle r, TLongObjectProcedure<Rectangle> v, Node n) {
        for (int i = 0; i < n.entryCount; ++i) {
            Node childNode;
            if (!Utils.intersects(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]) || !(n.isLeaf() ? !v.execute(n.ids[i], (Object)new Rectangle(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])) : !this.intersects(r, v, childNode = this.getNode(n.ids[i])))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void intersects(Rectangle r, TLongProcedure v) {
        Node rootNode = this.getNode(this.getRootNodeId());
        this.intersects(r, v, rootNode);
    }

    private boolean intersects(Rectangle r, TLongProcedure v, Node n) {
        for (int i = 0; i < n.entryCount; ++i) {
            Node childNode;
            if (!Utils.intersects(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]) || !(n.isLeaf() ? !v.execute(n.ids[i]) : !this.intersects(r, v, childNode = this.getNode(n.ids[i])))) continue;
            return false;
        }
        return true;
    }

    private boolean isInViewMode() {
        return this.isInViewMode;
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(-1160725808);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(this.size());
        out.writeLong(this.getRootNodeId());
        for (long id = 0L; id <= this.getHighestUsedNodeId(); ++id) {
            Node currentNode = this.getNode(id);
            if (currentNode == null) continue;
            out.writeLong(id);
            out.writeInt(currentNode.ids.length);
            out.writeInt(currentNode.entryCount);
            out.writeInt(currentNode.level);
            out.writeFloat(currentNode.mbrMinX);
            out.writeFloat(currentNode.mbrMinY);
            out.writeFloat(currentNode.mbrMaxX);
            out.writeFloat(currentNode.mbrMaxY);
            for (int entry = 0; entry < currentNode.entryCount; ++entry) {
                out.writeLong(currentNode.ids[entry]);
                out.writeFloat(currentNode.entriesMinX[entry]);
                out.writeFloat(currentNode.entriesMinY[entry]);
                out.writeFloat(currentNode.entriesMaxX[entry]);
                out.writeFloat(currentNode.entriesMaxY[entry]);
            }
        }
    }

    public void load(DataInputStream in) throws IOException {
        this.isInViewMode = true;
        int marker = in.readInt();
        if (marker != -1160725808) {
            throw new IOException("bad index or old version detected. please reindex!");
        }
        in.readInt();
        in.readInt();
        in.readInt();
        this.size = in.readInt();
        this.rootNodeId = in.readLong();
        while (true) {
            long id;
            try {
                id = in.readLong();
            }
            catch (EOFException eof) {
                break;
            }
            int maxNodeEntries = in.readInt();
            int entryCount = in.readInt();
            int level = in.readInt();
            Node currentNode = new Node(id, level, maxNodeEntries);
            currentNode.entryCount = entryCount;
            currentNode.mbrMinX = in.readFloat();
            currentNode.mbrMinY = in.readFloat();
            currentNode.mbrMaxX = in.readFloat();
            currentNode.mbrMaxY = in.readFloat();
            for (int entry = 0; entry < currentNode.entryCount; ++entry) {
                currentNode.ids[entry] = in.readLong();
                currentNode.entriesMinX[entry] = in.readFloat();
                currentNode.entriesMinY[entry] = in.readFloat();
                currentNode.entriesMaxX[entry] = in.readFloat();
                currentNode.entriesMaxY[entry] = in.readFloat();
            }
            this.nodeMap.put(id, (Object)currentNode);
        }
    }

    private void checkModification() {
        if (this.isInViewMode()) {
            throw new IllegalStateException("Modification not allowed once the index was persisted and restored");
        }
    }

    @Override
    public void add(Rectangle r, long id) {
        this.checkModification();
        super.add(r, id);
    }

    @Override
    public boolean delete(Rectangle r, long id) {
        this.checkModification();
        return super.delete(r, id);
    }

    @Override
    public Node getNode(long id) {
        return this.isInViewMode() ? (Node)this.nodeMap.get(id) : super.getNode(id);
    }

    @Override
    public long getRootNodeId() {
        return this.isInViewMode() ? this.rootNodeId : super.getRootNodeId();
    }

    @Override
    public int size() {
        return this.isInViewMode() ? this.size : super.size();
    }
}

