/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.config.validators;

import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.json.simple.JSONArray;

public class ListValidator<T>
implements Validator<List<T>> {
    private final Validator<T> elementValidator;
    private final Map<Integer, Validator<T>> positionalValidators;

    public ListValidator(Validator<T> elementValidator, Map<Integer, Validator<T>> positionalValidators) {
        this.elementValidator = elementValidator;
        this.positionalValidators = positionalValidators != null ? positionalValidators : Collections.emptyMap();
    }

    public ListValidator(Validator<T> elementValidator) {
        this(elementValidator, null);
    }

    @Override
    public Object validate(@Nullable List<T> value, Options optionsSet) {
        if (value == null) {
            return null;
        }
        boolean hasError = false;
        JSONArray errorMsgs = new JSONArray();
        int i = 0;
        for (T v : value) {
            Object errorMsg = this.elementValidator.validate(v, optionsSet);
            if (errorMsg != null) {
                Object otherErrorMsg = this.validateOtherPositions(v, optionsSet, i, value.size());
                if (otherErrorMsg != null) {
                    hasError = true;
                    errorMsgs.add(errorMsg);
                } else {
                    errorMsgs.add((Object)"");
                }
            } else {
                errorMsgs.add(null);
            }
            ++i;
        }
        return hasError ? errorMsgs : null;
    }

    private Object validateOtherPositions(T v, Options optionsSet, int position, int listSize) {
        Validator<T> positionValidator;
        Validator<T> lastPositionValidator;
        Object ourError = "Value is not valid";
        if (position == listSize - 1 && (lastPositionValidator = this.positionalValidators.get(Integer.MAX_VALUE)) != null) {
            ourError = lastPositionValidator.validate(v, optionsSet);
        }
        if (ourError != null && (positionValidator = this.positionalValidators.get(position)) != null) {
            ourError = positionValidator.validate(v, optionsSet);
        }
        return ourError;
    }
}

