/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.config;

import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionsParser.class);
    private final List<Option<?>> options;
    private final String defaultVersion;

    public OptionsParser(List<Option<?>> options) {
        this(options, null);
    }

    public OptionsParser(List<Option<?>> options, String defaultVersion) {
        this.options = options;
        this.defaultVersion = defaultVersion;
    }

    @Nonnull
    public Options parseFromJSON(String json) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject jobj = (JSONObject)parser.parse(json);
        return this.parseFromJSONObject(jobj);
    }

    public Options parseFromJSONObject(JSONObject jobj) {
        Options.OptionsBuilder resultBuilder = Options.builder();
        if (this.defaultVersion != null) {
            resultBuilder.setVersion(this.defaultVersion);
        }
        for (Object entry : jobj.entrySet()) {
            String key = (String)((Map.Entry)entry).getKey();
            Object value = ((Map.Entry)entry).getValue();
            if ("_version".equals(key)) {
                if (this.defaultVersion != null) {
                    throw new IllegalArgumentException("Both default version and a version from JSON found.");
                }
                resultBuilder.setVersion((String)value);
                continue;
            }
            boolean matched = false;
            for (Option<?> option : this.options) {
                if (!key.equals(option.getName())) continue;
                if (option.isDeprecated()) {
                    LOGGER.warn("Option \"{}\" has been deprecated and will be ignored!", (Object)option.getName());
                    matched = true;
                    break;
                }
                Object oldValue = resultBuilder.setOptionValue(option, value);
                if (oldValue != null) {
                    throw new IllegalArgumentException("Parameter " + key + " was presented two times in the input!");
                }
                matched = true;
                break;
            }
            if (matched) continue;
            throw new IllegalArgumentException("Parameter " + key + " is not supported!");
        }
        return resultBuilder.build();
    }
}

