/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.config;

import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.config.Option;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class Options
implements JSONAware {
    static final String VERSION_KEY = "_version";
    private final Map<String, Object> values = new HashMap<String, Object>();
    private final Set<String> unsavedKeys = new HashSet<String>();
    private String version;
    private String storeName;

    public static OptionsBuilder builder() {
        return new OptionsBuilder();
    }

    @Nullable
    public <T> T getValue(Option<T> option) {
        Object value = this.values.get(option.getName());
        if (value == null) {
            return option.getDefault();
        }
        return (T)value;
    }

    public <T> T getValueWithDefault(Option<T> option) {
        assert (option.getDefault() != null);
        return this.getValue(option);
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public <T> boolean hasExplicitValue(Option<T> option) {
        return this.values.containsKey(option.getName());
    }

    @Nonnull
    public <T> T getValueOr(Option<T> option, T defaultValueIfAbsent) {
        T value = this.getValue(option);
        if (value == null) {
            return defaultValueIfAbsent;
        }
        return value;
    }

    public <T> void setValue(Option<T> option, T value) {
        if (!option.isUpdatable()) {
            throw new ConnectorServerException("Option " + option.getName() + " is not updatable!");
        }
        this.values.put(option.getName(), value);
    }

    public <T> void unsetValue(Option<T> option) {
        if (!option.isUpdatable()) {
            throw new ConnectorServerException("Option " + option.getName() + " is not updatable!");
        }
        this.values.remove(option.getName());
    }

    public String getVersion() {
        return this.version;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Options copy() {
        Options newOptions = new Options();
        newOptions.values.putAll(this.values);
        newOptions.unsavedKeys.addAll(this.unsavedKeys);
        newOptions.version = this.version;
        newOptions.storeName = this.storeName;
        return newOptions;
    }

    public void updateOptions(Options newOptions, Iterable<Option<?>> possibleOptions) {
        for (Option<?> option : possibleOptions) {
            if (!option.isUpdatable() || !newOptions.hasExplicitValue(option)) continue;
            Object newValue = newOptions.getValue(option);
            if (newValue != null) {
                this.setValue(option, newValue);
                continue;
            }
            this.unsetValue(option);
        }
    }

    public JSONObject toJSONObject(boolean includeVersion) {
        JSONObject jsonObject = new JSONObject(this.values);
        this.unsavedKeys.forEach(arg_0 -> jsonObject.remove(arg_0));
        if (includeVersion && this.version != null) {
            jsonObject.put((Object)VERSION_KEY, (Object)this.version);
        }
        return jsonObject;
    }

    public String toJSONString() {
        return this.toJSONObject(false).toJSONString();
    }

    public String toJSONStringForUser(Set<String> redactOptions) {
        JSONObject jsonObject = this.toJSONObject(false);
        for (String redactOption : redactOptions) {
            jsonObject.put((Object)redactOption, (Object)"<redacted>");
        }
        return jsonObject.toJSONString();
    }

    public static class OptionsBuilder {
        private final Options options = new Options();

        public Options build() {
            return this.options;
        }

        public <T> Object setOptionValue(Option<T> option, T value) {
            if (option.isUnsaved()) {
                this.options.unsavedKeys.add(option.getName());
            }
            return this.options.values.put(option.getName(), value);
        }

        public OptionsBuilder setOptions(Map<String, Object> options) {
            options.putAll(options);
            return this;
        }

        public void setVersion(String version) {
            this.options.version = version;
        }
    }
}

