/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal;

import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.sse.CancellationUnsupportedHandle;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventContext;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParsingHandleUtils;
import dev.langchain4j.model.chat.response.StreamingHandle;
import dev.langchain4j.model.openai.internal.ErrorHandling;
import dev.langchain4j.model.openai.internal.Json;
import dev.langchain4j.model.openai.internal.ParsedAndRawResponse;
import dev.langchain4j.model.openai.internal.ResponseHandle;
import dev.langchain4j.model.openai.internal.StreamingCompletionHandling;
import dev.langchain4j.model.openai.internal.StreamingResponseHandling;
import java.util.function.Consumer;

class StreamingRequestExecutor<Response> {
    private final HttpClient httpClient;
    private final HttpRequest streamingHttpRequest;
    private final Class<Response> responseClass;

    StreamingRequestExecutor(HttpClient httpClient, HttpRequest streamingHttpRequest, Class<Response> responseClass) {
        this.httpClient = httpClient;
        this.streamingHttpRequest = streamingHttpRequest;
        this.responseClass = responseClass;
    }

    StreamingResponseHandling onPartialResponse(final Consumer<ParsedAndRawResponse<Response>> partialResponseHandler) {
        return new StreamingResponseHandling(){
            final /* synthetic */ StreamingRequestExecutor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public StreamingCompletionHandling onComplete(final Runnable streamingCompletionCallback) {
                return new StreamingCompletionHandling(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public ErrorHandling onError(final Consumer<Throwable> errorHandler) {
                        return new ErrorHandling(){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public ResponseHandle execute() {
                                return this.this$2.this$1.this$0.stream(partialResponseHandler, streamingCompletionCallback, errorHandler);
                            }
                        };
                    }

                    @Override
                    public ErrorHandling ignoreErrors() {
                        return new ErrorHandling(){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public ResponseHandle execute() {
                                return this.this$2.this$1.this$0.stream(partialResponseHandler, streamingCompletionCallback, e -> {});
                            }
                        };
                    }
                };
            }

            @Override
            public ErrorHandling onError(final Consumer<Throwable> errorHandler) {
                return new ErrorHandling(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public ResponseHandle execute() {
                        return this.this$1.this$0.stream(partialResponseHandler, () -> {}, errorHandler);
                    }
                };
            }

            @Override
            public ErrorHandling ignoreErrors() {
                return new ErrorHandling(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public ResponseHandle execute() {
                        return this.this$1.this$0.stream(partialResponseHandler, () -> {}, e -> {});
                    }
                };
            }
        };
    }

    private ResponseHandle stream(final Consumer<ParsedAndRawResponse<Response>> partialResponseHandler, final Runnable streamingCompletionCallback, final Consumer<Throwable> errorHandler) {
        ServerSentEventListener listener = new ServerSentEventListener(){
            volatile SuccessfulHttpResponse response;
            volatile StreamingHandle streamingHandle;
            final /* synthetic */ StreamingRequestExecutor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onOpen(SuccessfulHttpResponse response) {
                this.response = response;
            }

            @Override
            public void onEvent(ServerSentEvent event) {
                this.onEvent(event, new ServerSentEventContext(new CancellationUnsupportedHandle()));
            }

            @Override
            public void onEvent(ServerSentEvent event, ServerSentEventContext context) {
                if (this.streamingHandle == null) {
                    this.streamingHandle = ServerSentEventParsingHandleUtils.toStreamingHandle(context.parsingHandle());
                }
                if ("[DONE]".equals(event.data())) {
                    return;
                }
                try {
                    if ("error".equals(event.event())) {
                        errorHandler.accept(new RuntimeException(event.data()));
                        return;
                    }
                    Object parsedResponse = Json.fromJson(event.data(), this.this$0.responseClass);
                    if (parsedResponse != null) {
                        ParsedAndRawResponse parsedAndRawResponse = ParsedAndRawResponse.builder().parsedResponse(parsedResponse).rawHttpResponse(this.response).rawServerSentEvent(event).streamingHandle(this.streamingHandle).build();
                        partialResponseHandler.accept(parsedAndRawResponse);
                    }
                }
                catch (Exception e) {
                    errorHandler.accept(e);
                }
            }

            @Override
            public void onClose() {
                if (this.streamingHandle == null || !this.streamingHandle.isCancelled()) {
                    streamingCompletionCallback.run();
                }
            }

            @Override
            public void onError(Throwable t) {
                errorHandler.accept(t);
            }
        };
        this.httpClient.execute(this.streamingHttpRequest, listener);
        return new ResponseHandle();
    }
}

